/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.jmx.ExceptionMessage;
import com.sap.engine.services.jmx.JmxFrame;
import com.sap.engine.services.jmx.JmxServiceConnectorServerMBean;
import com.sap.engine.services.jmx.JmxServiceMessageClient;
import com.sap.engine.services.jmx.MBeanServerInvoker;
import com.sap.engine.services.jmx.Message;
import com.sap.engine.services.jmx.RequestMessage;
import com.sap.engine.services.jmx.ResponseMessage;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import com.sap.jmx.ObjectNameFactory;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class JmxServiceConnectorServer
implements MessageListener,
JmxServiceConnectorServerMBean,
MBeanRegistration {
    private static final String NAME = "JmxServiceConnector";
    private final JmxFrame frame;
    private MBeanServer server;
    private JmxServiceMessageClient invoker;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$jmx$JmxServiceConnectorServer == null ? (class$com$sap$engine$services$jmx$JmxServiceConnectorServer = JmxServiceConnectorServer.class$("com.sap.engine.services.jmx.JmxServiceConnectorServer")) : class$com$sap$engine$services$jmx$JmxServiceConnectorServer));
    static /* synthetic */ Class class$com$sap$engine$services$jmx$JmxServiceConnectorServer;

    public JmxServiceConnectorServer(JmxFrame frame) {
        this.frame = frame;
    }

    public String getType() {
        return NAME;
    }

    public void receive(int clusterId, int messageId, byte[] message, int offset, int length) {
        RequestMessage request;
        if (LOCATION.beLogged(200)) {
            LOCATION.pathT("receive(int, int, byte[], int, int)", "request received from {0}, length {1}", new Object[]{String.valueOf(clusterId), String.valueOf(length)});
        }
        try {
            request = (RequestMessage)Message.getMessageFromBytes(message, offset, length);
        }
        catch (JmxConnectorException e) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)LOCATION, (String)"receive(int, int, byte[], int, int)", (String)("Unable to de-serialize JMX request message from " + String.valueOf(clusterId) + ". The request cannot be performed."), (Throwable)((Object)e));
            return;
        }
        catch (RuntimeException e) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)LOCATION, (String)"receive(int, int, byte[], int, int)", (String)("Unable to de-serialize JMX request message from " + String.valueOf(clusterId) + ". The request cannot be performed."), (Throwable)e);
            return;
        }
        if (LOCATION.beLogged(200)) {
            LOCATION.pathT("receive(int, int, byte[], int, int)", "request from {0} successfully deserialized, request {1}", new Object[]{String.valueOf(clusterId), request == null ? null : request.toString()});
        }
        if (request.getRequestType() != 29) {
            LoggingHelper.SYS_SERVER.logT(500, LOCATION, "receive(int, int, byte[], int, int)", "Internal JMX error: Unexpected asynchronous request message received, source " + clusterId + ", message " + request == null ? null : request.toString());
        } else {
            try {
                this.invoker.invokeMbsAsync(request);
            }
            catch (JmxConnectorException e) {
                LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)LOCATION, (String)"receive(int, int, byte[], int, int)", (String)("Unable to process JMX request message from " + String.valueOf(clusterId) + ". The following request cannot be performed: " + request), (Throwable)((Object)e));
                return;
            }
            catch (RuntimeException e) {
                LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)LOCATION, (String)"receive(int, int, byte[], int, int)", (String)("Unable to process JMX request message from " + String.valueOf(clusterId) + ". The following request cannot be performed: " + request), (Throwable)e);
            }
            if (LOCATION.beLogged(200)) {
                LOCATION.pathT("receive(int, int, byte[], int, int)", "request execution finished successfully for request {1} from {0}", new Object[]{String.valueOf(clusterId), request == null ? null : request.toString()});
            }
        }
    }

    public MessageAnswer receiveWait(int clusterId, int messageId, byte[] message, int offset, int length) {
        ResponseMessage response;
        RequestMessage request = null;
        if (LOCATION.beLogged(200)) {
            LOCATION.pathT("receiveWait(int, int, byte[], int, int)", "request received from {0}, length {1}", new Object[]{String.valueOf(clusterId), String.valueOf(length)});
        }
        try {
            request = (RequestMessage)Message.getMessageFromBytes(message, offset, length);
            response = this.invoker.invokeMbs(request);
            if (LOCATION.beLogged(200)) {
                LOCATION.pathT("receiveWait(int, int, byte[], int, int)", "request execution finished successfully for request {1} from {0}", new Object[]{String.valueOf(clusterId), request == null ? null : request.toString()});
            }
        }
        catch (JmxConnectorException e) {
            if (LOCATION.beLogged(200)) {
                LoggingHelper.traceThrowable((int)200, (Location)LOCATION, (String)"receiveWait(int, int, byte[], int, int)", (Throwable)((Object)e));
            }
            response = new ExceptionMessage((Throwable)((Object)e));
        }
        catch (RuntimeException e) {
            if (LOCATION.beLogged(200)) {
                LoggingHelper.traceThrowable((int)200, (Location)LOCATION, (String)"receiveWait(int, int, byte[], int, int)", (Throwable)e);
            }
            response = new ExceptionMessage((Throwable)((Object)new JmxConnectorException("jmx_2207", e)));
        }
        try {
            MessageAnswer answer = new MessageAnswer(response.getMsg(), response.getMsgOff(), response.getMsgLen());
            if (LOCATION.beLogged(200)) {
                LOCATION.pathT("receiveWait(int, int, byte[], int, int)", "answer serialization finished successfully for request {1} from {0}", new Object[]{String.valueOf(clusterId), request == null ? null : request.toString()});
            }
            return answer;
        }
        catch (Exception e) {
            response = e instanceof JmxConnectorException ? new ExceptionMessage(e) : new ExceptionMessage((Throwable)((Object)new JmxConnectorException("jmx_2207", e)));
            try {
                return new MessageAnswer(response.getMsg(), response.getMsgOff(), response.getMsgLen());
            }
            catch (Exception innerE) {
                LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)LOCATION, (String)"receiveWait(int, int, byte[], int, int)", (String)("Unable to pass JMX response to client " + clusterId + ", response: " + response + ", request was: " + request), (Throwable)innerE);
                return new MessageAnswer();
            }
        }
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.frame.getClusterContext().getMessageContext().unregisterListener();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.invoker = new MBeanServerInvoker(server, this.frame.getListenerIndex());
        this.frame.getClusterContext().getMessageContext().registerListener((MessageListener)this);
        return this.getObjectName();
    }

    private ObjectName getObjectName() throws MalformedObjectNameException {
        return ObjectNameFactory.getNameForServerChildPerNode((String)this.getClass().getName(), (String)NAME, (String)this.frame.getElementIdAsString(), (String)this.frame.getSystemName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

