/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.JmxFrame;
import com.sap.engine.services.jmx.JmxServiceConnectorServerInvoker;
import com.sap.engine.services.jmx.JmxServiceMessageClient;
import com.sap.engine.services.jmx.MBeanServerConnectionImpl;
import com.sap.engine.services.jmx.MBeanServerConnectionSecurityWrapper;
import com.sap.engine.services.jmx.MessageClientSecurityWrapper;
import com.sap.engine.services.jmx.client.JmxConnector;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import com.sap.engine.services.jmx.exception.JmxIllegalArgumentException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;

public final class JmxServiceConnectorClient
implements com.sap.jmx.remote.JmxConnector,
JmxConnector {
    public static final String ADDRESS_PREFIX = "service:jmx:com.sap.engine.services.jmx.connector.n2n:";
    private final JmxServiceMessageClient secureMessageClient;
    private final JmxServiceMessageClient messageClient;
    private final int targetIdInt;
    private final JmxFrame frame;
    private final Map connProps;

    public JmxServiceConnectorClient(String targetID, JmxFrame frame, Map props) throws JmxConnectorException {
        this.frame = frame;
        try {
            this.targetIdInt = Integer.parseInt(targetID);
        }
        catch (NumberFormatException e) {
            throw new JmxIllegalArgumentException("jmx_1304", new Object[]{targetID});
        }
        this.messageClient = new JmxServiceConnectorServerInvoker(this.targetIdInt, frame);
        this.secureMessageClient = new MessageClientSecurityWrapper(frame, this.messageClient);
        this.connProps = props == null ? new HashMap(2) : new HashMap(props);
        Object classLoader = this.connProps.get("StreamClassLoader");
        if (!(classLoader instanceof ClassLoader)) {
            classLoader = Thread.currentThread().getContextClassLoader();
            this.connProps.put("StreamClassLoader", classLoader);
        }
    }

    public MBeanServerConnection getMBeanServerConnection() throws JmxConnectorException {
        MBeanServerConnectionImpl wrappedMbs = new MBeanServerConnectionImpl(this.messageClient, this.targetIdInt, this.frame, this.connProps, 1);
        return new MBeanServerConnectionSecurityWrapper(this.frame, wrappedMbs);
    }

    public MBeanServerConnection getMBeanServerConnection(ClassLoader classLoader) throws JmxConnectorException {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        HashMap<String, ClassLoader> props = this.connProps;
        if (classLoader != null) {
            props = new HashMap<String, ClassLoader>(this.connProps);
            props.put("StreamClassLoader", classLoader);
        }
        MBeanServerConnectionImpl wrappedMbs = new MBeanServerConnectionImpl(this.messageClient, this.targetIdInt, this.frame, props, 1);
        return new MBeanServerConnectionSecurityWrapper(this.frame, wrappedMbs);
    }

    public JmxServiceMessageClient getMessageClient() {
        return this.secureMessageClient;
    }
}

