/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.exception.JmxIllegalArgumentException;
import com.sap.engine.services.jmx.exception.JmxIndexOutOfBoundsException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class JmxServiceByteArrayOutputStream
extends ByteArrayOutputStream {
    protected byte[] buf;
    protected int bufOff;
    protected int bufCount;
    protected int bufPos;
    protected boolean increaseSize;

    public JmxServiceByteArrayOutputStream() {
        super(0);
        this.increaseSize = true;
        this.buf = new byte[32];
        this.bufOff = 0;
        this.bufCount = this.buf.length;
        this.bufPos = 0;
    }

    public JmxServiceByteArrayOutputStream(byte[] b, boolean increaseSize) {
        super(0);
        this.setByteArray(b, increaseSize);
    }

    public JmxServiceByteArrayOutputStream(byte[] b, int off, int len, boolean increaseSize) {
        this.setByteArray(b, off, len, increaseSize);
    }

    public void setByteArray(byte[] b, boolean increaseSize) {
        this.setByteArray(b, 0, b.length, increaseSize);
    }

    public void setByteArray(byte[] b, int off, int len, boolean increaseSize) {
        if (b == null) {
            throw new JmxIllegalArgumentException("jmx_1317");
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new JmxIndexOutOfBoundsException();
        }
        this.increaseSize = increaseSize;
        this.buf = b;
        this.bufOff = off;
        this.bufCount = off + len;
        this.bufPos = off;
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    public void write(byte[] b, int off, int len) {
        if (b == null) {
            new JmxIllegalArgumentException("jmx_1317");
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new JmxIndexOutOfBoundsException();
        }
        if (this.bufPos + len > this.bufCount) {
            if (this.increaseSize) {
                byte[] newbuf = new byte[Math.max(this.bufCount - this.bufOff << 1, this.bufPos + len - this.bufOff)];
                System.arraycopy(this.buf, this.bufOff, newbuf, 0, this.bufPos - this.bufOff);
                this.buf = newbuf;
                this.bufCount = this.buf.length;
                this.bufPos -= this.bufOff;
                this.bufOff = 0;
            } else {
                throw new JmxIndexOutOfBoundsException();
            }
        }
        System.arraycopy(b, off, this.buf, this.bufPos, len);
        this.bufPos += len;
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(int b) {
        if (this.bufPos + 1 > this.bufCount) {
            if (this.increaseSize) {
                byte[] newbuf = new byte[Math.max(this.bufCount - this.bufOff << 1, this.bufPos + 1 - this.bufOff)];
                System.arraycopy(this.buf, this.bufOff, newbuf, 0, this.bufPos - this.bufOff);
                this.buf = newbuf;
                this.bufCount = this.buf.length;
                this.bufPos -= this.bufOff;
                this.bufOff = 0;
            } else {
                throw new JmxIndexOutOfBoundsException();
            }
        }
        this.buf[this.bufPos++] = (byte)b;
    }

    public int getBufOff() {
        return this.bufOff;
    }

    public void ensureCapacity(int len) {
        if (this.bufPos + len > this.bufCount) {
            if (this.increaseSize) {
                byte[] newbuf = new byte[Math.max(this.bufCount - this.bufOff << 1, this.bufPos + len - this.bufOff)];
                System.arraycopy(this.buf, this.bufOff, newbuf, 0, this.bufPos - this.bufOff);
                this.buf = newbuf;
                this.bufCount = this.buf.length;
                this.bufPos -= this.bufOff;
                this.bufOff = 0;
            } else {
                throw new JmxIndexOutOfBoundsException();
            }
        }
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public int getCurrentPos() {
        return this.bufPos - this.bufOff;
    }

    public void setCurrentPos(int pos) {
        if (pos < 0 || this.bufOff + pos > this.bufCount) {
            throw new JmxIndexOutOfBoundsException();
        }
        this.bufPos = this.bufOff + pos;
    }

    public void reset() {
        this.setCurrentPos(0);
    }

    public int size() {
        return this.bufCount - this.bufOff;
    }

    public synchronized byte[] toByteArray() {
        byte[] newBuf = new byte[this.size()];
        System.arraycopy(this.buf, this.bufOff, newBuf, 0, newBuf.length);
        return newBuf;
    }

    public String toString() {
        return new String(this.buf, this.bufOff, this.size());
    }

    public String toString(int hibyte) {
        return new String(this.buf, hibyte, this.bufOff, this.size());
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buf, this.bufOff, this.size(), enc);
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, this.bufOff, this.size());
    }
}

