/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.util.various;

import com.tssap.selena.model.elements.ModelDeltaNode;
import java.util.Enumeration;

public class DeltaDumper {
    public static void dumpDelta(ModelDeltaNode node) {
        System.err.println("DeltaDump started for node :" + node);
        DeltaDumper.dumpDelta(node, 0);
        System.err.println("DeltaDump ended for node :" + node);
    }

    private static void dumpDelta(ModelDeltaNode node, int tabsLevel) {
        String nodeFlags = "";
        String changesState = "";
        if (node.isTotallyChanged()) {
            changesState = changesState + "###";
        }
        if (node.isChanged()) {
            changesState = changesState + "*";
        }
        if (node.isNew()) {
            changesState = changesState + "+";
        }
        if (node.isDeleted()) {
            changesState = changesState + "-";
        }
        System.err.println(DeltaDumper.getTabs(tabsLevel) + "[" + changesState + "] deltaNode:" + " (" + nodeFlags + "):" + node.getElementUniqueName());
        if (node.getOriginalElementUniqueName() != null && !node.getOriginalElementUniqueName().equals(node.getElementUniqueName())) {
            System.err.println(DeltaDumper.getTabs(tabsLevel) + "[#] deltaNode: " + node.getOriginalElementUniqueName() + " => " + node.getElementUniqueName());
        }
        Enumeration children = node.changedChildren();
        while (children.hasMoreElements()) {
            DeltaDumper.dumpDelta((ModelDeltaNode)children.nextElement(), tabsLevel + 1);
        }
    }

    private static String getTabs(int level) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < level) {
            result.append("\t");
            ++i;
        }
        return result.toString();
    }
}

