/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.util.text;

import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.text.IOCloser;
import com.tssap.selena.model.util.text.IOccurenceInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class FileContentsReplacer {
    private static final int BUFFER_SIZE = 1024;
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getReplacedContents(IFile file, SortedSet occurences, String replace) throws CoreException {
        String string;
        InputStream stream = file.getContents();
        InputStreamReader in = null;
        StringBuffer result = new StringBuffer();
        try {
            try {
                in = new InputStreamReader((InputStream)new BufferedInputStream(stream), ResourcesPlugin.getEncoding());
                int curOffset = 0;
                Iterator infos = occurences.iterator();
                while (true) {
                    if (!infos.hasNext()) {
                        result.append(FileContentsReplacer.copyAllRemaining(in));
                        string = result.toString();
                        Object var11_11 = null;
                        break;
                    }
                    IOccurenceInfo curInfo = (IOccurenceInfo)infos.next();
                    int nextOffset = curInfo.getStart();
                    result.append(FileContentsReplacer.copyUntilNextOccurence(in, nextOffset - curOffset));
                    in.skip(curInfo.getLength());
                    result.append(replace);
                    curOffset = nextOffset + curInfo.getLength();
                }
            }
            catch (IOException badIO) {
                throw FileContentsReplacer.newCoreException(badIO);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            IOCloser.perform(in, stream);
            throw throwable;
        }
        IOCloser.perform(in, stream);
        return string;
    }

    public static void processFile(IFile file, SortedSet occurences, String replace) throws CoreException {
        String replacedContents = FileContentsReplacer.getReplacedContents(file, occurences, replace);
        ByteArrayInputStream replacedStream = null;
        try {
            try {
                replacedStream = new ByteArrayInputStream(replacedContents.getBytes(ResourcesPlugin.getEncoding()));
                file.setContents((InputStream)replacedStream, true, true, NULL_MONITOR);
            }
            catch (UnsupportedEncodingException badEncoding) {
                badEncoding.printStackTrace();
                throw FileContentsReplacer.newCoreException(badEncoding);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            IOCloser.perform(null, replacedStream);
            throw throwable;
        }
        IOCloser.perform(null, replacedStream);
    }

    protected static String copyUntilNextOccurence(InputStreamReader reader, int bytes) throws IOException {
        Assert.isLegal(bytes >= 0);
        if (bytes == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(1024);
        char[] buffer = new char[1024];
        while (bytes > 0) {
            int n = reader.read(buffer, 0, Math.min(1024, bytes));
            result.append(buffer, 0, n);
            bytes -= 1024;
        }
        return result.toString();
    }

    protected static String copyAllRemaining(InputStreamReader reader) throws IOException {
        StringBuffer result = new StringBuffer(1024);
        char[] buffer = new char[1024];
        int n = reader.read(buffer, 0, 1024);
        while (n > 0) {
            result.append(buffer, 0, n);
            n = reader.read(buffer, 0, 1024);
        }
        return result.toString();
    }

    protected static CoreException newCoreException(Exception enclosed) {
        return new CoreException((IStatus)new Status(4, "com.tssap.selena.model", 0, enclosed.getMessage(), (Throwable)enclosed));
    }
}

