/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.util.extension;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.PropertyAdapter;
import com.tssap.selena.model.util.SingleEnumeration;
import com.tssap.selena.model.util.extension.AbstractProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractPropertyReader
extends AbstractProvider
implements PropertyGetProvider {
    private Set myPropertyNames;

    public boolean hasProperty(Element element, String propertyName) {
        return this.getPropertyValue(element, propertyName) != null;
    }

    public Property getProperty(Element element, String propertyName) {
        String propertyValue = this.getPropertyValue(element, propertyName);
        if (propertyValue == null) {
            return null;
        }
        return this.getProperty(element, propertyName, propertyValue);
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        if (propertyValue == null) {
            return false;
        }
        return propertyValue.equals(this.getPropertyValue(element, propertyName));
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        Property property = this.getProperty(element, propertyName);
        return property == null ? EmptyEnumeration.getPropertyEnumeration() : SingleEnumeration.createPropertyEnumeration(property);
    }

    public PropertyEnumeration properties(Element element) {
        Set propertyNames = this.getPropertyNames();
        if (propertyNames == null || propertyNames.isEmpty()) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        ArrayList<Property> properties = new ArrayList<Property>(propertyNames.size());
        Iterator propertyNamesIt = this.getPropertyNames().iterator();
        while (propertyNamesIt.hasNext()) {
            Property property = this.getProperty(element, (String)propertyNamesIt.next());
            if (property == null) continue;
            properties.add(property);
        }
        return EnumerationConverter.toPropertyEnumeration(properties.iterator());
    }

    protected Property getProperty(Element element, String propertyName, String propertyValue) {
        return new PropertyAdapter(propertyName, propertyValue, element);
    }

    protected String unknownProperty(String propertyName) {
        throw new RuntimeException("Unknown property [" + propertyName + "]");
    }

    protected Set getPropertyNames() {
        if (this.myPropertyNames == null) {
            this.myPropertyNames = new HashSet();
        }
        return this.myPropertyNames;
    }

    public abstract String getPropertyValue(Element var1, String var2);

    public abstract boolean isPropertyProviderApplicable(Element var1, String var2);
}

