/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.util.extension;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.LinkProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.SingleEnumeration;
import com.tssap.selena.model.util.extension.AbstractProvider;
import com.tssap.selena.model.util.various.LinkRolesEnumeration;

public abstract class AbstractLinkProvider
extends AbstractProvider
implements LinkProvider {
    protected abstract UniqueName getClient(Entity var1);

    protected abstract UniqueName getSupplier(Entity var1);

    public StringEnumeration participantRoles(Entity link) {
        return new LinkRolesEnumeration();
    }

    public UniqueNameEnumeration participants(Entity link, String role) {
        UniqueName uniqueName;
        if ("Client".equals(role)) {
            uniqueName = this.getClient(link);
        } else if ("Supplier".equals(role)) {
            uniqueName = this.getSupplier(link);
        } else {
            throw new IllegalArgumentException(role);
        }
        if (uniqueName == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        return SingleEnumeration.createUniqueNameEnumeration(uniqueName);
    }

    public boolean canSetParticipant(Entity link, Element participant, String oldRole, String newRole) {
        return false;
    }

    public void setParticipant(Entity link, Element participant, String oldRole, String newRole) {
    }

    protected boolean canSetSupplier(Entity link, Element oldParticipant, Element newParticipant) {
        return false;
    }

    public boolean canSetParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        if ("Client".equals(role)) {
            return false;
        }
        if ("Supplier".equals(role)) {
            return this.canSetSupplier(link, oldParticipant, newParticipant);
        }
        throw new IllegalArgumentException(role);
    }

    protected void setSupplier(Entity link, Element oldParticipant, Element newParticipant) {
    }

    public void setParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        if ("Client".equals(role)) {
            return;
        }
        if ("Supplier".equals(role)) {
            this.setSupplier(link, oldParticipant, newParticipant);
            return;
        }
        throw new IllegalArgumentException(role);
    }

    public abstract boolean isLinkProviderApplicable(Entity var1);
}

