/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.util.delta;

import com.tssap.selena.model.elements.ModelDeltaNode;

public abstract class ModelDeltaNodeKind {
    public static final ModelDeltaNodeKind UNKNOWN = new ModelDeltaNodeKind(){

        public boolean isNew() {
            return false;
        }

        public boolean isChanged() {
            return false;
        }

        public boolean isDeleted() {
            return false;
        }

        public boolean isTotallyChanged() {
            return false;
        }

        public ModelDeltaNodeKind merge(ModelDeltaNodeKind other) {
            return other;
        }

        public String toString() {
            return "UNKNOWN";
        }
    };
    public static final ModelDeltaNodeKind NEW = new ModelDeltaNodeKind(){

        public boolean isNew() {
            return true;
        }

        public boolean isChanged() {
            return false;
        }

        public boolean isDeleted() {
            return false;
        }

        public boolean isTotallyChanged() {
            return false;
        }

        public ModelDeltaNodeKind merge(ModelDeltaNodeKind other) {
            if (other == DELETED) {
                return other;
            }
            return this;
        }

        public String toString() {
            return "NEW";
        }
    };
    public static final ModelDeltaNodeKind CHANGED = new ModelDeltaNodeKind(){

        public boolean isNew() {
            return false;
        }

        public boolean isChanged() {
            return true;
        }

        public boolean isDeleted() {
            return false;
        }

        public boolean isTotallyChanged() {
            return false;
        }

        public ModelDeltaNodeKind merge(ModelDeltaNodeKind other) {
            if (other == UNKNOWN) {
                return this;
            }
            return other;
        }

        public String toString() {
            return "CHANGED";
        }
    };
    public static final ModelDeltaNodeKind TOTALLY_CHANGED = new ModelDeltaNodeKind(){

        public boolean isNew() {
            return false;
        }

        public boolean isChanged() {
            return true;
        }

        public boolean isDeleted() {
            return false;
        }

        public boolean isTotallyChanged() {
            return true;
        }

        public ModelDeltaNodeKind merge(ModelDeltaNodeKind other) {
            if (other == DELETED) {
                return other;
            }
            return this;
        }

        public String toString() {
            return "TOTALLY_CHANGED";
        }
    };
    public static final ModelDeltaNodeKind DELETED = new ModelDeltaNodeKind(){

        public boolean isNew() {
            return false;
        }

        public boolean isChanged() {
            return false;
        }

        public boolean isDeleted() {
            return true;
        }

        public boolean isTotallyChanged() {
            return false;
        }

        public ModelDeltaNodeKind merge(ModelDeltaNodeKind other) {
            if (other == NEW) {
                return other;
            }
            return this;
        }

        public String toString() {
            return "DELETED";
        }
    };

    private ModelDeltaNodeKind() {
    }

    public abstract boolean isNew();

    public abstract boolean isChanged();

    public abstract boolean isDeleted();

    public abstract boolean isTotallyChanged();

    public abstract ModelDeltaNodeKind merge(ModelDeltaNodeKind var1);

    public static ModelDeltaNodeKind guess(ModelDeltaNode node) {
        if (node == null) {
            return null;
        }
        if (node.isDeleted()) {
            return DELETED;
        }
        if (node.isTotallyChanged()) {
            return TOTALLY_CHANGED;
        }
        if (node.isNew()) {
            return NEW;
        }
        if (node.isChanged()) {
            return CHANGED;
        }
        return UNKNOWN;
    }
}

