/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.util.delta;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.TreeModelDeltaNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class DefaultModelDeltaNode
implements TreeModelDeltaNode {
    private ModelDeltaNodeKind myKind;
    private UniqueName myUniqueName;
    private List myChildren;
    private Model myModel;

    public DefaultModelDeltaNode(Model model, UniqueName uniqueName, ModelDeltaNodeKind kind, boolean node) {
        this(model, uniqueName, kind);
    }

    public DefaultModelDeltaNode(Model model, UniqueName uniqueName, ModelDeltaNodeKind kind) {
        this.myModel = model;
        if (this.myModel == null) {
            throw new NullPointerException("Attempt to create model delta node whithout model");
        }
        this.myUniqueName = uniqueName;
        if (this.myUniqueName == null) {
            throw new NullPointerException("Attempt to create model delta node whithout unique name");
        }
        this.myKind = kind;
        if (this.myKind == null) {
            this.myKind = ModelDeltaNodeKind.UNKNOWN;
        }
    }

    protected static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public boolean equalsSemantically(ModelDeltaNode other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!DefaultModelDeltaNode.equals(this.getElementUniqueName(), other.getElementUniqueName())) {
            return false;
        }
        if (!DefaultModelDeltaNode.equals(this.getOriginalElementUniqueName(), other.getOriginalElementUniqueName())) {
            return false;
        }
        if (this.isNew() ^ other.isNew()) {
            return false;
        }
        if (this.isChanged() ^ other.isChanged()) {
            return false;
        }
        if (this.isTotallyChanged() ^ other.isTotallyChanged()) {
            return false;
        }
        return !(this.isDeleted() ^ other.isDeleted());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultModelDeltaNode)) {
            return false;
        }
        DefaultModelDeltaNode other = (DefaultModelDeltaNode)object;
        return this.myUniqueName.equals(other.myUniqueName);
    }

    public int hashCode() {
        return this.myUniqueName.hashCode();
    }

    public void makeTotallyChanged() {
        this.myKind = ModelDeltaNodeKind.TOTALLY_CHANGED;
    }

    public boolean isEmpty() {
        return (this.myChildren == null || this.myChildren.isEmpty()) && !this.isNew() && !this.isChanged() && !this.isDeleted() && !this.isTotallyChanged();
    }

    public boolean isNew() {
        return this.myKind.isNew();
    }

    public boolean isChanged() {
        return this.myKind.isChanged();
    }

    public boolean isDeleted() {
        return this.myKind.isDeleted();
    }

    public boolean isTotallyChanged() {
        return this.myKind.isTotallyChanged();
    }

    public UniqueName getElementUniqueName() {
        return this.myUniqueName;
    }

    public UniqueName getOriginalElementUniqueName() {
        return this.getElementUniqueName();
    }

    public Element getElement() {
        return this.myModel.findEntity(this.getElementUniqueName());
    }

    public UniqueName getParentUniqueName() {
        Element element = this.getElement();
        if (element == null) {
            return null;
        }
        Entity parent = element.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getUniqueName();
    }

    public TreeModelDeltaNode createParentDeltaNode() {
        UniqueName parentUniqueName = this.getParentUniqueName();
        if (parentUniqueName == null) {
            return null;
        }
        return new DefaultModelDeltaNode(this.getModel(), parentUniqueName, ModelDeltaNodeKind.UNKNOWN, true);
    }

    public boolean hasChildren() {
        return this.myChildren != null && !this.myChildren.isEmpty();
    }

    public Enumeration changedChildren() {
        return this.myChildren == null ? EmptyEnumeration.getStringEnumeration() : EnumerationConverter.toStringEnumeration(Collections.enumeration(this.myChildren));
    }

    public TreeModelDeltaNode addChild(TreeModelDeltaNode modelDeltaNode) {
        if (modelDeltaNode == null) {
            throw new NullPointerException("Attempt to add null child to model delta node");
        }
        UniqueName uniqueName = modelDeltaNode.getElementUniqueName();
        if (uniqueName == null) {
            throw new NullPointerException("Attempt to add model delta node without element unique name");
        }
        if (this.myChildren != null && this.myChildren.contains(modelDeltaNode)) {
            int index = this.myChildren.indexOf(modelDeltaNode);
            return index != -1 ? (TreeModelDeltaNode)this.myChildren.get(index) : null;
        }
        if (this.myChildren == null) {
            this.myChildren = new ArrayList();
        } else {
            Iterator existing = this.myChildren.iterator();
            while (existing.hasNext()) {
                TreeModelDeltaNode existingNode = (TreeModelDeltaNode)existing.next();
                if (!uniqueName.equals(existingNode.getElementUniqueName())) continue;
                existingNode.mergeModelDeltaNodes(modelDeltaNode);
                return existingNode;
            }
        }
        this.myChildren.add(modelDeltaNode);
        return modelDeltaNode;
    }

    public void mergeModelDeltaNodes(ModelDeltaNode modelDeltaNode) {
        if (this.myUniqueName.equals(modelDeltaNode.getElementUniqueName())) {
            ModelDeltaNodeKind otherKind = ModelDeltaNodeKind.guess(modelDeltaNode);
            this.myKind = this.myKind.merge(otherKind);
        }
        Enumeration newChildren = modelDeltaNode.changedChildren();
        while (newChildren.hasMoreElements()) {
            TreeModelDeltaNode node;
            ModelDeltaNode child = (ModelDeltaNode)newChildren.nextElement();
            if (!(child instanceof TreeModelDeltaNode) || (node = this.addChild((TreeModelDeltaNode)child)) == child) continue;
            node.mergeModelDeltaNodes(child);
        }
    }

    protected Model getModel() {
        return this.myModel;
    }
}

