/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.util.delta;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class CompositeModelDeltaNode
implements ModelDeltaNode {
    private UniqueName myElementUniqueName;
    private UniqueName myOriginalUniqueName;
    private final Model myModel;
    private final List myWrapedDeltaNodes = new ArrayList();
    private List myChangedChildren = null;
    private boolean myIsEntity;
    private boolean myIsNode;
    private boolean myIsLink;
    private boolean myIsReferenceCollection;
    private boolean myIsTotallyChanged;
    private boolean myIsNew;
    private boolean myIsDeleted;
    private boolean myIsChanged;
    private boolean myKnowBooleanAnswers = false;
    private boolean myElementFound = false;
    private Element myElement;

    public CompositeModelDeltaNode(ModelDeltaNode node, Model model) {
        this(model);
        this.addNode(node);
    }

    public CompositeModelDeltaNode(Model model) {
        this.myModel = model;
    }

    public UniqueName getElementUniqueName() {
        return this.myElementUniqueName;
    }

    public UniqueName getOriginalElementUniqueName() {
        if (this.myWrapedDeltaNodes == null) {
            return null;
        }
        if (this.myOriginalUniqueName != null) {
            return this.myOriginalUniqueName;
        }
        Iterator wrapped = this.myWrapedDeltaNodes.iterator();
        while (wrapped.hasNext()) {
            ModelDeltaNode cur = (ModelDeltaNode)wrapped.next();
            UniqueName result = cur.getOriginalElementUniqueName();
            if (result == null || result.equals(cur.getElementUniqueName())) continue;
            return result;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.myWrapedDeltaNodes == null || this.myWrapedDeltaNodes.isEmpty();
    }

    public Element getElement() {
        if (!this.myElementFound) {
            this.myElement = CompositeModelDeltaNode.findElement(this.myModel, this.myElementUniqueName);
            this.myElementFound = true;
        }
        return this.myElement;
    }

    private static Element findElement(Model model, UniqueName uin) {
        if (uin instanceof ReferenceUniqueName) {
            return model.findReference((ReferenceUniqueName)uin);
        }
        Entity result = model.findReferenceCollection(uin);
        if (result == null) {
            result = model.findEntity(uin);
        }
        return result;
    }

    public Enumeration changedChildren() {
        if (this.myChangedChildren == null) {
            TreeMap<UniqueName, CompositeModelDeltaNode> nodesForName = new TreeMap<UniqueName, CompositeModelDeltaNode>();
            int i = 0;
            while (i < this.myWrapedDeltaNodes.size()) {
                ModelDeltaNode node1 = (ModelDeltaNode)this.myWrapedDeltaNodes.get(i);
                Enumeration hisChildren = node1.changedChildren();
                if (hisChildren != null) {
                    while (hisChildren.hasMoreElements()) {
                        ModelDeltaNode child = (ModelDeltaNode)hisChildren.nextElement();
                        UniqueName un = child.getElementUniqueName();
                        CompositeModelDeltaNode compositeChild = (CompositeModelDeltaNode)nodesForName.get(un);
                        if (compositeChild == null) {
                            nodesForName.put(un, new CompositeModelDeltaNode(child, this.myModel));
                            continue;
                        }
                        compositeChild.addNode(child);
                    }
                }
                ++i;
            }
            this.myChangedChildren = new ArrayList(nodesForName.values());
        }
        return Collections.enumeration(this.myChangedChildren);
    }

    public boolean isTotallyChanged() {
        this.findOutBooleanAnswers();
        return this.myIsTotallyChanged;
    }

    public boolean isEntity() {
        this.findOutBooleanAnswers();
        return this.myIsEntity;
    }

    public boolean isNode() {
        this.findOutBooleanAnswers();
        return this.myIsNode;
    }

    public boolean isLink() {
        this.findOutBooleanAnswers();
        return this.myIsLink;
    }

    public boolean isReferenceCollection() {
        this.findOutBooleanAnswers();
        return this.myIsReferenceCollection;
    }

    public boolean isNew() {
        this.findOutBooleanAnswers();
        return this.myIsNew;
    }

    public boolean isDeleted() {
        this.findOutBooleanAnswers();
        return this.myIsDeleted;
    }

    public boolean isChanged() {
        this.findOutBooleanAnswers();
        return this.myIsChanged;
    }

    public void addNode(ModelDeltaNode node) {
        if (node == null) {
            return;
        }
        this.myKnowBooleanAnswers = false;
        if (this.myElementUniqueName == null) {
            this.myElementUniqueName = node.getElementUniqueName();
        }
        if (this.myElementUniqueName == null || this.myElementUniqueName.equals(node.getElementUniqueName())) {
            // empty if block
        }
        if ((node.isNew() || node.isDeleted()) && !node.getElementUniqueName().equals(node.getOriginalElementUniqueName())) {
            this.myOriginalUniqueName = node.getOriginalElementUniqueName();
        }
        this.myWrapedDeltaNodes.add(node);
    }

    protected void releaseWrappedNodes() {
        this.myWrapedDeltaNodes.clear();
    }

    private final void findOutBooleanAnswers() {
        if (this.myKnowBooleanAnswers) {
            return;
        }
        this.myIsEntity = false;
        this.myIsNode = false;
        this.myIsLink = false;
        this.myIsReferenceCollection = false;
        this.myIsChanged = false;
        this.myIsDeleted = false;
        this.myIsNew = false;
        this.myIsTotallyChanged = false;
        int i = 0;
        while (i < this.myWrapedDeltaNodes.size()) {
            ModelDeltaNode node1 = (ModelDeltaNode)this.myWrapedDeltaNodes.get(i);
            this.myIsNew = this.myIsNew || node1.isNew();
            this.myIsDeleted = this.myIsDeleted || node1.isDeleted();
            this.myIsChanged = this.myIsChanged || node1.isChanged();
            this.myIsTotallyChanged = this.myIsTotallyChanged || node1.isTotallyChanged();
            ++i;
        }
        this.myIsEntity = this.myIsEntity || this.myIsNode || this.myIsLink;
        this.myKnowBooleanAnswers = true;
    }
}

