/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.util;

import java.util.StringTokenizer;

public class UinEscaper {
    private static final String ESCAPE = "%";
    private static final char ESCAPE_CHAR = "%".charAt(0);
    private static final String SPECIAL = "%:@#";
    private static final char[] SPECIAL_CHARS;

    private UinEscaper() {
    }

    public static String escape(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        int i = 0;
        while (i < SPECIAL_CHARS.length) {
            if (s.indexOf(SPECIAL_CHARS[i]) >= 0) {
                return UinEscaper.escapeHelper(s);
            }
            ++i;
        }
        return s;
    }

    public static String unescape(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.indexOf(ESCAPE_CHAR) >= 0) {
            return UinEscaper.unescapeHelper(s);
        }
        return s;
    }

    private static String escapeHelper(String s) {
        StringBuffer buffer = new StringBuffer(s.length() * 3);
        StringTokenizer st = new StringTokenizer(s, SPECIAL, true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 1 && SPECIAL.indexOf(token.charAt(0)) >= 0) {
                buffer.append(ESCAPE_CHAR);
                buffer.append(UinEscaper.getReplace(token.charAt(0)));
                continue;
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    private static String unescapeHelper(String s) {
        StringBuffer buffer = new StringBuffer(s.length());
        StringTokenizer st = new StringTokenizer(s, ESCAPE, true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 1 && token.charAt(0) == ESCAPE_CHAR) {
                if (!st.hasMoreTokens()) {
                    throw new IllegalArgumentException(s);
                }
                token = st.nextToken();
                if (token.length() < 2) {
                    throw new IllegalArgumentException(s);
                }
                buffer.append(UinEscaper.getSpecial(token.substring(0, 2)));
                if (token.length() <= 2) continue;
                buffer.append(token.substring(2));
                continue;
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    private static String getReplace(char special) {
        String s = Integer.toHexString((byte)special);
        return s.length() < 2 ? String.valueOf(0) + s : s;
    }

    private static char getSpecial(String replace) {
        try {
            return (char)Integer.parseInt(replace, 16);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(replace);
        }
    }

    static {
        if (ESCAPE.length() != 1) {
            throw new IllegalStateException();
        }
        SPECIAL_CHARS = SPECIAL.toCharArray();
        if (SPECIAL.length() > 9) {
            throw new IllegalStateException();
        }
    }
}

