/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.util;

import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;

public abstract class SingleEnumeration {
    public static PropertyEnumeration createPropertyEnumeration(Property property) {
        return new SinglePropertyEnumeration(property);
    }

    public static StringEnumeration createStringEnumeration(String string) {
        return new SingleStringEnumeration(string);
    }

    public static UniqueNameEnumeration createUniqueNameEnumeration(UniqueName uin) {
        return new SingleUniqueNameEnumeration(uin);
    }

    private static class SingleUniqueNameEnumeration
    implements UniqueNameEnumeration {
        private UniqueName uniqueName = null;

        public SingleUniqueNameEnumeration(UniqueName uniqueName) {
            this.uniqueName = uniqueName;
        }

        public UniqueName next() {
            UniqueName result = this.uniqueName;
            this.uniqueName = null;
            return result;
        }

        public boolean hasMoreElements() {
            return this.uniqueName != null;
        }

        public Object nextElement() {
            return this.next();
        }
    }

    private static class SingleStringEnumeration
    implements StringEnumeration {
        private String string = null;

        public SingleStringEnumeration(String string) {
            this.string = string;
        }

        public String next() {
            String result = this.string;
            this.string = null;
            return result;
        }

        public boolean hasMoreElements() {
            return this.string != null;
        }

        public Object nextElement() {
            return this.next();
        }
    }

    private static class SinglePropertyEnumeration
    implements PropertyEnumeration {
        private Property property = null;

        public SinglePropertyEnumeration(Property property) {
            this.property = property;
        }

        public Property next() {
            Property result = this.property;
            this.property = null;
            return result;
        }

        public boolean hasMoreElements() {
            return this.property != null;
        }

        public Object nextElement() {
            return this.next();
        }
    }
}

