/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.util;

import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.selena.model.util.Assert;

public class ReferencesUinSupport {
    public static UniqueName getReferencedUin(Reference reference) {
        Assert.isLegal(reference.getUniqueName() instanceof ReferenceUniqueName, "wrong instance of reference unique name");
        return ((ReferenceUniqueName)reference.getUniqueName()).getReferencedUniqueName();
    }

    public static Reference findReference(ReferenceCollection collection, Entity entity) {
        if (collection instanceof ReferenceContainer) {
            return ReferencesUinSupport.findReference((ReferenceContainer)collection, entity.getUniqueName());
        }
        return null;
    }

    private static Reference findReference(ReferenceContainer container, UniqueName entityUniqueName) {
        Reference result = null;
        ReferenceEnumeration references = container.references();
        while (result == null && references.hasMoreElements()) {
            Reference next = references.next();
            if (entityUniqueName.equals(next.getEntity().getUniqueName())) {
                return next;
            }
            if (!(next instanceof ReferenceContainer)) continue;
            result = ReferencesUinSupport.findReference(next, entityUniqueName);
        }
        return result;
    }
}

