/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.util;

import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ModelUinSupport {
    public static final String getProjectId(UniqueName modelUin) {
        return modelUin.getName();
    }

    public static final IProject getProject(UniqueName modelUin) {
        String projectId = ModelUinSupport.getProjectId(modelUin);
        IPath path = Path.ROOT.append(projectId);
        if (path.segmentCount() != 1) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectId);
    }

    public static final UniqueName createModelUin(String projectId) {
        UniqueName result = ModelAccess.createModelUniqueName(projectId);
        Assert.isLegal(result.getName() != null);
        Assert.isLegal(projectId.equals(result.getName()));
        return result;
    }

    public static final UniqueName createModelUin(IResource resource) {
        String projectId = resource.getProject().getName();
        return ModelUinSupport.createModelUin(projectId);
    }

    public static boolean isModelUin(UniqueName uin) {
        return ModelAccess.getModel(uin) != null;
    }
}

