/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.elements;

import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.EmptyEnumeration;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class ModelAccess {
    public static final String MODEL_DOMAIN = "model";
    public static final String PROJECT_SUBDOMAIN = "project";
    private static HashSet ourModelAccessListeners = new HashSet();
    protected static ModelAccess implementation;
    private static Set ourListeners;

    public static void addModelAccessListener(ModelAccessListener listener) {
        HashSet hashSet = ourModelAccessListeners;
        synchronized (hashSet) {
            ourModelAccessListeners.add(listener);
        }
    }

    public static void removeModelAccessListener(ModelAccessListener listener) {
        HashSet hashSet = ourModelAccessListeners;
        synchronized (hashSet) {
            ourModelAccessListeners.remove(listener);
        }
    }

    public static final void notifyModelCreated(Model model) {
        HashSet hashSet = ourModelAccessListeners;
        synchronized (hashSet) {
            ModelAccessEvent event = new ModelAccessEvent(model);
            Iterator listeners = ourModelAccessListeners.iterator();
            while (listeners.hasNext()) {
                ModelAccessListener curListener = (ModelAccessListener)listeners.next();
                curListener.modelCreated(event);
            }
        }
    }

    public static final void notifyModelDeleted(Model model) {
        HashSet hashSet = ourModelAccessListeners;
        synchronized (hashSet) {
            ModelAccessEvent event = new ModelAccessEvent(model);
            Iterator listeners = ourModelAccessListeners.iterator();
            while (listeners.hasNext()) {
                ModelAccessListener curListener = (ModelAccessListener)listeners.next();
                curListener.modelRemoved(event);
            }
        }
    }

    public static ReferenceUniqueName createReferenceUniqueName(UniqueName referenceUniqueName, UniqueName entityUniqueName) {
        if (implementation == null) {
            throw new IllegalStateException("Model Implementation was not setted");
        }
        return implementation.createReferenceUniqueNameObject(referenceUniqueName, entityUniqueName);
    }

    public static UniqueName createUniqueName(String domain, String subdomain, String location, String name, String[] parameters) {
        if (implementation == null) {
            throw new IllegalStateException("Model Implementation was not setted");
        }
        return implementation.createUniqueNameObject(domain, subdomain, location, name, parameters);
    }

    public static UniqueName createUniqueName(String uniqueName) {
        if (implementation == null) {
            throw new IllegalStateException("Model Implementation was not setted");
        }
        return implementation.createUniqueNameObject(uniqueName);
    }

    public static UniqueName createUniqueName(String domain, String location, String name) {
        if (implementation == null) {
            throw new IllegalStateException("Model Implementation was not setted");
        }
        return implementation.createUniqueNameObject(domain, null, location, name, null);
    }

    protected abstract UniqueName createUniqueNameObject(String var1, String var2, String var3, String var4, String[] var5);

    protected abstract UniqueName createUniqueNameObject(String var1);

    protected abstract ReferenceUniqueName createReferenceUniqueNameObject(UniqueName var1, UniqueName var2);

    public static UniqueName createModelUniqueName(String modelId) {
        return ModelAccess.createUniqueName(MODEL_DOMAIN, PROJECT_SUBDOMAIN, null, modelId, null);
    }

    public static Model createModel(UniqueName modelUin) {
        Model existingModel = ModelAccess.getModel(modelUin);
        if (existingModel != null) {
            return existingModel;
        }
        Model result = implementation.createModelObject(modelUin);
        ModelAccess.notifyModelCreated(result);
        return result;
    }

    public static boolean hasModel(UniqueName modelUin) {
        return ModelAccess.getModel(modelUin) != null;
    }

    public static Model getModel(UniqueName modelUin) {
        if (modelUin == null) {
            return null;
        }
        Enumeration models = ModelAccess.models();
        while (models.hasMoreElements()) {
            Model model = (Model)models.nextElement();
            if (!modelUin.equals(model.getUniqueName())) continue;
            return model;
        }
        return null;
    }

    public static Enumeration models() {
        if (implementation == null && implementation == null) {
            return EmptyEnumeration.getEnumeration();
        }
        return implementation.modelObjects();
    }

    public static void runCommand(Runnable command) {
        ModelAccess.runCommand(command, null);
    }

    public static void runCommandLater(Runnable command) {
        ModelAccess.runCommandLater(command, null);
    }

    public static void runCommand(Runnable command, String name) {
        if (implementation != null) {
            implementation.runCommandObject(command, name);
        }
    }

    public static void runCommandLater(Runnable command, String name) {
        if (implementation != null) {
            implementation.runCommandObjectLater(command, name);
        }
    }

    protected static void setImplementation(ModelAccess impl) {
        implementation = impl;
    }

    protected static ModelAccess getImplementation() {
        return implementation;
    }

    protected abstract Model createModelObject(UniqueName var1);

    protected abstract Enumeration modelObjects();

    protected abstract void runCommandObject(Runnable var1, String var2);

    protected abstract void runCommandObjectLater(Runnable var1, String var2);

    static {
        ourListeners = Collections.synchronizedSet(new HashSet());
    }
}

