/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.view;

import com.tssap.selena.impl.model.elements.Diagnostic;
import com.tssap.selena.impl.model.elements.ModelImpl;
import com.tssap.selena.impl.model.elements.ModelPlugin;
import com.tssap.selena.impl.model.elements.ReferenceCollectionContent;
import com.tssap.selena.impl.model.elements.ReferenceCollectionManager;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.platform.DebugLevel;
import com.tssap.selena.model.platform.ViewFactoryDescriptor;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.various.DeltaDumper;
import com.tssap.selena.model.view.View;
import com.tssap.selena.model.view.ViewFactory;
import com.tssap.selena.model.view.ViewFactoryEx;
import com.tssap.selena.model.view.ViewManager;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class ViewManagerImpl
implements ViewManager {
    private UniqueName myModelUin;
    private Map myCollection2views = new HashMap();
    private Set myFactories;
    private Set myParentMetaclasses = new HashSet();

    public ViewManagerImpl(UniqueName modelUin) {
        this.myModelUin = modelUin;
    }

    public void registerViewFactory(ViewFactory viewFactory) {
        this.getFactories().add(viewFactory);
        if (viewFactory instanceof ModelAware) {
            ((ModelAware)((Object)viewFactory)).registered(ModelAccess.getModel(this.myModelUin));
        }
    }

    public void unregisterViewFactory(ViewFactory viewFactory) {
        this.getFactories().remove(viewFactory);
        if (viewFactory instanceof ModelAware) {
            ((ModelAware)((Object)viewFactory)).unregistered(ModelAccess.getModel(this.myModelUin));
        }
    }

    public boolean canCreateView(ReferenceCollection collection, String type) {
        Iterator factories = this.getFactories().iterator();
        while (factories.hasNext()) {
            ViewFactory factory = (ViewFactory)factories.next();
            if (!factory.canCreateView(collection, type)) continue;
            return true;
        }
        return false;
    }

    public View createView(ReferenceCollection collection, String type, IProgressMonitor pm) {
        View result = null;
        Iterator factories = this.getFactories().iterator();
        while (result == null && factories.hasNext()) {
            ViewFactory factory = (ViewFactory)factories.next();
            if (!factory.canCreateView(collection, type)) continue;
            result = factory instanceof ViewFactoryEx && pm != null ? ((ViewFactoryEx)factory).createView(collection, type, pm) : factory.createView(collection, type);
            List views = this.getViews(collection);
            if (views == null || views.contains(result)) continue;
            Diagnostic.trace("update", "view added : " + result + " : " + collection.getPropertyValue("$name"));
            views.add(result);
        }
        if (result != null && ReferenceCollectionManager.getContent(collection) == null) {
            ReferenceCollectionManager.createContent(collection);
        }
        this.myParentMetaclasses = ViewManagerImpl.collectParentMetaclasses(collection, null);
        return result;
    }

    private static Set collectParentMetaclasses(Entity element, Set target) {
        if (target == null) {
            target = new HashSet<String>();
        }
        if (element != null) {
            target.add(element.getPropertyValue("$metaclass"));
            return ViewManagerImpl.collectParentMetaclasses(element.getParent(), target);
        }
        return target;
    }

    private void collectDeletedNodes(Entity parent, ModelDeltaNode delta, Collection deletedUins, Set parents) {
        if (delta == null) {
            return;
        }
        if (delta.isDeleted()) {
            if (parent == null) {
                return;
            }
            if (this.myParentMetaclasses.contains(parent.getPropertyValue("$metaclass"))) {
                ViewManagerImpl.collectParentMetaclasses(parent, parents);
            }
            deletedUins.add(delta.getElementUniqueName());
            return;
        }
        if (delta.getElement() != null) {
            Enumeration deltas = delta.changedChildren();
            while (deltas.hasMoreElements()) {
                ModelDeltaNode node = (ModelDeltaNode)deltas.nextElement();
                this.collectDeletedNodes((Entity)delta.getElement(), node, deletedUins, parents);
            }
        }
    }

    public void update(ModelDeltaNode modelDelta) {
        HashMap copy = new HashMap(this.myCollection2views);
        Iterator collections = copy.entrySet().iterator();
        while (collections.hasNext()) {
            ModelDeltaNode delta;
            Map.Entry entry = collections.next();
            UniqueName refcoluin = (UniqueName)entry.getKey();
            ReferenceCollectionContent content = ReferenceCollectionManager.getContent(refcoluin);
            if (content == null || (delta = content.getDelta()) == null || delta.isEmpty()) continue;
            if (!delta.isEmpty() || delta.isTotallyChanged()) {
                ((ModelImpl)ModelAccess.getModel(this.myModelUin)).setUpdatePerformed(true);
                ((ModelImpl)ModelAccess.getModel(this.myModelUin)).setLastUpdateTime();
            }
            List views = (List)entry.getValue();
            int i = 0;
            while (i < views.size()) {
                Diagnostic.trace("update", "dispatching RC delta to : " + views.get(i) + " : " + ((View)views.get(i)).getReferenceCollection().getPropertyValue("$name"));
                if (DebugLevel.ALL.equals(Diagnostic.getLogLevel("update"))) {
                    DeltaDumper.dumpDelta(delta);
                }
                Diagnostic.trace("update", "RC update finished");
                ((View)views.get(i)).update(delta);
                ++i;
            }
        }
        if (modelDelta == null) {
            return;
        }
        HashSet deletedUinsSet = new HashSet();
        HashSet parentsSet = new HashSet();
        this.collectDeletedNodes(null, modelDelta, deletedUinsSet, parentsSet);
        Iterator deletedUins = deletedUinsSet.iterator();
        while (deletedUins.hasNext()) {
            if (!this.myCollection2views.containsKey(deletedUins.next())) continue;
            this.refresh();
            return;
        }
        Iterator parents = parentsSet.iterator();
        while (parents.hasNext()) {
            if (!this.myParentMetaclasses.contains(parents.next())) continue;
            this.refresh();
            return;
        }
    }

    private void refresh() {
        Diagnostic.trace("update", "refresh");
        HashMap copy = new HashMap(this.myCollection2views);
        Iterator collections = copy.keySet().iterator();
        while (collections.hasNext()) {
            ReferenceCollection collection;
            UniqueName uin = (UniqueName)collections.next();
            ReferenceCollectionContent content = ReferenceCollectionManager.getContent(uin);
            if (content == null || (collection = content.getCollection()) == null || !collection.isDeleted()) continue;
            Iterator views = ((AbstractList)new ArrayList(this.getViews(collection))).iterator();
            while (views.hasNext()) {
                View view = (View)views.next();
                Diagnostic.trace("update", "view is disposed during refresh : " + view);
                this.disposeView(view);
            }
        }
    }

    public void updateAllViews() {
        DefaultModelDeltaNode delta = null;
        ModelImpl model = (ModelImpl)ModelAccess.getModel(this.myModelUin);
        if (this.views().hasMoreElements()) {
            model.setUpdatePerformed(true);
            model.setLastUpdateTime();
        }
        ArrayList<View> viewsToDelete = new ArrayList<View>();
        Enumeration views = this.views();
        while (views.hasMoreElements()) {
            View view = (View)views.nextElement();
            if (view.getReferenceCollection().isDeleted()) {
                viewsToDelete.add(view);
                continue;
            }
            delta = new DefaultModelDeltaNode(model, view.getReferenceCollection().getUniqueName(), ModelDeltaNodeKind.TOTALLY_CHANGED, true);
            delta.makeTotallyChanged();
            List viewList = (List)this.myCollection2views.get(view.getReferenceCollection().getUniqueName());
            if (!viewList.contains(view)) continue;
            view.update(delta);
        }
        Iterator it = ((AbstractList)viewsToDelete).iterator();
        while (it.hasNext()) {
            View element = (View)it.next();
            this.disposeView(element);
        }
    }

    public Enumeration views() {
        ArrayList result = new ArrayList();
        Iterator viewLists = this.myCollection2views.values().iterator();
        while (viewLists.hasNext()) {
            List views = (List)viewLists.next();
            result.addAll(views);
        }
        return Collections.enumeration(result);
    }

    private List getViews(ReferenceCollection refcol) {
        ArrayList result = (ArrayList)this.myCollection2views.get(refcol.getUniqueName());
        if (result == null) {
            result = new ArrayList();
            this.myCollection2views.put(refcol.getUniqueName(), result);
        }
        return result;
    }

    public void disposeView(View view) {
        if (view == null) {
            return;
        }
        ReferenceCollection viewedCollection = view.getReferenceCollection();
        if (viewedCollection == null) {
            return;
        }
        List otherViews = (List)this.myCollection2views.get(viewedCollection.getUniqueName());
        if (otherViews == null) {
            return;
        }
        otherViews.remove(view);
        if (otherViews.isEmpty()) {
            this.myCollection2views.remove(viewedCollection);
            ReferenceCollectionManager.removeContent(viewedCollection);
        }
        view.dispose();
    }

    private Iterator getManagedCollections() {
        return this.myCollection2views.entrySet().iterator();
    }

    private Collection getFactories() {
        if (this.myFactories == null) {
            this.myFactories = new HashSet();
            Enumeration vfDescriptors = ModelPlugin.getDefault().getPlatform().viewFactoryDescriptors();
            while (vfDescriptors.hasMoreElements()) {
                ViewFactoryDescriptor vfDescriptor = (ViewFactoryDescriptor)vfDescriptors.nextElement();
                ViewFactory viewFactory = vfDescriptor.instantiateViewFactory();
                if (viewFactory == null) continue;
                if (viewFactory instanceof ModelAware) {
                    ((ModelAware)((Object)viewFactory)).registered(ModelAccess.getModel(this.myModelUin));
                }
                this.myFactories.add(viewFactory);
            }
        }
        return this.myFactories;
    }

    private void dumpViews() {
        System.err.println("ViewManager: dump started");
        Iterator it = this.myCollection2views.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            UniqueName uin = (UniqueName)entry.getKey();
            System.err.println("\t" + uin);
            List views = (List)entry.getValue();
            Iterator itViews = views.iterator();
            while (itViews.hasNext()) {
                View cur = (View)itViews.next();
                System.err.println("\t\t :" + cur);
                if (cur.getReferenceCollection() == null) {
                    System.err.println("\t\t\t : collection : NULL !!!");
                    continue;
                }
                System.err.println("\t\t\t : collection : (" + cur.getReferenceCollection().hashCode() + ")" + cur.getReferenceCollection());
            }
        }
        System.out.println("-------------------");
    }

    public View createView(ReferenceCollection collection, String type) {
        return this.createView(collection, type, null);
    }
}

