/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.test.provider;

import com.tssap.selena.impl.model.test.provider.Content;
import com.tssap.selena.impl.model.test.provider.ModelDeltaNodeKind;
import com.tssap.selena.impl.model.test.provider.ReferenceDeltaNodeImpl;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ReferenceUniqueNameEnumeration;
import com.tssap.selena.model.extension.DeleteProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.extension.ReferenceDeltaTreeProvider;
import com.tssap.selena.model.extension.ReferenceExistenceProvider;
import com.tssap.selena.model.extension.ReferenceParentProvider;
import com.tssap.selena.model.extension.ReferenceProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.LinkedList;

public class TestReferenceProvider
implements Content,
ReferenceExistenceProvider,
ReferenceProvider,
DeleteProvider,
ReferenceParentProvider,
ParentProvider,
ReferenceDeltaTreeProvider {
    private boolean myReferenceWasAddedFlag = false;
    private Model myModel;
    private final ReferenceDeltaNodeImpl ON_ADD_DELTA = new ReferenceDeltaNodeImpl(Content.DEFAULT_COLLECTION_UIN, ModelDeltaNodeKind.CONNECTION);
    private final ReferenceDeltaNodeImpl ON_DELETE_DELTA;
    private ModelDeltaNode myReferenceDelta;

    public TestReferenceProvider() {
        this.ON_ADD_DELTA.addChild(Content.REF_TOP_UIN, ModelDeltaNodeKind.CONNECTION).addChild(Content.REF_MIDDLE_UIN, ModelDeltaNodeKind.CONNECTION).addChild(Content.REF_DEEP_UIN, ModelDeltaNodeKind.ADDED);
        this.ON_DELETE_DELTA = new ReferenceDeltaNodeImpl(Content.DEFAULT_COLLECTION_UIN, ModelDeltaNodeKind.CONNECTION);
        this.ON_DELETE_DELTA.addChild(Content.REF_TOP_UIN, ModelDeltaNodeKind.CONNECTION).addChild(Content.REF_MIDDLE_UIN, ModelDeltaNodeKind.CONNECTION).addChild(Content.REF_DEEP_UIN, ModelDeltaNodeKind.DELETED);
        this.myReferenceDelta = null;
    }

    public void setModel(Model model) {
        this.myModel = model;
    }

    public void registered(Model model) {
    }

    public void unregistered(Model model) {
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Reference template) {
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Reference template) {
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return Content.REF_TOP_UIN.equals(uniqueName) || Content.REF_MIDDLE_UIN.equals(uniqueName) || this.myReferenceWasAddedFlag && Content.REF_DEEP_UIN.equals(uniqueName);
    }

    public boolean isReferenceProviderApplicable(ReferenceContainer container) {
        if (container instanceof Element) {
            UniqueName containerUin = ((Element)((Object)container)).getUniqueName();
            return Content.DEFAULT_COLLECTION_UIN.equals(containerUin) || Content.REF_TOP_UIN.equals(containerUin) || Content.REF_MIDDLE_UIN.equals(containerUin) || Content.REF_DEEP_UIN.equals(containerUin);
        }
        return false;
    }

    public ReferenceUniqueNameEnumeration references(ReferenceContainer container) {
        UniqueName containerUin = ((Element)((Object)container)).getUniqueName();
        LinkedList<ReferenceUniqueName> result = new LinkedList<ReferenceUniqueName>();
        if (Content.DEFAULT_COLLECTION_UIN.equals(containerUin)) {
            result.add(Content.REF_TOP_UIN);
        } else if (Content.REF_TOP_UIN.equals(containerUin)) {
            result.add(Content.REF_MIDDLE_UIN);
        } else if (Content.REF_MIDDLE_UIN.equals(containerUin) && this.myReferenceWasAddedFlag) {
            result.add(Content.REF_DEEP_UIN);
        }
        return EnumerationConverter.toReferenceUniqueNameEnumeration(result.iterator());
    }

    public boolean canAddReference(ReferenceContainer container, Reference template, Entity entity) {
        UniqueName containerUin = ((Element)((Object)container)).getUniqueName();
        if (Content.REF_MIDDLE_UIN.equals(containerUin) && entity.getUniqueName().equals(Content.DEEP_UIN_1)) {
            return !this.myReferenceWasAddedFlag;
        }
        return false;
    }

    public ReferenceUniqueName addReference(ReferenceContainer container, Reference template, Entity entity) {
        this.myReferenceWasAddedFlag = true;
        this.myReferenceDelta = this.ON_ADD_DELTA;
        this.myModel.getExtensionManager().referenceCollectionContentsChanged(Content.DEFAULT_COLLECTION_UIN);
        return Content.REF_DEEP_UIN;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        UniqueName uin = element.getUniqueName();
        return uin.equals(Content.REF_DEEP_UIN) || uin.equals(Content.REF_MIDDLE_UIN) || uin.equals(Content.REF_TOP_UIN);
    }

    public boolean canDelete(Element element) {
        UniqueName uin = element.getUniqueName();
        return uin.equals(Content.REF_DEEP_UIN) && this.myReferenceWasAddedFlag;
    }

    public void delete(Element element) {
        this.myReferenceWasAddedFlag = false;
        this.myReferenceDelta = this.ON_DELETE_DELTA;
        this.myModel.getExtensionManager().referenceCollectionContentsChanged(Content.DEFAULT_COLLECTION_UIN);
    }

    public boolean isDeleted(Element element) {
        UniqueName uin = element.getUniqueName();
        if (uin.equals(Content.REF_DEEP_UIN)) {
            return !this.myReferenceWasAddedFlag;
        }
        return false;
    }

    public ReferenceUniqueName getReferenceContainerUniqueName(Reference reference) {
        ReferenceUniqueName referenceUin = (ReferenceUniqueName)reference.getUniqueName();
        if (Content.REF_DEEP_UIN.equals(referenceUin)) {
            return Content.REF_MIDDLE_UIN;
        }
        if (Content.REF_MIDDLE_UIN.equals(referenceUin)) {
            return Content.REF_TOP_UIN;
        }
        if (Content.REF_TOP_UIN.equals(referenceUin)) {
            return null;
        }
        return null;
    }

    public UniqueName getParentUniqueName(Element child) {
        UniqueName childUin = child.getUniqueName();
        if (Content.REF_TOP_UIN.equals(childUin) || Content.REF_MIDDLE_UIN.equals(childUin) || Content.REF_DEEP_UIN.equals(childUin) && this.myReferenceWasAddedFlag) {
            return Content.DEFAULT_COLLECTION_UIN;
        }
        return null;
    }

    public ModelDeltaNode getReferenceCollectionChanges(ReferenceCollection collection) {
        if (Content.DEFAULT_COLLECTION_UIN.equals(collection.getUniqueName()) && this.myReferenceDelta != null) {
            ModelDeltaNode result = this.myReferenceDelta;
            this.myReferenceDelta = null;
            return result;
        }
        return null;
    }

    public void startCollectingChanges(ReferenceCollection collection) {
    }

    public void stopCollectingChanges(ReferenceCollection collection) {
    }

    public void modelChanged(ModelChangeEvent changeEvent) {
        throw new RuntimeException("should not be reachable");
    }
}

