/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.test.provider;

import com.tssap.selena.impl.model.test.provider.AbstractModelContentTest;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.Reference;
import java.util.Collection;
import junit.framework.Assert;

public class TemplatesTest
extends AbstractModelContentTest {
    private static String NAME_TO_SET = "name1";
    private static String NAME_TO_ADD = "name2";
    private static String VALUE_1 = "value1";
    private static String VALUE_2 = "value2";

    public TemplatesTest(String name) {
        super(name);
    }

    public void testReferenceTemplate() {
        Reference template = this.myModel.createReferenceTemplate();
        Assert.assertNotNull((String)"can not create reference template", (Object)template);
        Assert.assertTrue((String)"it should not be possible to add child references to templates", (!template.canAddReference(this.myModel, null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"templates should not contains children", (!template.references().hasMoreElements() ? 1 : 0) != 0);
        Assert.assertNull((String)"templates should not refere real entities", (Object)template.getEntity());
        Assert.assertNull((String)"templates should not have parents", (Object)template.getParent());
        Assert.assertTrue((String)"can not set property value in template", (boolean)template.canSetPropertyValue(NAME_TO_SET, VALUE_1));
        Assert.assertTrue((String)"can not set property value in template", (boolean)template.canSetPropertyValue(NAME_TO_SET, VALUE_2));
        template.setPropertyValue(NAME_TO_SET, VALUE_1);
        Property settedProperty = template.getProperty(NAME_TO_SET);
        Assert.assertNotNull((String)"property was not setted", (Object)settedProperty);
        Assert.assertEquals((String)"wrong property was setted", (String)VALUE_1, (String)settedProperty.getValue());
        String settedValue = template.getPropertyValue(NAME_TO_SET);
        Assert.assertNotNull((String)"property was not setted", (Object)settedValue);
        Assert.assertEquals((String)"wrong property was setted", (String)VALUE_1, (String)settedValue);
        Collection settedProperties = AbstractModelContentTest.collectEnumeration(template.properties(NAME_TO_SET));
        Assert.assertEquals((String)"wrong number of setted properties", (int)1, (int)settedProperties.size());
        Assert.assertTrue((String)"can not add property to template", (boolean)template.canAddProperty(NAME_TO_ADD, VALUE_1));
        Assert.assertTrue((String)"can not add property to template", (boolean)template.canAddProperty(NAME_TO_ADD, VALUE_2));
        template.addProperty(NAME_TO_ADD, VALUE_1);
        template.addProperty(NAME_TO_ADD, VALUE_2);
        Collection addedProperties = AbstractModelContentTest.collectEnumeration(template.properties(NAME_TO_ADD));
        Assert.assertEquals((String)"wrong number of added properties", (int)2, (int)addedProperties.size());
        Assert.assertTrue((String)"checking of the setted property presents fails", (boolean)template.hasProperty(NAME_TO_SET));
        Assert.assertTrue((String)"checking of the added property presents fails", (boolean)template.hasProperty(NAME_TO_ADD));
        Assert.assertTrue((String)"checking of the setted property value fails", (boolean)template.hasPropertyValue(NAME_TO_SET, VALUE_1));
        Assert.assertTrue((String)"checking of the wrong property value should fails", (!template.hasPropertyValue(NAME_TO_SET, VALUE_2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"checking of the added property value fails", (boolean)template.hasPropertyValue(NAME_TO_ADD, VALUE_1));
        Assert.assertTrue((String)"checking of the added property value fails", (boolean)template.hasPropertyValue(NAME_TO_ADD, VALUE_2));
    }
}

