/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.test.provider;

import com.tssap.selena.impl.model.test.provider.AbstractModelContentTest;
import com.tssap.selena.impl.model.test.provider.Content;
import com.tssap.selena.impl.model.test.provider.TestProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.function.UnaryOperation;
import java.util.Collection;
import junit.framework.Assert;

public class ReferencesTest
extends AbstractModelContentTest
implements Content {
    private UnaryOperation REFERENCE_2_UIN_OPERATION = new UnaryOperation(){

        public Object execute(Object object) {
            Assert.assertTrue((String)"Should be Reference", (boolean)(object instanceof Reference));
            return ((Reference)object).getUniqueName();
        }
    };

    public ReferencesTest(String name) {
        super(name);
    }

    public void testReferencesPresents() {
        TestProvider.reset();
        ReferenceCollection defaultRC = this.myModel.findReferenceCollection(Content.DEFAULT_COLLECTION_UIN);
        Assert.assertNotNull((String)"can not find default collection", (Object)defaultRC);
        Collection topReferences = AbstractModelContentTest.collectEnumeration(defaultRC.references());
        Assert.assertEquals((String)"wrong number of references", (int)1, (int)topReferences.size());
        Assert.assertTrue((String)"default collection does not contain reference to top-Entity", (boolean)this.checkReferenceUinPresents(topReferences, Content.REF_TOP_UIN));
        Assert.assertTrue((String)"default collection contains WRONG reference to middle-Entity", (!this.checkReferenceUinPresents(topReferences, Content.REF_MIDDLE_UIN) ? 1 : 0) != 0);
        Assert.assertTrue((String)"default collection contains WRONG reference to deep-Entity", (!this.checkReferenceUinPresents(topReferences, Content.REF_DEEP_UIN) ? 1 : 0) != 0);
        Reference topReference = (Reference)topReferences.iterator().next();
        Reference shouldBeTopReference = this.checkFoundReference(Content.REF_TOP_UIN);
        Assert.assertEquals((String)"default collection does not contain reference to top-Entity", (Object)topReference, (Object)shouldBeTopReference);
        Assert.assertTrue((String)"top-reference isDeleted()", (!topReference.isDeleted() ? 1 : 0) != 0);
        Collection middleReferences = AbstractModelContentTest.collectEnumeration(topReference.references());
        Assert.assertEquals((String)"wrong number of references", (int)1, (int)middleReferences.size());
        Assert.assertTrue((String)"top-reference does not contain reference to middle-Entity", (boolean)this.checkReferenceUinPresents(middleReferences, Content.REF_MIDDLE_UIN));
        Assert.assertTrue((String)"top-reference contains WRONG reference to top-Entity", (!this.checkReferenceUinPresents(middleReferences, Content.REF_TOP_UIN) ? 1 : 0) != 0);
        Assert.assertTrue((String)"top-reference contains WRONG reference to default collection", (!this.checkReferenceUinPresents(middleReferences, Content.DEFAULT_COLLECTION_UIN) ? 1 : 0) != 0);
        Assert.assertTrue((String)"top-reference contains WRONG reference to deep-Entity", (!this.checkReferenceUinPresents(middleReferences, Content.REF_DEEP_UIN) ? 1 : 0) != 0);
        Reference middleReference = (Reference)middleReferences.iterator().next();
        Reference shouldBeMiddleReference = this.checkFoundReference(Content.REF_MIDDLE_UIN);
        Assert.assertEquals((String)"top-reference does not contain reference to middle-Entity", (Object)shouldBeMiddleReference.getUniqueName(), (Object)middleReference.getUniqueName());
        Assert.assertTrue((String)"before addReference() middle-reference should contain nothing", (!middleReference.references().hasMoreElements() ? 1 : 0) != 0);
    }

    public void testReferenceAddition() {
        this.testReferencesPresents();
        Entity deepEntity = this.myModel.findEntity(Content.DEEP_UIN_1);
        Assert.assertNotNull((String)"can not find deep entity", (Object)deepEntity);
        Assert.assertTrue((String)"deep-Entity isDeleted()", (!deepEntity.isDeleted() ? 1 : 0) != 0);
        Reference middleReference = this.checkFoundReference(Content.REF_MIDDLE_UIN);
        Assert.assertTrue((String)"middle-reference isDeleted()", (!middleReference.isDeleted() ? 1 : 0) != 0);
        Assert.assertTrue((String)"impossible to add reference for midle-Ref", (boolean)middleReference.canAddReference(deepEntity, null));
        Reference addedReference = middleReference.addReference(deepEntity, null);
        Assert.assertNotNull((String)"adding reference fails", (Object)addedReference);
        Assert.assertTrue((String)"just added reference isDeleted()", (!addedReference.isDeleted() ? 1 : 0) != 0);
        Assert.assertEquals((String)"added reference has wrong self-uin", (Object)Content.REF_DEEP_UIN, (Object)addedReference.getUniqueName());
        Assert.assertEquals((String)"added reference refers WRONG entity-uin", (Object)Content.DEEP_UIN_1, (Object)((ReferenceUniqueName)addedReference.getUniqueName()).getReferencedUniqueName());
        Collection deepReferences = AbstractModelContentTest.collectEnumeration(middleReference.references());
        Assert.assertEquals((String)"AFTER ADDING: wrong number of deepReferences", (int)1, (int)deepReferences.size());
        Assert.assertTrue((String)"AFTER ADDING: middle-reference contains WRONG reference to top-Entity", (!this.checkReferenceUinPresents(deepReferences, Content.REF_TOP_UIN) ? 1 : 0) != 0);
        Assert.assertTrue((String)"AFTER ADDING: middle-reference contains WRONG reference to default collection", (!this.checkReferenceUinPresents(deepReferences, Content.DEFAULT_COLLECTION_UIN) ? 1 : 0) != 0);
        Assert.assertTrue((String)"AFTER ADDING: middle-reference does not contain reference to deep-Entity", (boolean)this.checkReferenceUinPresents(deepReferences, Content.REF_DEEP_UIN));
        Assert.assertTrue((String)"AFTER ADDING: should be impossible to add duplicate reference", (!middleReference.canAddReference(deepEntity, null) ? 1 : 0) != 0);
    }

    public void testReferenceParent() {
        this.testReferenceAddition();
        Reference topReference = this.checkFoundReference(Content.REF_TOP_UIN);
        Reference middleReference = this.checkFoundReference(Content.REF_MIDDLE_UIN);
        Reference deepReference = this.checkFoundReference(Content.REF_DEEP_UIN);
        this.checkParent(topReference, Content.DEFAULT_COLLECTION_UIN);
        this.checkParent(middleReference, Content.DEFAULT_COLLECTION_UIN);
        this.checkParent(deepReference, Content.DEFAULT_COLLECTION_UIN);
    }

    public void testReferenceParentContainer() {
        this.testReferenceAddition();
        Reference topReference = this.checkFoundReference(Content.REF_TOP_UIN);
        Reference middleReference = this.checkFoundReference(Content.REF_MIDDLE_UIN);
        Reference deepReference = this.checkFoundReference(Content.REF_DEEP_UIN);
        this.checkParentContainer(topReference, Content.DEFAULT_COLLECTION_UIN);
        this.checkParentContainer(middleReference, topReference.getUniqueName());
        this.checkParentContainer(deepReference, middleReference.getUniqueName());
    }

    public void testReferenceDeletion() {
        this.testReferenceAddition();
        Reference topReference = this.checkFoundReference(Content.REF_TOP_UIN);
        Assert.assertTrue((String)"should be impossible to delete top-reference ", (!topReference.canDelete() ? 1 : 0) != 0);
        Reference deepReference = this.checkFoundReference(Content.REF_DEEP_UIN);
        Assert.assertTrue((String)"should be POSSIBLE to delete deep-reference ", (boolean)deepReference.canDelete());
        deepReference.delete();
        Reference shouldNotBeFoundAsReference = this.myModel.findReference(Content.REF_DEEP_UIN);
        Assert.assertTrue((String)"AFTER DELETION: should be impossible to find valid reference", (shouldNotBeFoundAsReference == null || shouldNotBeFoundAsReference.isDeleted() ? 1 : 0) != 0);
        Entity shouldNotBeFoundAsEntity = this.myModel.findEntity(Content.REF_DEEP_UIN);
        Assert.assertNull((String)"AFTER DELETION: shouldbe impossible to find reference as entity", (Object)shouldNotBeFoundAsEntity);
        shouldNotBeFoundAsEntity = this.myModel.findReferenceCollection(Content.REF_DEEP_UIN);
        Assert.assertNull((String)"AFTER DELETION: shouldbe impossible to find reference as ReferenceCollection", (Object)shouldNotBeFoundAsEntity);
        Reference middleReference = this.checkFoundReference(Content.REF_MIDDLE_UIN);
        Assert.assertTrue((String)"AFTER DELETION: middle-reference should contain nothing", (!middleReference.references().hasMoreElements() ? 1 : 0) != 0);
    }

    public void testBigOperation() {
        this.testReferenceDeletion();
        this.testReferencesPresents();
    }

    public void testParentConsistence() {
        Assert.fail((String)"getParent() for inner reference will return Collection, but collection.children() isEmpty");
        Assert.fail((String)"see TEMPORARY in ElementImpl");
    }

    public void testRefernceInstantiator() {
        Assert.fail((String)"see 'PROBLEM HERE' in ReferenceImpl:referenceInstantiator");
    }

    protected void checkParent(Element element, UniqueName shouldBeParentUin) {
        Entity parent = element.getParent();
        Assert.assertNotNull((String)("can not find parent for: " + element.getUniqueName()), (Object)parent);
        Assert.assertEquals((String)("wrong parent uin for :" + element.getUniqueName()), (Object)shouldBeParentUin, (Object)parent.getUniqueName());
    }

    protected void checkParentContainer(Reference reference, UniqueName shouldBeContainerUin) {
        ReferenceContainer container = reference.getReferenceContainer();
        Assert.assertTrue((String)"ReferenceContainer is not instanceof Element", (boolean)(container instanceof ReferenceContainer));
        Assert.assertEquals((String)("wrong container for reference: " + reference), (Object)shouldBeContainerUin, (Object)((Element)((Object)container)).getUniqueName());
    }

    protected Reference checkFoundReference(ReferenceUniqueName referenceUin) {
        Entity shouldNotBeFound = this.myModel.findEntity(referenceUin);
        Assert.assertNull((String)"should not be possible to find Reference as Entity", (Object)shouldNotBeFound);
        shouldNotBeFound = this.myModel.findReferenceCollection(referenceUin);
        Assert.assertNull((String)"should not be possible to find Reference as ReferenceCollection", (Object)shouldNotBeFound);
        Reference result = this.myModel.findReference(referenceUin);
        Assert.assertNotNull((String)("can not find reference: " + referenceUin), (Object)result);
        Assert.assertTrue((String)("reference: " + referenceUin + " isDeleted()"), (!result.isDeleted() ? 1 : 0) != 0);
        return result;
    }

    protected boolean checkReferenceUinPresents(Collection references, UniqueName uinToFind) {
        return AbstractModelContentTest.checkPresents(references, this.REFERENCE_2_UIN_OPERATION, uinToFind);
    }
}

