/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.test.provider;

import com.tssap.selena.impl.model.test.provider.AbstractModelContentTest;
import com.tssap.selena.impl.model.test.provider.Content;
import com.tssap.selena.impl.model.test.provider.TestProvider;
import com.tssap.selena.impl.model.view.ViewManagerImpl;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.view.View;
import com.tssap.selena.model.view.ViewAccess;
import com.tssap.selena.model.view.ViewFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import junit.framework.Assert;

public class ReferenceDeltaTest
extends AbstractModelContentTest
implements Content {
    private TestView myView;

    public ReferenceDeltaTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ((ViewManagerImpl)ViewAccess.getViewManager(ModelUinSupport.createModelUin(this.getProject().getName()))).registerViewFactory(TestViewFactory.getInstance());
    }

    protected void disposeView() {
        if (this.myView != null) {
            ViewAccess.getViewManager(this.getModel().getUniqueName()).disposeView(this.myView);
            this.myView = null;
        }
    }

    protected void tearDown() throws Exception {
        this.disposeView();
        ((ViewManagerImpl)ViewAccess.getViewManager(this.getModel().getUniqueName())).unregisterViewFactory(TestViewFactory.getInstance());
        super.tearDown();
    }

    public void testViewCreation() {
        UniqueName modelUin = this.getModel().getUniqueName();
        ReferenceCollection defaultRC = this.getModel().findReferenceCollection(Content.DEFAULT_COLLECTION_UIN);
        Assert.assertNotNull((String)"Could not find default RC", (Object)defaultRC);
        Assert.assertTrue((String)"Cannot create view for default RC with my own view type", (boolean)ViewAccess.getViewManager(modelUin).canCreateView(defaultRC, "test.view"));
        View view = ViewAccess.getViewManager(modelUin).createView(defaultRC, "test.view");
        Assert.assertTrue((String)"Failed to create my own view for default RC with my own view type", (boolean)(view instanceof TestView));
        this.myView = (TestView)view;
    }

    public void testDeltaOnAddRemoveReference() {
        this.testViewCreation();
        this.checkDeltaOnAddRemoveReference(this.myView, 1);
    }

    public void testNoDeltaOnAddRemoveReferenceWhenViewClosed() {
        this.testViewCreation();
        TestView view = this.myView;
        this.disposeView();
        this.checkDeltaOnAddRemoveReference(view, 0);
    }

    private void checkDeltaOnAddRemoveReference(TestView view, int expectedCount) {
        Reference middle = this.getModel().findReference(Content.REF_MIDDLE_UIN);
        Assert.assertNotNull((String)"No Middle reference (other tests should also fail)", (Object)middle);
        Entity deep = this.getModel().findEntity(Content.DEEP_UIN_1);
        Assert.assertNotNull((String)"No Deep entity (other tests should also fail)", (Object)deep);
        Assert.assertTrue((String)"Can't add ref to deep (other tests should also fail)", (boolean)middle.canAddReference(deep, null));
        view.resetUpdateCount(new DeltaNodeValidator(){

            public void validate(ModelDeltaNode delta) {
                delta = ReferenceDeltaTest.this.walkToChange(delta);
                Assert.assertEquals((String)"Incorrect element in delta", (Object)Content.REF_DEEP_UIN, (Object)delta.getElementUniqueName());
                Assert.assertTrue((String)"Should be added reference", (boolean)delta.isNew());
            }
        });
        Reference shouldBeDeep = middle.addReference(deep, null);
        view.ensureUpdated(expectedCount);
        Assert.assertNotNull((String)"No reference added (other tests should also fail", (Object)shouldBeDeep);
        view.resetUpdateCount(new DeltaNodeValidator(){

            public void validate(ModelDeltaNode delta) {
                delta = ReferenceDeltaTest.this.walkToChange(delta);
                Assert.assertEquals((String)"Incorrect element in delta", (Object)Content.REF_DEEP_UIN, (Object)delta.getElementUniqueName());
                Assert.assertTrue((String)"Should be deleted reference", (boolean)delta.isDeleted());
            }
        });
        shouldBeDeep.delete();
        view.ensureUpdated(expectedCount);
    }

    public void testNoDeltaOnChangeElement() {
        this.testViewCreation();
        Entity middle = this.getModel().findEntity(Content.MIDDLE_UIN);
        Assert.assertNotNull((String)"No Middle entity (other tests should also fail)", (Object)middle);
        this.myView.resetUpdateCount(new DeltaNodeValidator(){

            public void validate(ModelDeltaNode delta) {
                Assert.fail((String)"No update should occur whatsoever");
            }
        });
        Entity deep2 = middle.createChildEntity(TestProvider.MY_METACLASS, null);
        Assert.assertNotNull((String)"Deep 2 was not created", (Object)deep2);
        this.myView.ensureUpdated(0);
    }

    private ModelDeltaNode walkToChange(ModelDeltaNode delta) {
        Assert.assertTrue((String)"Empty delta", (!delta.isEmpty() ? 1 : 0) != 0);
        if (delta.isChanged() || delta.isDeleted() || delta.isNew() || delta.isTotallyChanged()) {
            return delta;
        }
        Enumeration children = delta.changedChildren();
        Assert.assertTrue((String)"No children (isn't it empty?)", (boolean)children.hasMoreElements());
        ModelDeltaNode child = (ModelDeltaNode)children.nextElement();
        Assert.assertTrue((String)"Too many children, expected one only", (!children.hasMoreElements() ? 1 : 0) != 0);
        return this.walkToChange(child);
    }

    private static interface DeltaNodeValidator {
        public void validate(ModelDeltaNode var1);
    }

    private static class TestView
    implements View {
        private ReferenceCollection myCollection;
        private int myUpdateCount = 0;
        private DeltaNodeValidator myValidator;

        public TestView(ReferenceCollection rc) {
            this.myCollection = rc;
        }

        public ReferenceCollection getReferenceCollection() {
            return this.myCollection;
        }

        public Object getService(Class clazz) {
            return null;
        }

        public void resetUpdateCount(DeltaNodeValidator validator) {
            this.myUpdateCount = 0;
            this.myValidator = validator;
        }

        public void ensureUpdated(int expected) {
            Assert.assertEquals((String)"Incorrect number of updates", (int)expected, (int)this.myUpdateCount);
        }

        public void update(ModelDeltaNode delta) {
            ++this.myUpdateCount;
            this.ensureUpdated(1);
            this.myValidator.validate(delta);
        }

        public void totalUpdate() {
        }

        public void dispose() {
        }
    }

    private static class TestViewType {
        public static final String NAME = "test.view";

        private TestViewType() {
        }
    }

    private static class TestViewFactory
    implements ViewFactory {
        private static TestViewFactory mySelf = new TestViewFactory();
        private static final Collection MY_VIEW_TYPES = Collections.singleton("test.view");

        private TestViewFactory() {
        }

        public static TestViewFactory getInstance() {
            return mySelf;
        }

        public boolean canCreateView(ReferenceCollection collection, String type) {
            return Content.DEFAULT_COLLECTION_UIN.equals(collection.getUniqueName()) && "test.view".equals(type);
        }

        public View createView(ReferenceCollection collection, String type) {
            return new TestView(collection);
        }

        public Enumeration supportedViewTypes() {
            return Collections.enumeration(MY_VIEW_TYPES);
        }
    }
}

