/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.test.provider;

import com.tssap.selena.impl.model.test.provider.AbstractModelContentTest;
import com.tssap.selena.impl.model.test.provider.Content;
import com.tssap.selena.impl.model.test.provider.TestProvider;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.enum.EntityEnumeration;
import java.util.Collection;
import junit.framework.Assert;

public class ModelTest
extends AbstractModelContentTest
implements Content {
    public ModelTest(String name) {
        super(name);
    }

    public void testModelAware() throws Exception {
        Assert.assertTrue((String)"Model was not setted to ModelAware provider", (this.myTestProvider.getModel() != null ? 1 : 0) != 0);
    }

    public void testchildEntities() throws Exception {
        TestProvider.reset();
        EntityEnumeration entityEnumeration = this.myModel.childEntities();
        Assert.assertTrue((String)"There is should be children.", (boolean)entityEnumeration.hasMoreElements());
        Entity element = (Entity)entityEnumeration.nextElement();
        Assert.assertTrue((String)"Wrong child.", (boolean)element.getUniqueName().equals(TestProvider.UNIQUE_NAME1));
        Assert.assertTrue((String)"There is should be only one child.", (!entityEnumeration.hasMoreElements() ? 1 : 0) != 0);
        entityEnumeration = element.childEntities();
        Assert.assertTrue((String)"There is should be children.", (boolean)entityEnumeration.hasMoreElements());
        element = (Entity)entityEnumeration.nextElement();
        Assert.assertTrue((String)"Wrong child.", (boolean)element.getUniqueName().equals(TestProvider.UNIQUE_NAME2));
        Assert.assertTrue((String)"There is should be only one child.", (!entityEnumeration.hasMoreElements() ? 1 : 0) != 0);
        entityEnumeration = element.childEntities();
        Assert.assertTrue((String)"There is should be children.", (boolean)entityEnumeration.hasMoreElements());
        element = (Entity)entityEnumeration.nextElement();
        Assert.assertTrue((String)"Wrong child.", (boolean)element.getUniqueName().equals(TestProvider.UNIQUE_NAME3));
        Assert.assertTrue((String)"There is shouldn't be children.", (!entityEnumeration.hasMoreElements() ? 1 : 0) != 0);
        entityEnumeration = element.childEntities();
        Assert.assertTrue((String)"There is should be children.", (boolean)entityEnumeration.hasMoreElements());
        element = (Entity)entityEnumeration.nextElement();
        Assert.assertTrue((String)"Wrong child.", (boolean)element.getUniqueName().equals(TestProvider.UNIQUE_NAME4));
        Assert.assertTrue((String)"There is should be only one child.", (!entityEnumeration.hasMoreElements() ? 1 : 0) != 0);
        entityEnumeration = element.childEntities();
        Assert.assertTrue((String)"There is shouldn't be children.", (!entityEnumeration.hasMoreElements() ? 1 : 0) != 0);
    }

    public void testFindEntity() throws Exception {
        TestProvider.reset();
        Entity element = this.myModel.findEntity(this.myModel.getUniqueName());
        Assert.assertNotNull((String)"Element not found.", (Object)element);
        element = this.myModel.findEntity(TestProvider.UNIQUE_NAME1);
        Assert.assertNotNull((String)"Element not found.", (Object)element);
        element = this.myModel.findEntity(TestProvider.UNIQUE_NAME2);
        Assert.assertNotNull((String)"Element not found.", (Object)element);
        element = this.myModel.findEntity(TestProvider.UNIQUE_NAME3);
        Assert.assertNotNull((String)"Element not found.", (Object)element);
        element = this.myModel.findEntity(TestProvider.UNIQUE_NAME31);
        Assert.assertNull((String)"Element shouldn't be found.", (Object)element);
        element = this.myModel.findEntity(TestProvider.UNIQUE_NAME4);
        Assert.assertNotNull((String)"Element not found.", (Object)element);
        element = this.myModel.findEntity(TestProvider.UNIQUE_NAME5);
        Assert.assertNull((String)"Element shouldn't be found.", (Object)element);
    }

    public void testParent() throws Exception {
        TestProvider.reset();
        Entity element = this.myModel.findEntity(TestProvider.UNIQUE_NAME4);
        Assert.assertNotNull((String)"Element not found.", (Object)element);
        element = element.getParent();
        Assert.assertNotNull((String)"Parent not found.", (Object)element);
        Assert.assertTrue((String)"Wrond parent.", (boolean)TestProvider.UNIQUE_NAME3.equals(element.getUniqueName()));
        element = element.getParent();
        Assert.assertNotNull((String)"Parent not found.", (Object)element);
        Assert.assertTrue((String)"Wrond parent.", (boolean)TestProvider.UNIQUE_NAME2.equals(element.getUniqueName()));
        element = element.getParent();
        Assert.assertNotNull((String)"Parent not found.", (Object)element);
        Assert.assertTrue((String)"Wrond parent.", (boolean)TestProvider.UNIQUE_NAME1.equals(element.getUniqueName()));
        element = element.getParent();
        Assert.assertNotNull((String)"Parent not found.", (Object)element);
        Assert.assertTrue((String)"Wrond parent.", (boolean)this.myModel.getUniqueName().equals(element.getUniqueName()));
        element = element.getParent();
        Assert.assertNull((String)"Parent not found.", (Object)element);
    }

    public void testDeletion() throws Exception {
        TestProvider.reset();
        Entity element = this.myModel.findEntity(TestProvider.UNIQUE_NAME4);
        Assert.assertNotNull((String)"Element not found.", (Object)element);
        Assert.assertTrue((String)"Element is deleted.", (!element.isDeleted() ? 1 : 0) != 0);
        element.delete();
        Assert.assertTrue((String)"Element not deleted.", (boolean)element.isDeleted());
        element = this.myModel.findEntity(TestProvider.UNIQUE_NAME4);
        Assert.assertTrue((String)"Element not deleted.", (element == null || element.isDeleted() ? 1 : 0) != 0);
    }

    public void testCreation() throws Exception {
        TestProvider.reset();
        Entity element = this.myModel.findEntity(TestProvider.UNIQUE_NAME31);
        Assert.assertNull((String)"Element shouldn't be found.", (Object)element);
        Entity parentElement = this.myModel.findEntity(TestProvider.UNIQUE_NAME2);
        Assert.assertNotNull((String)"Element not found.", (Object)parentElement);
        element = parentElement.createChildEntity(TestProvider.MY_METACLASS, null);
        Assert.assertNotNull((String)"Element not created.", (Object)element);
        element = this.myModel.findEntity(TestProvider.UNIQUE_NAME31);
        Assert.assertNotNull((String)"Element not found.", (Object)element);
    }

    public void testLoadingCachedCollectionThroughFindEntityMethod() {
        TestProvider.reset();
        Entity collectionAsEntity = this.myModel.findEntity(Content.DEFAULT_COLLECTION_UIN);
        Assert.assertNull((String)"It should be impossible to find reference collections through findEntity() method", (Object)collectionAsEntity);
        ReferenceCollection collection = this.myModel.findReferenceCollection(Content.DEFAULT_COLLECTION_UIN);
        Assert.assertNotNull((String)"Can not find Default collection through findReferenceCollection()", (Object)collection);
        Assert.assertTrue((String)"Wrong instance of DefaultCollection", (boolean)(collection instanceof ReferenceCollection));
        Assert.assertTrue((String)"Wrong uin in finded DefaultCollection", (boolean)Content.DEFAULT_COLLECTION_UIN.equals(collection.getUniqueName()));
        Entity entityLoadedFromCache = this.myModel.findEntity(Content.DEFAULT_COLLECTION_UIN);
        Assert.assertNull((String)"After caching it should be impossible to find reference collections through findEntity() method", (Object)entityLoadedFromCache);
    }

    public void testReferenceCollectionsExistence() {
        TestProvider.reset();
        Entity collectionAsEntity = this.myModel.findEntity(Content.DEFAULT_COLLECTION_UIN);
        Assert.assertNull((String)"It should be impossible to find reference collections through findEntity() method", (Object)collectionAsEntity);
        ReferenceCollection collection = this.myModel.findReferenceCollection(Content.DEFAULT_COLLECTION_UIN);
        Assert.assertNotNull((String)"Can not find Default collection through findReferenceCollection()", (Object)collection);
        Assert.assertTrue((String)"Wrong instance of DefaultCollection", (boolean)(collection instanceof ReferenceCollection));
        Assert.assertTrue((String)"Wrong uin in finded DefaultCollection", (boolean)Content.DEFAULT_COLLECTION_UIN.equals(collection.getUniqueName()));
        ReferenceCollection collectionFromCache = this.myModel.findReferenceCollection(Content.DEFAULT_COLLECTION_UIN);
        Assert.assertTrue((String)"Cache failed -- another instance of default collection loaded ", (collectionFromCache == collection ? 1 : 0) != 0);
        ReferenceCollection notExistsYet = this.myModel.findReferenceCollection(Content.NEW_COLLECTION_UIN);
        Assert.assertTrue((String)"Founded collection which was not created yet", (notExistsYet == null || notExistsYet.isDeleted() ? 1 : 0) != 0);
    }

    public void testReferenceCollectionCreation() {
        TestProvider.reset();
        this.testReferenceCollectionsExistence();
        Assert.assertTrue((String)"can not create new collection", (boolean)this.myModel.canCreateChildReferenceCollection("collection", null));
        Assert.assertTrue((String)"it is possible to create new collection with wrong metaclass", (!this.myModel.canCreateChildReferenceCollection("should-never-be-equals", null) ? 1 : 0) != 0);
        ReferenceCollection shouldNotCreated = this.myModel.createChildReferenceCollection("should-never-be-equals", null);
        Assert.assertNull((String)"collection with wrong metaclass was created", (Object)shouldNotCreated);
        ReferenceCollection newRC = this.myModel.createChildReferenceCollection("collection", null);
        Assert.assertNotNull((String)"creation of the new collection fails", (Object)newRC);
        Assert.assertTrue((String)"collection with wrong uin was created", (boolean)newRC.getUniqueName().equals(Content.NEW_COLLECTION_UIN));
        Assert.assertTrue((String)"It should not be possible to create the third collection", (!this.myModel.canCreateChildReferenceCollection("collection", null) ? 1 : 0) != 0);
        shouldNotCreated = this.myModel.createChildReferenceCollection("collection", null);
        Assert.assertNull((String)"It should not be possible to create the third collection", (Object)shouldNotCreated);
    }

    public void testReferenceCollectionDeletion() {
        TestProvider.reset();
        this.testReferenceCollectionCreation();
        ReferenceCollection defaultRC = this.myModel.findReferenceCollection(Content.DEFAULT_COLLECTION_UIN);
        Assert.assertTrue((String)"default collection should not be deletable", (!defaultRC.canDelete() ? 1 : 0) != 0);
        ReferenceCollection justCreatedRc = this.myModel.findReferenceCollection(Content.NEW_COLLECTION_UIN);
        Assert.assertTrue((String)"can not delete new collection", (boolean)justCreatedRc.canDelete());
        justCreatedRc.delete();
        Assert.assertTrue((String)"after deletion element should be isDeleted()", (boolean)justCreatedRc.isDeleted());
        ReferenceCollection deletedFromCache = this.myModel.findReferenceCollection(Content.NEW_COLLECTION_UIN);
        Assert.assertTrue((String)"cache should contain deleted version of deleted element", (boolean)deletedFromCache.isDeleted());
        this.testReferenceCollectionCreation();
    }

    public void testReferenceCollectionParent() {
        TestProvider.reset();
        this.testReferenceCollectionCreation();
        ReferenceCollection defaultRC = this.myModel.findReferenceCollection(Content.DEFAULT_COLLECTION_UIN);
        ReferenceCollection justCreatedRc = this.myModel.findReferenceCollection(Content.NEW_COLLECTION_UIN);
        Entity parentOfDefault = defaultRC.getParent();
        Assert.assertNotNull((String)"can not find parent of default collection", (Object)parentOfDefault);
        Entity parentOfNew = justCreatedRc.getParent();
        Assert.assertNotNull((String)"can not find parent of default collection", (Object)parentOfNew);
        Assert.assertTrue((String)"wrong parent of default collection", (boolean)this.myModel.getUniqueName().equals(parentOfDefault.getUniqueName()));
        Assert.assertTrue((String)"wrong parent of new collection", (boolean)this.myModel.getUniqueName().equals(parentOfNew.getUniqueName()));
    }

    public void testReferenceCollectionChildEntities() {
        TestProvider.reset();
        this.testReferenceCollectionsExistence();
        ReferenceCollection defaultRC = this.myModel.findReferenceCollection(Content.DEFAULT_COLLECTION_UIN);
        Collection modelChildRCs = AbstractModelContentTest.collectEnumeration(this.myModel.childReferenceCollections());
        Assert.assertTrue((String)"default collection is not child of model", (boolean)AbstractModelContentTest.checkPresents(modelChildRCs, defaultRC));
        Assert.assertEquals((String)"Wrong child collection's number", (int)1, (int)modelChildRCs.size());
        this.testReferenceCollectionCreation();
        ReferenceCollection justCreatedRc = this.myModel.findReferenceCollection(Content.NEW_COLLECTION_UIN);
        modelChildRCs = AbstractModelContentTest.collectEnumeration(this.myModel.childReferenceCollections());
        Assert.assertTrue((String)"default collection is not child of model", (boolean)AbstractModelContentTest.checkPresents(modelChildRCs, defaultRC));
        Assert.assertTrue((String)"just created collection is not child of model", (boolean)AbstractModelContentTest.checkPresents(modelChildRCs, justCreatedRc));
        Assert.assertEquals((String)"Wrong child collection's number", (int)2, (int)modelChildRCs.size());
        Collection rcChildren = AbstractModelContentTest.collectEnumeration(justCreatedRc.childEntities());
        Assert.assertTrue((String)"reference collection should not have children", (boolean)rcChildren.isEmpty());
        rcChildren = AbstractModelContentTest.collectEnumeration(defaultRC.childEntities());
        Assert.assertTrue((String)"reference collection should not have children", (boolean)rcChildren.isEmpty());
    }
}

