/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.test.modelaccess;

import com.tssap.selena.impl.model.test.AbstractTest;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import junit.framework.Assert;
import org.eclipse.core.resources.IProject;

public class ModelAccessTest
extends AbstractTest {
    private boolean isCreated = false;
    private boolean isDeleted = false;
    private static String REFERENCE_SUB_DOMAIN = "reference";
    private static String DOMAIN = "test_domain";
    private static String SUB_DOMAIN = "test_sub_domain";
    private static String LOCATION = "test_location";
    private static String NAME = "test_name";
    private static String PARAMETER1 = "test_parameter1";
    private static String PARAMETER2 = "test_parameter2";
    private static String UNIQUE_NAME1 = DOMAIN + ":" + SUB_DOMAIN + ":" + LOCATION + ":" + NAME + ":" + PARAMETER1 + ":" + PARAMETER2;
    private static String UNIQUE_NAME2 = DOMAIN + ":" + SUB_DOMAIN + "::" + NAME + ":" + PARAMETER1 + ":" + PARAMETER2;

    public ModelAccessTest(String name) {
        super(name);
    }

    public void testCreateUniqueName() throws Exception {
        UniqueName uniqueName = ModelAccess.createUniqueName(null);
        Assert.assertNull((String)"The result should be null.", (Object)uniqueName);
        uniqueName = ModelAccess.createUniqueName(UNIQUE_NAME1);
        Assert.assertTrue((String)"Wrong domain.", (boolean)DOMAIN.equals(uniqueName.getDomain()));
        Assert.assertTrue((String)"Wrong sub domain.", (boolean)SUB_DOMAIN.equals(uniqueName.getSubDomain()));
        Assert.assertTrue((String)"Wrong location.", (boolean)LOCATION.equals(uniqueName.getLocation()));
        Assert.assertTrue((String)"Wrong name.", (boolean)NAME.equals(uniqueName.getName()));
        Assert.assertTrue((String)"Wrong number of parameters.", (uniqueName.getParametersCount() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrong first parameter.", (boolean)PARAMETER1.equals(uniqueName.getParameter(0)));
        Assert.assertTrue((String)"Wrong second parameter.", (boolean)PARAMETER2.equals(uniqueName.getParameter(1)));
        uniqueName = ModelAccess.createUniqueName(UNIQUE_NAME2);
        Assert.assertTrue((String)"Wrong domain.", (boolean)DOMAIN.equals(uniqueName.getDomain()));
        Assert.assertTrue((String)"Wrong sub domain.", (boolean)SUB_DOMAIN.equals(uniqueName.getSubDomain()));
        Assert.assertTrue((String)"Wrong name.", (uniqueName.getLocation() == null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrong location.", (boolean)NAME.equals(uniqueName.getName()));
        Assert.assertTrue((String)"Wrong number of parameters.", (uniqueName.getParametersCount() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrong first parameter.", (boolean)PARAMETER1.equals(uniqueName.getParameter(0)));
        Assert.assertTrue((String)"Wrong second parameter.", (boolean)PARAMETER2.equals(uniqueName.getParameter(1)));
        uniqueName = ModelAccess.createUniqueName(DOMAIN, SUB_DOMAIN, LOCATION, NAME, new String[]{PARAMETER1, PARAMETER2});
        Assert.assertTrue((String)"Wrong result of toString().", (boolean)UNIQUE_NAME1.equals(uniqueName.toString()));
        uniqueName = ModelAccess.createUniqueName(DOMAIN, SUB_DOMAIN, null, NAME, new String[]{PARAMETER1, PARAMETER2});
        Assert.assertTrue((String)"Wrong result of toString().", (boolean)UNIQUE_NAME2.equals(uniqueName.toString()));
    }

    public void testCreateModel() throws Exception {
        UniqueName uniqueName1 = ModelAccess.createModelUniqueName(this.getProject().getName());
        Model model1 = ModelAccess.createModel(uniqueName1);
        Assert.assertTrue((String)"Model sholdn't be null.", (model1 != null ? 1 : 0) != 0);
        Model model2 = ModelAccess.createModel(uniqueName1);
        Assert.assertTrue((String)"There is should be the same instances of Model.", (boolean)model1.equals(model2));
        model2 = ModelAccess.getModel(uniqueName1);
        Assert.assertTrue((String)"There is should be the same instances of Model.", (boolean)model1.equals(model2));
        Assert.assertTrue((String)"There is should be model with this name.", (boolean)ModelAccess.hasModel(uniqueName1));
        UniqueName uniqueName2 = ModelAccess.createModelUniqueName(this.getProject().getName());
        Assert.assertTrue((String)"There is shouldn't be model with this name.", (boolean)ModelAccess.hasModel(uniqueName2));
        model1 = ModelAccess.createModel(uniqueName2);
        Assert.assertTrue((String)"Model sholdn't be null.", (model1 != null ? 1 : 0) != 0);
        model2 = ModelAccess.getModel(uniqueName1);
        Assert.assertTrue((String)"There is should be the same instances of Model.", (boolean)model1.equals(model2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testModelAccessListener() throws Exception {
        IProject project = null;
        try {
            ModelAccess.addModelAccessListener(new ModelAccessListener(){

                public void modelCreated(ModelAccessEvent event) {
                    ModelAccessTest.this.isCreated = true;
                }

                public void modelRemoved(ModelAccessEvent event) {
                    ModelAccessTest.this.isDeleted = true;
                }
            });
            project = this.createProject();
            Assert.assertTrue((String)"No event about model creation.", (boolean)this.isCreated);
            this.removeProject(project);
            project = null;
            Assert.assertTrue((String)"No event about model creation.", (boolean)this.isDeleted);
            Object var3_2 = null;
            if (project == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (project == null) throw throwable;
            this.removeProject(project);
            throw throwable;
        }
        this.removeProject(project);
    }

    public void testCreateReferenceUniqueName() throws Exception {
        UniqueName baseReferenceUin = ModelAccess.createUniqueName(DOMAIN, REFERENCE_SUB_DOMAIN, LOCATION, NAME, null);
        UniqueName entityUin = ModelAccess.createUniqueName(DOMAIN, LOCATION, NAME);
        ReferenceUniqueName referenceUin = ModelAccess.createReferenceUniqueName(baseReferenceUin, entityUin);
        Assert.assertNotNull((String)"can not create ReferenceUniqueName object", (Object)referenceUin);
        Assert.assertNotNull((String)"ReferenceUniqueName refer nothing", (Object)referenceUin.getReferencedUniqueName());
        Assert.assertTrue((String)"ReferenceUniqueName refer wrong entitie's uin", (boolean)referenceUin.getReferencedUniqueName().equals(entityUin));
        Assert.assertTrue((String)"Wrong Domain in ReferencedUniqueName", (boolean)DOMAIN.equals(referenceUin.getDomain()));
        Assert.assertTrue((String)"Wrong SubDomain in ReferencedUniqueName", (boolean)REFERENCE_SUB_DOMAIN.equals(referenceUin.getSubDomain()));
        Assert.assertTrue((String)"Wrong Domain in ReferencedUniqueName", (boolean)LOCATION.equals(referenceUin.getLocation()));
        Assert.assertTrue((String)"Wrong Name in ReferencedUniqueName", (boolean)NAME.equals(referenceUin.getName()));
        Assert.assertEquals((String)"Wrong Parameters count in ReferencedUniqueName", (int)0, (int)referenceUin.getParametersCount());
    }
}

