/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.enum;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;

public abstract class CompositeEnumerationBase
implements Enumeration {
    private int position = -1;
    private VectorEx enumerations = new VectorEx();
    private boolean isRestorable = false;
    private BackupEnumeration backupEnum = new BackupEnumeration();
    private HashSet myEnumeratedElements = new HashSet();

    public boolean hasMoreElements() {
        boolean result;
        this.ensureStarted();
        boolean bl = result = this.getCurrentObject() != null;
        if (!result) {
            boolean currentlyRestorable = this.isRestorable;
            this.setRestorable(false);
            if (currentlyRestorable) {
                this.setRestorable(true);
            }
        }
        return result;
    }

    public void setRestorable(boolean restorable) {
        if (restorable) {
            this.createBackupEnumeration();
            this.isRestorable = restorable;
        } else {
            if (this.isRestorable && this.position >= 0) {
                this.enumerations.removeUpTo(this.position);
                this.position = -1;
                this.setCurrentEnum(null);
                this.setCurrentObjectNull();
                this.enumerations.insertElementAt(this.createTypedEnumeration(this.backupEnum), 0);
            }
            this.isRestorable = false;
        }
    }

    protected abstract void setCurrentObjectNull();

    protected abstract Object getCurrentObject();

    protected abstract Enumeration getCurrentEnum();

    protected abstract void setCurrentEnum(Object var1);

    protected abstract void advanceCurrentEnum();

    protected abstract Enumeration createTypedEnumeration(Enumeration var1);

    protected Vector getEnumerations() {
        return this.enumerations;
    }

    protected void ensureStarted() {
        if (this.position < 0) {
            this.myEnumeratedElements.clear();
            this.advance();
        }
    }

    protected void advance() {
        if (this.getCurrentEnum() != null && this.getCurrentEnum().hasMoreElements()) {
            this.advanceCurrentEnum();
            if (this.isRestorable) {
                this.backupCurrentObject();
            }
        } else {
            if (++this.position < this.enumerations.size()) {
                this.setCurrentEnum(this.enumerations.get(this.position));
                this.advance();
                return;
            }
            this.setCurrentObjectNull();
        }
        if (this.getCurrentObject() != null && !this.myEnumeratedElements.add(this.getCurrentObject())) {
            this.advance();
        }
    }

    protected void createBackupEnumeration() {
        this.backupEnum = new BackupEnumeration();
    }

    protected void backupCurrentObject() {
        this.backupEnum.backupObject(this.getCurrentObject());
    }

    public abstract Object nextElement();

    private static class BackupEnumeration
    implements Enumeration {
        private int counter = 0;
        private Vector backupObjects = new Vector();

        private BackupEnumeration() {
        }

        public boolean hasMoreElements() {
            boolean result;
            boolean bl = this.backupObjects == null ? false : (result = this.counter < this.backupObjects.size());
            if (!result) {
                this.backupObjects = null;
            }
            return result;
        }

        public Object nextElement() {
            Object result = this.backupObjects == null ? null : this.backupObjects.get(this.counter++);
            return result;
        }

        public void backupObject(Object obj) {
            this.backupObjects.add(obj);
        }
    }

    private static class VectorEx
    extends Vector {
        private VectorEx() {
        }

        public void removeUpTo(int index) {
            super.removeRange(0, index);
        }
    }
}

