/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.enum;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.ReferenceCollectionEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import java.util.HashSet;

public class ChildrenEnumeration {
    public static ElementEnumeration createChildrenEnumeration(UniqueNameEnumeration uinEnumeration, Instantiator instantiator) {
        ElementEnumerationImpl result = new ElementEnumerationImpl(uinEnumeration, instantiator);
        result.advance();
        return result;
    }

    public static ReferenceCollectionEnumeration createChildReferenceCollectionsEnumeration(UniqueNameEnumeration uinEnumeration, Instantiator instantiator) {
        ReferenceCollectionEnumerationImpl result = new ReferenceCollectionEnumerationImpl(uinEnumeration, instantiator);
        result.advance();
        return result;
    }

    public static EntityEnumeration createChildEntitiesEnumeration(UniqueNameEnumeration uinEnumeration, Instantiator instantiator) {
        EntityEnumerationImpl result = new EntityEnumerationImpl(uinEnumeration, instantiator);
        result.advance();
        return result;
    }

    private static class EntityEnumerationImpl
    implements EntityEnumeration {
        private Entity next = null;
        private UniqueNameEnumeration uinEnumeration;
        private Instantiator instantiator;
        private HashSet processedUins = new HashSet();

        public EntityEnumerationImpl(UniqueNameEnumeration uinEnumeration, Instantiator instantiator) {
            this.uinEnumeration = uinEnumeration;
            this.instantiator = instantiator;
        }

        public Entity next() {
            Entity result = this.next;
            this.advance();
            return result;
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            return this.next();
        }

        public void advance() {
            if (this.uinEnumeration != null && this.uinEnumeration.hasMoreElements()) {
                UniqueName nextUin = this.uinEnumeration.next();
                if (this.processedUins.contains(nextUin)) {
                    this.advance();
                } else {
                    Element nextElement = this.instantiator.findElement(nextUin);
                    if (nextElement instanceof Entity) {
                        this.next = (Entity)nextElement;
                        this.processedUins.add(nextUin);
                    } else {
                        this.advance();
                    }
                }
            } else {
                this.next = null;
            }
        }
    }

    private static class ReferenceCollectionEnumerationImpl
    implements ReferenceCollectionEnumeration {
        private ReferenceCollection next = null;
        private UniqueNameEnumeration uinEnumeration;
        private Instantiator instantiator;

        public ReferenceCollectionEnumerationImpl(UniqueNameEnumeration uinEnumeration, Instantiator instantiator) {
            this.uinEnumeration = uinEnumeration;
            this.instantiator = instantiator;
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            return this.next();
        }

        public ReferenceCollection next() {
            ReferenceCollection result = this.next;
            this.advance();
            return result;
        }

        public void advance() {
            if (this.uinEnumeration != null && this.uinEnumeration.hasMoreElements()) {
                UniqueName nextUin = this.uinEnumeration.next();
                Element nextElement = this.instantiator.findElement(nextUin);
                if (nextElement instanceof ReferenceCollection) {
                    this.next = (ReferenceCollection)nextElement;
                } else {
                    this.advance();
                }
            } else {
                this.next = null;
            }
        }
    }

    private static class ElementEnumerationImpl
    implements ElementEnumeration {
        private Element next = null;
        private UniqueNameEnumeration uinEnumeration;
        private Instantiator instantiator;

        public ElementEnumerationImpl(UniqueNameEnumeration uinEnumeration, Instantiator instantiator) {
            this.uinEnumeration = uinEnumeration;
            this.instantiator = instantiator;
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            return this.next();
        }

        public Element next() {
            Element result = this.next;
            this.advance();
            return result;
        }

        public void advance() {
            if (this.uinEnumeration != null && this.uinEnumeration.hasMoreElements()) {
                UniqueName nextUin = this.uinEnumeration.next();
                this.next = this.instantiator.findElement(nextUin);
                if (this.next == null) {
                    this.advance();
                }
            } else {
                this.next = null;
            }
        }
    }

    public static interface Instantiator {
        public Element findElement(UniqueName var1);
    }
}

