/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.elements;

import com.tssap.selena.impl.model.elements.UniqueNameSerializer;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.Assert;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class UniqueNameImpl
implements UniqueName,
Comparable {
    private String myDomain;
    private String mySubDomain;
    private String myLocation;
    private String myName;
    private String[] myParameters;
    private static final String[] EMPTY_PARAMETERS = new String[0];
    private String myToString;

    public UniqueNameImpl(String domain, String subDomain, String location, String name, String[] parameters) {
        Assert.isLegal(domain != null, "null domain");
        Assert.isLegal(domain.indexOf(":") == -1);
        this.myDomain = domain.intern();
        Assert.isLegal(subDomain == null || subDomain.indexOf(":") == -1);
        this.mySubDomain = subDomain == null ? "" : subDomain.intern();
        Assert.isLegal(location == null || location.indexOf(":") == -1);
        this.myLocation = location == null ? "" : location.intern();
        Assert.isLegal(name == null || name.indexOf(":") == -1);
        String string = this.myName = name == null ? "" : name.intern();
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                Assert.isLegal(parameters[i] != null && parameters[i].indexOf(":") == -1);
                ++i;
            }
            this.myParameters = parameters;
        } else {
            this.myParameters = EMPTY_PARAMETERS;
        }
    }

    public UniqueNameImpl(String uniqueName) {
        Assert.isLegal(uniqueName != null);
        UniqueNameTokenizer tokenizer = new UniqueNameTokenizer(uniqueName, ":");
        Assert.isLegal(tokenizer.hasMoreTokens());
        this.myDomain = tokenizer.nextToken().intern();
        this.mySubDomain = tokenizer.hasMoreTokens() ? tokenizer.nextToken().intern() : "";
        this.myLocation = tokenizer.hasMoreTokens() ? tokenizer.nextToken().intern() : "";
        this.myName = tokenizer.hasMoreTokens() ? tokenizer.nextToken().intern() : "";
        LinkedList<String> parameters = new LinkedList<String>();
        while (tokenizer.hasMoreTokens()) {
            String curParameter = tokenizer.nextToken();
            parameters.add(curParameter);
        }
        this.myParameters = parameters.size() > 0 ? parameters.toArray(new String[parameters.size()]) : EMPTY_PARAMETERS;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            System.err.println("ATTENTION: equals for UIN and String");
            Thread.dumpStack();
        }
        return obj instanceof UniqueNameImpl && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int compareTo(Object o) {
        Assert.isLegal(o instanceof UniqueName);
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        if (this.myToString == null) {
            this.myToString = UniqueNameSerializer.toString(this);
        }
        return this.myToString;
    }

    public String getDomain() {
        return this.myDomain;
    }

    public String getSubDomain() {
        return this.mySubDomain;
    }

    public String getLocation() {
        return this.myLocation;
    }

    public String getName() {
        return this.myName;
    }

    public int getParametersCount() {
        return this.myParameters.length;
    }

    public String getParameter(int index) {
        if (index >= this.getParametersCount()) {
            return null;
        }
        return this.myParameters[index];
    }

    public UniqueName getParentUniqueName() {
        return null;
    }

    private static class UniqueNameTokenizer {
        private int myMaxPosition;
        private int myCurPosition;
        private String myString;
        private String myDelimiter;

        public UniqueNameTokenizer(String baseString, String delimiter) {
            this.myString = baseString;
            this.myDelimiter = delimiter;
            this.myCurPosition = 0;
            this.myMaxPosition = this.myString.length();
        }

        public String nextToken() {
            if (this.myCurPosition >= this.myMaxPosition) {
                throw new NoSuchElementException();
            }
            int nextDelimiterPosition = this.nextDelimiterPosition();
            String result = this.myString.substring(this.myCurPosition, nextDelimiterPosition);
            this.myCurPosition = nextDelimiterPosition + this.myDelimiter.length();
            return result;
        }

        private int nextDelimiterPosition() {
            int result = this.myString.indexOf(this.myDelimiter, this.myCurPosition);
            return result < 0 ? this.myMaxPosition : result;
        }

        public boolean hasMoreTokens() {
            return this.myCurPosition < this.myMaxPosition;
        }
    }
}

