/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.elements;

import com.tssap.selena.impl.model.elements.ModelPlugin;
import com.tssap.selena.impl.model.elements.ProvidersMap;
import com.tssap.selena.impl.model.elements.ReferenceCollectionContent;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ReferenceDeltaTreeProvider;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.delta.CompositeModelDeltaNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReferenceCollectionManager {
    private static Map myModelUin2contents = new HashMap();
    private static HashMap collection2content = new HashMap();

    public static ReferenceCollectionContent getContent(ReferenceCollection collection) {
        return (ReferenceCollectionContent)collection2content.get(collection.getUniqueName());
    }

    public static ReferenceCollectionContent getContent(UniqueName uin) {
        return (ReferenceCollectionContent)collection2content.get(uin);
    }

    public static void totalUpdate(Model model) {
        ArrayList allContents = (ArrayList)myModelUin2contents.get(model.getUniqueName());
        if (allContents == null) {
            return;
        }
        allContents = new ArrayList(allContents);
        Iterator contents = allContents.iterator();
        while (contents.hasNext()) {
            ReferenceCollectionContentImpl content = (ReferenceCollectionContentImpl)contents.next();
            List contentsList = (List)myModelUin2contents.get(model.getUniqueName());
            if (contentsList != null) {
                contentsList.remove(content);
            }
            collection2content.remove(content.getCollection().getUniqueName());
            ReferenceCollectionManager.createContent(content.getCollection());
        }
    }

    public static void createContent(ReferenceCollection collection) {
        if (ReferenceCollectionManager.getContent(collection) != null) {
            ReferenceCollectionManager.removeContent(collection);
        }
        ReferenceCollectionContentImpl content = new ReferenceCollectionContentImpl(collection);
        content.startListening();
        UniqueName modelUin = collection.getModel().getUniqueName();
        ArrayList<ReferenceCollectionContentImpl> contents = (ArrayList<ReferenceCollectionContentImpl>)myModelUin2contents.get(modelUin);
        if (contents == null) {
            contents = new ArrayList<ReferenceCollectionContentImpl>();
            myModelUin2contents.put(modelUin, contents);
        }
        contents.add(content);
        collection2content.put(collection.getUniqueName(), content);
    }

    public static void removeContent(ReferenceCollection collection) {
        UniqueName modelUin = collection.getModel().getUniqueName();
        List contents = (List)myModelUin2contents.get(modelUin);
        if (contents == null) {
            return;
        }
        ReferenceCollectionContent content = (ReferenceCollectionContent)collection2content.remove(collection.getUniqueName());
        if (content != null) {
            content.stopListening();
            contents.remove(content);
        }
    }

    public static void updateReferenceCollections(Model model, Collection changedRCUins) {
        List contents = (List)myModelUin2contents.get(model.getUniqueName());
        if (contents != null) {
            int i = 0;
            while (i < contents.size()) {
                ReferenceCollectionContentImpl content = (ReferenceCollectionContentImpl)contents.get(i);
                if (changedRCUins.contains(content.getCollection().getUniqueName())) {
                    content.update();
                }
                ++i;
            }
        }
    }

    public static void clearAll(Model model) {
        UniqueName modelUin = model.getUniqueName();
        Iterator entries = collection2content.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry nextEntry = entries.next();
            ReferenceCollectionContent nextContent = (ReferenceCollectionContent)nextEntry.getValue();
            if (nextContent != null && nextContent.getCollection() != null && nextContent.getCollection().getModel().getUniqueName() != modelUin) continue;
            nextContent.stopListening();
            entries.remove();
        }
        myModelUin2contents.remove(modelUin);
    }

    private static class ReferenceCollectionContentImpl
    implements ReferenceCollectionContent {
        private CompositeModelDeltaNode myCompositeDelta;
        private ReferenceCollection myCollection;
        static /* synthetic */ Class class$com$tssap$selena$model$extension$ReferenceDeltaTreeProvider;

        public ReferenceCollectionContentImpl(ReferenceCollection collection) {
            Assert.isLegal(collection != null);
            this.myCollection = collection;
            this.myCompositeDelta = null;
        }

        public void startListening() {
            Model model = this.myCollection.getModel();
            List providers = this.getReferenceDeltaTreeProviders(model);
            ReferenceDeltaTreeProvider provider = null;
            int size = providers.size();
            int i = 0;
            while (i < size) {
                provider = (ReferenceDeltaTreeProvider)providers.get(i);
                provider.startCollectingChanges(this.myCollection);
                ++i;
            }
        }

        public void stopListening() {
            Model model = this.myCollection.getModel();
            List providers = this.getReferenceDeltaTreeProviders(model);
            ReferenceDeltaTreeProvider provider = null;
            int size = providers.size();
            int i = 0;
            while (i < size) {
                provider = (ReferenceDeltaTreeProvider)providers.get(i);
                provider.stopCollectingChanges(this.myCollection);
                ++i;
            }
        }

        public ModelDeltaNode getDelta() {
            CompositeModelDeltaNode result = this.myCompositeDelta;
            this.myCompositeDelta = null;
            return result;
        }

        public void update() {
            List providers = this.getReferenceDeltaTreeProviders(this.getCollection().getModel());
            int size = providers.size();
            ReferenceDeltaTreeProvider provider = null;
            int i = 0;
            while (i < size) {
                block7: {
                    provider = (ReferenceDeltaTreeProvider)providers.get(i);
                    ModelDeltaNode collectionDeltaNode = null;
                    try {
                        collectionDeltaNode = provider.getReferenceCollectionChanges(this.getCollection());
                    }
                    catch (Throwable error) {
                        ModelPlugin.log(error);
                        break block7;
                    }
                    if (collectionDeltaNode != null && collectionDeltaNode.getElementUniqueName() == null) {
                        System.out.println("delta node without uin");
                    }
                    if (collectionDeltaNode != null && collectionDeltaNode.getElementUniqueName().equals(this.getCollection().getUniqueName())) {
                        if (this.myCompositeDelta == null) {
                            this.myCompositeDelta = new CompositeModelDeltaNode(collectionDeltaNode, this.getModel());
                        } else {
                            this.myCompositeDelta.addNode(collectionDeltaNode);
                        }
                    }
                }
                ++i;
            }
        }

        public ReferenceCollection getCollection() {
            return this.myCollection;
        }

        protected List getReferenceDeltaTreeProviders(Model model) {
            return ProvidersMap.get(model, class$com$tssap$selena$model$extension$ReferenceDeltaTreeProvider == null ? (class$com$tssap$selena$model$extension$ReferenceDeltaTreeProvider = ReferenceCollectionContentImpl.class$("com.tssap.selena.model.extension.ReferenceDeltaTreeProvider")) : class$com$tssap$selena$model$extension$ReferenceDeltaTreeProvider).providers(model.getUniqueName());
        }

        private Model getModel() {
            return this.myCollection.getModel();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

