/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.elements;

import com.tssap.selena.impl.model.elements.ModelPlugin;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.platform.ProviderDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ProvidersMap {
    public static final ProvidersMap EMPTY_PROVIDERS_MAP = new EmptyProvidersMap();
    private static Map ourModels;
    private static Map ourInstances;
    private Map myCachedProviders = new HashMap();
    private Map myDomainDescriptors;
    private Map mySubDomainDescriptors;
    private Map myLocationDescriptors;
    private Map myPropertyNameDescriptors;
    private Set myAllDescriptors;
    private Class myClazz;
    private Model myModel;

    public ProvidersMap(Model model, Class type) {
        this.myModel = model;
        this.myClazz = type;
    }

    public static void remove(Model model) {
        if (ourModels != null) {
            if (ourInstances != null && ourInstances.get(model) != null) {
                Iterator instances = ((Map)ourInstances.get(model)).values().iterator();
                while (instances.hasNext()) {
                    Object instance = instances.next();
                    if (!(instance instanceof ModelAware)) continue;
                    ((ModelAware)instance).unregistered(model);
                }
                ourInstances.remove(model);
            }
            ourModels.remove(model);
        }
    }

    public static Collection get(Model model) {
        if (ourModels == null || !ourModels.containsKey(model)) {
            return Collections.EMPTY_LIST;
        }
        HashSet result = new HashSet();
        Iterator maps = ((Map)ourModels.get(model)).values().iterator();
        while (maps.hasNext()) {
            result.add(maps.next());
        }
        return result;
    }

    public static ProvidersMap get(Model model, Class type) {
        ProvidersMap map;
        HashMap<Class, ProvidersMap> providersMap;
        if (model == null || model.isDeleted()) {
            return EMPTY_PROVIDERS_MAP;
        }
        if (ourModels == null) {
            ourModels = new HashMap();
        }
        if ((providersMap = (HashMap<Class, ProvidersMap>)ourModels.get(model)) == null) {
            providersMap = new HashMap<Class, ProvidersMap>();
            ourModels.put(model, providersMap);
        }
        if ((map = (ProvidersMap)providersMap.get(type)) == null) {
            map = new ProvidersMap(model, type);
            providersMap.put(type, map);
        }
        return map;
    }

    public List allProviders() {
        this.init();
        if (this.myAllDescriptors == null) {
            this.myAllDescriptors = new HashSet();
            Iterator lists = this.myDomainDescriptors.values().iterator();
            while (lists.hasNext()) {
                List list = (List)lists.next();
                this.myAllDescriptors.addAll(list);
            }
            Iterator lists2 = this.mySubDomainDescriptors.values().iterator();
            while (lists2.hasNext()) {
                List list = (List)lists2.next();
                this.myAllDescriptors.addAll(list);
            }
            Iterator lists3 = this.myPropertyNameDescriptors.values().iterator();
            while (lists3.hasNext()) {
                List list = (List)lists3.next();
                this.myAllDescriptors.addAll(list);
            }
        }
        return this.instances(new ArrayList(this.myAllDescriptors), this.myClazz);
    }

    public List providers(UniqueName uniqueName) {
        List result = this.getCached(uniqueName, "");
        if (result != null) {
            return result;
        }
        this.init();
        result = this.getDescriptorsForDomain(uniqueName.getDomain());
        result.retainAll(this.getDescriptorsForSubDomain(uniqueName.getSubDomain()));
        result.retainAll(this.getDescriptorsForLocation(uniqueName.getLocation()));
        result = this.instances(result, this.myClazz);
        this.cache(uniqueName, "", result);
        return result;
    }

    public List providers(UniqueName uniqueName, String propertyName) {
        if (propertyName == null) {
            return this.providers(uniqueName);
        }
        List result = this.getCached(uniqueName, propertyName);
        if (result != null) {
            return result;
        }
        this.init();
        result = this.getDescriptorsForDomain(uniqueName.getDomain());
        result.retainAll(this.getDescriptorsForSubDomain(uniqueName.getSubDomain()));
        result.retainAll(this.getDescriptorsForLocation(uniqueName.getLocation()));
        result.retainAll(this.getDescriptorsForPropertyName(propertyName));
        result = this.instances(result, this.myClazz);
        this.cache(uniqueName, propertyName, result);
        return result;
    }

    private List instances(List descriptors, Class clazz) {
        HashSet instances = new HashSet(descriptors.size());
        InstanceIterator it = new InstanceIterator(descriptors.iterator(), clazz);
        while (it.hasNext()) {
            instances.add(it.next());
        }
        return new ArrayList(instances);
    }

    public void reset() {
        this.myDomainDescriptors = new HashMap();
        this.mySubDomainDescriptors = new HashMap();
        this.myPropertyNameDescriptors = new HashMap();
        this.myLocationDescriptors = new HashMap();
        this.myAllDescriptors = null;
        Enumeration pds = ModelPlugin.getDefault().getPlatform().providerDescriptors();
        while (pds.hasMoreElements()) {
            ProviderDescriptor pd = (ProviderDescriptor)pds.nextElement();
            if (!pd.isProviderAssignableFrom(this.myClazz) || !pd.isProviderApplicable(this.myModel)) continue;
            StringEnumeration domains = pd.domains(this.myClazz);
            while (domains.hasMoreElements()) {
                Object domain = domains.nextElement();
                ProvidersMap.addProviderDescriptor(this.myDomainDescriptors, pd, domain);
            }
            StringEnumeration subdomains = pd.subdomains(this.myClazz);
            while (subdomains.hasMoreElements()) {
                ProvidersMap.addProviderDescriptor(this.mySubDomainDescriptors, pd, subdomains.nextElement());
            }
            StringEnumeration names = pd.propertyNames(this.myClazz);
            while (names.hasMoreElements()) {
                ProvidersMap.addProviderDescriptor(this.myPropertyNameDescriptors, pd, names.nextElement());
            }
            StringEnumeration names2 = pd.locations(this.myClazz);
            while (names2.hasMoreElements()) {
                ProvidersMap.addProviderDescriptor(this.myLocationDescriptors, pd, names2.nextElement());
            }
        }
    }

    private List getDescriptorsForDomain(String domain) {
        return ProvidersMap.getDescriptorsByKey(this.myDomainDescriptors, domain);
    }

    private List getDescriptorsForSubDomain(String subdomain) {
        return ProvidersMap.getDescriptorsByKey(this.mySubDomainDescriptors, subdomain);
    }

    private List getDescriptorsForPropertyName(String name) {
        return ProvidersMap.getDescriptorsByKey(this.myPropertyNameDescriptors, name);
    }

    private List getDescriptorsForLocation(String name) {
        return ProvidersMap.getDescriptorsByKey(this.myLocationDescriptors, name);
    }

    private void init() {
        if (this.myDomainDescriptors == null) {
            this.reset();
        }
    }

    private static List getDescriptorsByKey(Map map, Object key) {
        ArrayList result = new ArrayList();
        if (map.containsKey(key)) {
            result.addAll((Collection)map.get(key));
        }
        if (map.containsKey("")) {
            result.addAll((Collection)map.get(""));
        }
        return result;
    }

    private static void addProviderDescriptor(Map map, ProviderDescriptor pd, Object key) {
        if (!map.containsKey(key)) {
            map.put(key, new ArrayList());
        }
        ((Collection)map.get(key)).add(pd);
    }

    private List getCached(UniqueName uniqueName, String name) {
        Key key = new Key(uniqueName, name);
        return (List)this.myCachedProviders.get(key);
    }

    private void cache(UniqueName uniqueName, String name, List providers) {
        Key key = new Key(uniqueName, name);
        this.myCachedProviders.put(key, providers);
    }

    private static class EmptyProvidersMap
    extends ProvidersMap {
        private EmptyProvidersMap() {
            super(null, null);
        }

        public List allProviders() {
            return Collections.EMPTY_LIST;
        }

        public List providers(UniqueName uniqueName, String propertyName) {
            return Collections.EMPTY_LIST;
        }

        public List providers(UniqueName uniqueName) {
            return Collections.EMPTY_LIST;
        }

        public void reset() {
        }
    }

    private static class Key {
        private String myDomain;
        private String mySubDomain;
        private String myPropertyName;
        private String myLocation;

        public Key(UniqueName uniqueName, String name) {
            this.myDomain = uniqueName.getDomain();
            this.mySubDomain = uniqueName.getSubDomain();
            this.myLocation = uniqueName.getLocation();
            this.myPropertyName = name;
            if (name == null) {
                this.myPropertyName = "";
            }
        }

        public boolean equals(Object o) {
            return o instanceof Key && ((Key)o).myDomain.equals(this.myDomain) && ((Key)o).mySubDomain.equals(this.mySubDomain) && ((Key)o).myLocation.equals(this.myLocation) && ((Key)o).myPropertyName.equals(this.myPropertyName);
        }

        public int hashCode() {
            return this.myLocation.hashCode() * 5 + this.myDomain.hashCode() * 7 + this.mySubDomain.hashCode() * 11 + this.myPropertyName.hashCode() * 13 + 19;
        }
    }

    private class InstanceIterator
    implements Iterator,
    Enumeration {
        private Iterator mySource;
        private Object myNextObject;
        private Class myClazz;

        public InstanceIterator(Iterator descriptors, Class clazz) {
            this.mySource = descriptors;
            this.myClazz = clazz;
            this.myNextObject = this.advance();
        }

        public Object nextElement() {
            return this.next();
        }

        public Object next() {
            Object result = this.myNextObject;
            this.myNextObject = this.advance();
            return result;
        }

        public boolean hasMoreElements() {
            return this.myNextObject != null;
        }

        public Object advance() {
            if (ourInstances == null) {
                ourInstances = new HashMap();
            }
            if (!ourInstances.containsKey(ProvidersMap.this.myModel)) {
                ourInstances.put(ProvidersMap.this.myModel, new HashMap());
            }
            Map instances = (Map)ourInstances.get(ProvidersMap.this.myModel);
            Object provider = null;
            while (this.mySource.hasNext()) {
                provider = null;
                ProviderDescriptor pd = (ProviderDescriptor)this.mySource.next();
                Object clazz = pd.getProviderClassID();
                provider = instances.get(clazz);
                if (provider != null) {
                    if (this.myClazz.isInstance(provider)) break;
                    ClassCastException cce = new ClassCastException(this.myClazz.getName());
                    ModelPlugin.getDefault().getLog().log((IStatus)new Status(2, "com.tssap.selena.model", 0, "provider: " + clazz + " : ", (Throwable)cce));
                    continue;
                }
                provider = pd.instantiateProvider();
                if (!this.myClazz.isInstance(provider)) continue;
                instances.put(clazz, provider);
                if (!(provider instanceof ModelAware)) break;
                ((ModelAware)provider).registered(ProvidersMap.this.myModel);
                break;
            }
            return provider;
        }

        public boolean hasNext() {
            return this.myNextObject != null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

