/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.elements;

import com.tssap.selena.impl.model.elements.PropertyAdapter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PropertyMapImpl
implements PropertyMap {
    private Map myObjectsMap = new HashMap();
    private List myProperties = new ArrayList();
    private HashMap myPropertyValueMap;
    private Element myElement;

    public PropertyMapImpl(Element element) {
        this.myElement = element;
    }

    public PropertyMapImpl(Map values, Element element) {
        this(element);
        this.putProperty(values);
    }

    public PropertyMapImpl(Property[] properties, Element element) {
        this(element);
        this.putProperty(properties);
    }

    protected void putProperty(Map values) {
        if (!values.isEmpty()) {
            Set set = values.keySet();
            Iterator itr = set.iterator();
            while (itr.hasNext()) {
                Object key = itr.next();
                Object value = values.get(key);
                PropertyAdapter property = new PropertyAdapter((String)key, (String)value, this.myElement);
                this.myProperties.add(property);
            }
        }
    }

    protected void putProperty(Property[] properties) {
        if (properties.length > 0) {
            int i = 0;
            while (i < properties.length) {
                this.myProperties.add(properties[i]);
                ++i;
            }
        }
    }

    public Property getProperty(String propertyName) {
        if (propertyName != null && this.myProperties != null) {
            int i = 0;
            while (i < this.myProperties.size()) {
                Property property = (Property)this.myProperties.get(i);
                if (propertyName.equals(property.getName())) {
                    return property;
                }
                ++i;
            }
        }
        return null;
    }

    public String getPropertyValue(String propertyName) {
        Property property = this.getProperty(propertyName);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    public boolean hasProperty(String propertyName) {
        Property property = this.getProperty(propertyName);
        return property != null;
    }

    public boolean hasPropertyValue(String propertyName, String propertyValue) {
        PropertyEnumeration propEnum = this.properties(propertyName);
        while (propEnum.hasMoreElements()) {
            Property property = propEnum.next();
            if (!(propertyValue != null ? propertyValue.equals(property.getValue()) : property.getValue() == null)) continue;
            return true;
        }
        return false;
    }

    public PropertyEnumeration properties() {
        if (this.myProperties != null) {
            return EnumerationConverter.toPropertyEnumeration(this.myProperties.iterator());
        }
        return EmptyEnumeration.getPropertyEnumeration();
    }

    public PropertyEnumeration properties(String propertyName) {
        PropertyEnumeration propEnum = this.properties();
        if (propertyName == null) {
            return propEnum;
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        while (propEnum.hasMoreElements()) {
            Property property = propEnum.next();
            if (!propertyName.equals(property.getName())) continue;
            properties.add(property);
        }
        return EnumerationConverter.toPropertyEnumeration(properties.iterator());
    }

    public boolean canSetPropertyValue(String propertyName, String propertyValue) {
        return true;
    }

    public Property setPropertyValue(String propertyName, String propertyValue) {
        if (propertyName != null && this.myProperties != null) {
            if (propertyValue != null) {
                int i = 0;
                while (i < this.myProperties.size()) {
                    Property property = (Property)this.myProperties.get(i);
                    if (propertyName.equals(property.getName())) {
                        property.setValue(propertyValue);
                        return property;
                    }
                    ++i;
                }
                this.addProperty(propertyName, propertyValue);
            } else {
                ArrayList<Property> newProperties = new ArrayList<Property>();
                int i = 0;
                while (i < this.myProperties.size()) {
                    Property property = (Property)this.myProperties.get(i);
                    if (!propertyName.equals(property.getName())) {
                        newProperties.add(property);
                    }
                    ++i;
                }
                if (newProperties.size() != this.myProperties.size()) {
                    this.myProperties = newProperties;
                }
            }
        }
        return null;
    }

    public boolean canAddProperty(String propertyName, String propertyValue) {
        return true;
    }

    public Property addProperty(String propertyName, String propertyValue) {
        PropertyAdapter property = new PropertyAdapter(propertyName, propertyValue, this.myElement);
        this.myProperties.add(property);
        return property;
    }

    public boolean isPropertyWritable(String propertyName) {
        return true;
    }

    public boolean isPropertyReadable(String propertyName) {
        return true;
    }

    public Object getObjectPropertyValue(String name) {
        if (name != null) {
            return this.myObjectsMap.get(name);
        }
        return null;
    }

    public void setObjectPropertyValue(String name, Object value) {
        if (value == null && name != null) {
            this.myObjectsMap.remove(name);
        } else if (name != null) {
            this.myObjectsMap.put(name, value);
        }
    }

    public boolean canSetObjectPropertyValue(String name, Object value) {
        return name != null;
    }
}

