/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.elements;

import com.tssap.selena.impl.model.elements.ModelSetup;
import com.tssap.selena.impl.model.view.ViewSetup;
import com.tssap.selena.license.CommonLicense;
import com.tssap.selena.license.UnaryOperation;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.platform.Platform;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.Enumeration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class ModelPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.tssap.selena.model";
    public static final String PLATFORM_EXTENSION_POINT = "platform";
    public static final String CLASS_NAME = "class";
    private boolean myIsLoadingPlatform;
    private Platform myPlatform;
    private static ModelPlugin plugin;

    public ModelPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static ModelPlugin getDefault() {
        return plugin;
    }

    public void startup() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                UnaryOperation function = new UnaryOperation(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public String execute(String value) {
                        byte[] b = value.getBytes();
                        int i = 0;
                        while (i < value.length()) {
                            b[i] = (byte)(b[i] ^ i & 0xFF);
                            ++i;
                        }
                        return new String(b);
                    }
                };
                CommonLicense.isFeatureAvailable((String)"TS", (String)"XJ", (UnaryOperation)function);
            }
        });
        ViewSetup.execute();
        ModelSetup.execute();
    }

    public void shutdown() {
    }

    public Platform getPlatform() {
        if (this.myPlatform == null) {
            this.myPlatform = this.loadPlatform();
            if (this.myPlatform != null) {
                ModelAccess.runCommand(new UndoTransparableCommand(){

                    public void run() {
                        Enumeration modelNames = ModelPlugin.this.myPlatform.modelNames();
                        while (modelNames.hasMoreElements()) {
                            String name = (String)modelNames.nextElement();
                            UniqueName uin = ModelAccess.createModelUniqueName(name);
                            ModelAccess.createModel(uin);
                        }
                    }
                });
            }
        }
        return this.myPlatform;
    }

    public Platform loadPlatform() {
        if (this.myIsLoadingPlatform) {
            return null;
        }
        this.myIsLoadingPlatform = true;
        IExtensionPoint extensionPoint = this.getDescriptor().getExtensionPoint(PLATFORM_EXTENSION_POINT);
        if (extensionPoint == null) {
            this.myIsLoadingPlatform = false;
            return null;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions != null && extensions.length >= 1) {
            IExtension extension = extensions[0];
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            int i = 0;
            while (i < configurationElements.length) {
                if (PLATFORM_EXTENSION_POINT.equals(configurationElements[i].getName())) {
                    try {
                        Platform platform = (Platform)configurationElements[i].createExecutableExtension(CLASS_NAME);
                        this.myIsLoadingPlatform = false;
                        return platform;
                    }
                    catch (CoreException cantLoadPlatform) {
                        cantLoadPlatform.printStackTrace();
                    }
                }
                ++i;
            }
        }
        this.myIsLoadingPlatform = false;
        return null;
    }

    public static void log(Throwable error) {
        if (ModelPlugin.getDefault() != null && ModelPlugin.getDefault().getLog() != null && error != null) {
            Status status = new Status(4, PLUGIN_ID, 0, error.getMessage() == null ? "" : error.getMessage(), error);
            ModelPlugin.getDefault().getLog().log((IStatus)status);
        }
    }
}

