/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.elements;

import com.tssap.selena.impl.model.elements.PropertyAdapter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.SingleEnumeration;

public class ModelNamePropertyProvider
implements PropertyGetProvider {
    private static ModelNamePropertyProvider myself;

    private ModelNamePropertyProvider() {
    }

    public static PropertyGetProvider getInstance() {
        if (myself == null) {
            myself = new ModelNamePropertyProvider();
        }
        return myself;
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return "$name".equals(propertyName) && element instanceof Model;
    }

    public boolean isPropertyReadable(Element element, String propertyName) {
        return true;
    }

    public String getPropertyValue(Element element, String propertyName) {
        UniqueName uin = ((Model)element).getUniqueName();
        return ModelUinSupport.getProjectId(uin);
    }

    public Property getProperty(Element element, String propertyName) {
        return new PropertyAdapter(propertyName, this.getPropertyValue(element, propertyName), element);
    }

    public boolean hasProperty(Element element, String propertyName) {
        return true;
    }

    public PropertyEnumeration properties(Element element) {
        return SingleEnumeration.createPropertyEnumeration(this.getProperty(element, "$name"));
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        return this.properties(element);
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return this.getPropertyValue(element, propertyName).equals(propertyValue);
    }
}

