/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.elements;

import com.tssap.selena.impl.model.elements.Diagnostic;
import com.tssap.selena.impl.model.elements.EntityImpl;
import com.tssap.selena.impl.model.elements.EntityTemplateImpl;
import com.tssap.selena.impl.model.elements.ExtensionManagerImpl;
import com.tssap.selena.impl.model.elements.Implementation;
import com.tssap.selena.impl.model.elements.ModelMetrics;
import com.tssap.selena.impl.model.elements.ModelPlugin;
import com.tssap.selena.impl.model.elements.ModelSetup;
import com.tssap.selena.impl.model.elements.ProvidersMap;
import com.tssap.selena.impl.model.elements.ReferenceCollectionManager;
import com.tssap.selena.impl.model.elements.ReferenceCollectionTemplateImpl;
import com.tssap.selena.impl.model.elements.ReferenceTempateImpl;
import com.tssap.selena.impl.model.view.ViewManagerImpl;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.extension.ExtensionManager;
import com.tssap.selena.model.extension.TemplateProvider;
import com.tssap.selena.model.platform.DebugLevel;
import com.tssap.selena.model.platform.PlatformEvent;
import com.tssap.selena.model.platform.PlatformListener;
import com.tssap.selena.model.util.delta.CompositeModelDeltaNode;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import com.tssap.selena.model.util.various.DeltaDumper;
import com.tssap.selena.model.view.View;
import com.tssap.selena.model.view.ViewAccess;
import com.tssap.selena.model.view.ViewManager;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ModelImpl
extends EntityImpl
implements Model,
PlatformListener {
    private Vector listeners = new Vector();
    private List listenersTree = new ArrayList();
    private ExtensionManagerImpl extensionManager = new ExtensionManagerImpl(this);
    private boolean myUpdatePerformed = false;
    private boolean myIsDeleted = false;
    private long myLastUpdateTime;
    static /* synthetic */ Class class$com$tssap$selena$model$extension$TemplateProvider;
    static /* synthetic */ Class class$com$tssap$selena$model$extension$DeltaTreeProvider;

    public ModelImpl(UniqueName uniqueName) {
        super(uniqueName, uniqueName, null);
        this.setLastUpdateTime();
        ModelPlugin.getDefault().getPlatform().addPlatformListener(this);
    }

    public Reference createReferenceTemplate() {
        return new ReferenceTempateImpl(this.getUniqueName());
    }

    public Entity createEntityTemplate() {
        return new EntityTemplateImpl(this.getUniqueName());
    }

    public ReferenceCollection createReferenceCollectionTemplate() {
        return new ReferenceCollectionTemplateImpl(this.getUniqueName());
    }

    public Reference createReferenceTemplate(Reference original) {
        Reference base = this.createReferenceTemplate();
        List providers = ProvidersMap.get(this, class$com$tssap$selena$model$extension$TemplateProvider == null ? (class$com$tssap$selena$model$extension$TemplateProvider = ModelImpl.class$("com.tssap.selena.model.extension.TemplateProvider")) : class$com$tssap$selena$model$extension$TemplateProvider).providers(original.getUniqueName());
        return (Reference)this.createTemplate(providers, original, base);
    }

    public Entity createEntityTemplate(Entity original) {
        Entity base = this.createEntityTemplate();
        List providers = ProvidersMap.get(this, class$com$tssap$selena$model$extension$TemplateProvider == null ? (class$com$tssap$selena$model$extension$TemplateProvider = ModelImpl.class$("com.tssap.selena.model.extension.TemplateProvider")) : class$com$tssap$selena$model$extension$TemplateProvider).providers(original.getUniqueName());
        return (Entity)this.createTemplate(providers, original, base);
    }

    public ReferenceCollection createReferenceCollectionTemplate(ReferenceCollection original) {
        ReferenceCollection base = this.createReferenceCollectionTemplate();
        List providers = ProvidersMap.get(this, class$com$tssap$selena$model$extension$TemplateProvider == null ? (class$com$tssap$selena$model$extension$TemplateProvider = ModelImpl.class$("com.tssap.selena.model.extension.TemplateProvider")) : class$com$tssap$selena$model$extension$TemplateProvider).providers(original.getUniqueName());
        return (ReferenceCollection)this.createTemplate(providers, original, base);
    }

    protected Element createTemplate(List templateProviders, Element original, Element template) {
        if (original == null) {
            return template;
        }
        Iterator providers = templateProviders.iterator();
        while (providers.hasNext()) {
            TemplateProvider provider = (TemplateProvider)providers.next();
            provider.buildTemplate(original, template);
        }
        return template;
    }

    public Element findElement(UniqueName uniqueName) {
        if (uniqueName == null) {
            return null;
        }
        return Implementation.findElement(this, this.getModelUin(), uniqueName, null);
    }

    public Entity findEntity(UniqueName uniqueName) {
        if (uniqueName == null) {
            return null;
        }
        return Implementation.findEntity(this, this.getModelUin(), uniqueName, null);
    }

    public ReferenceCollection findReferenceCollection(UniqueName uniqueName) {
        if (uniqueName == null) {
            return null;
        }
        return Implementation.findReferenceCollection(this, this.getModelUin(), uniqueName, null);
    }

    public Reference findReference(ReferenceUniqueName referenceUin) {
        if (referenceUin == null) {
            return null;
        }
        return Implementation.findReference(this, referenceUin, null, null);
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public void addModelDeltaListener(ModelChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelDeltaListener(ModelChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireModelChanged(ModelDeltaNode rootNode) {
        if (this.listeners.size() == 0) {
            return;
        }
        ModelChangeEvent event = new ModelChangeEvent(this, rootNode);
        Iterator it = ((AbstractList)((Vector)this.listeners.clone())).iterator();
        while (it.hasNext()) {
            ModelChangeListener next = (ModelChangeListener)it.next();
            next.modelChanged(event);
        }
    }

    public void update() {
        ModelMetrics.start("update");
        if (this.extensionManager.hasChanged()) {
            this.extensionManager.setChanged(false);
            ModelDeltaNode modelDelta = this.updateModel();
            this.updateReferenceCollections(modelDelta);
        }
        if (this.isUpdatePerformed()) {
            this.setLastUpdateTime();
            this.setUpdatePerformed(false);
        }
        ModelMetrics.stop("update");
    }

    private ModelDeltaNode updateModel() {
        CompositeModelDeltaNode compositeModelDeltaNode = this.collectModelDelta(null);
        if (compositeModelDeltaNode != null) {
            if (this.extensionManager.hasChanged()) {
                this.extensionManager.setChanged(false);
            }
            Diagnostic.trace("update", "dispatching model delta");
            if (DebugLevel.ALL.equals(Diagnostic.getLogLevel("update"))) {
                DeltaDumper.dumpDelta(compositeModelDeltaNode);
            }
            if (!compositeModelDeltaNode.isEmpty() || compositeModelDeltaNode.isTotallyChanged()) {
                this.setUpdatePerformed(true);
                this.setLastUpdateTime();
            }
            this.fireModelChanged(compositeModelDeltaNode);
            this.performRename(compositeModelDeltaNode);
            Implementation.renameFinished();
        }
        return compositeModelDeltaNode;
    }

    private void performRename(ModelDeltaNode deltaNode) {
        if (deltaNode.isNew()) {
            Implementation.handleRename(this, deltaNode.getOriginalElementUniqueName(), deltaNode.getElementUniqueName());
        } else if (deltaNode.isDeleted()) {
            Implementation.handleRename(this, deltaNode.getElementUniqueName(), deltaNode.getOriginalElementUniqueName());
        }
        Enumeration children = deltaNode.changedChildren();
        while (children.hasMoreElements()) {
            this.performRename((ModelDeltaNode)children.nextElement());
        }
    }

    private CompositeModelDeltaNode collectModelDelta(CompositeModelDeltaNode compositeModelDeltaNode) {
        List treeProviders = ProvidersMap.get(this, class$com$tssap$selena$model$extension$DeltaTreeProvider == null ? (class$com$tssap$selena$model$extension$DeltaTreeProvider = ModelImpl.class$("com.tssap.selena.model.extension.DeltaTreeProvider")) : class$com$tssap$selena$model$extension$DeltaTreeProvider).providers(this.getUniqueName());
        int treeProvidersSize = treeProviders.size();
        DeltaTreeProvider treeProvider = null;
        int i = 0;
        while (i < treeProvidersSize) {
            block6: {
                treeProvider = (DeltaTreeProvider)treeProviders.get(i);
                ModelDeltaNode curRootDeltaNode = null;
                try {
                    curRootDeltaNode = treeProvider.getModelChanges();
                }
                catch (Throwable error) {
                    ModelPlugin.log(error);
                    break block6;
                }
                if (curRootDeltaNode != null && !curRootDeltaNode.isEmpty()) {
                    if (compositeModelDeltaNode == null) {
                        compositeModelDeltaNode = new CompositeModelDeltaNode(curRootDeltaNode, this);
                    } else {
                        compositeModelDeltaNode.addNode(curRootDeltaNode);
                    }
                }
            }
            ++i;
        }
        return compositeModelDeltaNode;
    }

    private void updateReferenceCollections(ModelDeltaNode modelDelta) {
        Collection changedRCs = this.extensionManager.getChangedReferenceCollections();
        this.extensionManager.flushChangedReferenceCollections();
        ReferenceCollectionManager.updateReferenceCollections(this, changedRCs);
        ViewManager manager = ViewAccess.getViewManager(this.getUniqueName());
        if (manager instanceof ViewManagerImpl) {
            ((ViewManagerImpl)manager).update(modelDelta);
        }
    }

    public Entity getParent() {
        return null;
    }

    public boolean canDelete() {
        return !this.isDeleted();
    }

    public boolean isDeleted() {
        return this.myIsDeleted;
    }

    public void delete() {
        if (this.canDelete()) {
            ReferenceCollectionManager.clearAll(this);
            ModelPlugin.getDefault().getPlatform().removePlatformListener(this);
            ModelSetup.removeModel(this);
            this.myIsDeleted = true;
            ProvidersMap.remove(this);
            ModelAccess.notifyModelDeleted(this);
            this.listeners.clear();
        }
    }

    public boolean isUpdatePerformedSince(long timeToCheck) {
        return timeToCheck < this.myLastUpdateTime;
    }

    public void setLastUpdateTime() {
        this.myLastUpdateTime = System.currentTimeMillis();
    }

    public void setUpdatePerformed(boolean performed) {
        this.myUpdatePerformed = performed;
    }

    public boolean isUpdatePerformed() {
        return this.myUpdatePerformed;
    }

    public void providersSetChanged(PlatformEvent event) {
        Diagnostic.trace("update", "nature changed, reregistering providers");
        ProvidersMap.remove(this);
        Iterator providers = ProvidersMap.get(this, class$com$tssap$selena$model$extension$DeltaTreeProvider == null ? (class$com$tssap$selena$model$extension$DeltaTreeProvider = ModelImpl.class$("com.tssap.selena.model.extension.DeltaTreeProvider")) : class$com$tssap$selena$model$extension$DeltaTreeProvider).allProviders().iterator();
        while (providers.hasNext()) {
            Object provider = providers.next();
            Diagnostic.trace("update", "delta tree provider reinstantiated : " + provider);
        }
        RootModelDeltaNode delta = new RootModelDeltaNode(this);
        delta.makeTotallyChanged();
        this.setLastUpdateTime();
        ReferenceCollectionManager.totalUpdate(this);
        this.fireModelChanged(delta);
        Diagnostic.trace("update", "closing views");
        Enumeration views = ViewAccess.getViewManager(this.getUniqueName()).views();
        while (views.hasMoreElements()) {
            View view = (View)views.nextElement();
            if (view.getReferenceCollection() == null || view.getReferenceCollection().isDeleted()) {
                Diagnostic.trace("update", "disposing : " + view);
                ViewAccess.getViewManager(this.getUniqueName()).disposeView(view);
                continue;
            }
            Diagnostic.trace("update", "left for update : " + view.getReferenceCollection());
        }
        Diagnostic.trace("update", "updating views");
        ViewAccess.getViewManager(this.getUniqueName()).updateAllViews();
    }

    public void undoMarkerStarted() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

