/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.elements;

import com.tssap.selena.impl.model.elements.DeletedEntityImpl;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceUniqueName;
import com.tssap.selena.model.elements.UniqueName;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class ModelCache {
    private static final int DEFAULT_TRESHHOLD = 1;
    private HashMap uin2instanceRef = new HashMap();
    private HashMap myDeletedElements = new HashMap();
    private ReferenceQueue queue = new ReferenceQueue();
    private Model myModel;
    private int myTreshHold = 1;
    private static HashMap ourInstances = new HashMap();

    private ModelCache(Model model) {
        this.myModel = model;
        this.put(model);
    }

    public static ModelCache getInstance(Model model) {
        if (!ourInstances.containsKey(model)) {
            ourInstances.put(model, new ModelCache(model));
        }
        return (ModelCache)ourInstances.get(model);
    }

    static void removeCache(Model model) {
        ourInstances.remove(model);
    }

    public boolean contains(UniqueName uniqueName) {
        boolean result = false;
        WeakReference ref = (WeakReference)this.uin2instanceRef.get(uniqueName);
        result = ref != null && !ref.isEnqueued();
        return result;
    }

    public Element get(UniqueName uniqueName) {
        return this.get(uniqueName, uniqueName instanceof ReferenceUniqueName);
    }

    private Element get(UniqueName uniqueName, boolean referenceIntegrityChecking) {
        Element result = null;
        WeakReference ref = (WeakReference)this.uin2instanceRef.get(uniqueName);
        if (ref != null && !ref.isEnqueued()) {
            result = (Element)ref.get();
        }
        --this.myTreshHold;
        if (this.myTreshHold == 0) {
            this.cleanup();
            this.myTreshHold = 1;
        }
        if (!referenceIntegrityChecking || this.checkReferenceIntegrity(result)) {
            return result;
        }
        this.uin2instanceRef.remove(uniqueName);
        return null;
    }

    public void put(Element element) {
        this.uin2instanceRef.put(element.getUniqueName(), new WeakReferenceEx(element, this.queue));
        this.myDeletedElements.remove(element.getUniqueName());
    }

    public boolean isDeleted(UniqueName uniqueName) {
        return this.myDeletedElements.containsKey(uniqueName);
    }

    public Element getDeleted(UniqueName uniqueName) {
        return (Element)this.myDeletedElements.get(uniqueName);
    }

    public void delete(Element element) {
        this.myDeletedElements.put(element.getUniqueName(), new DeletedEntityImpl(element, this.myModel.getUniqueName()));
        this.uin2instanceRef.remove(element.getUniqueName());
    }

    public void updateFinished() {
        this.myDeletedElements.clear();
    }

    private boolean checkReferenceIntegrity(Element reference) {
        Entity referencedEntity;
        if (reference instanceof Reference && (referencedEntity = ((Reference)reference).getEntity()) != null) {
            return referencedEntity == this.get(referencedEntity.getUniqueName(), false);
        }
        return true;
    }

    protected void cleanup() {
        WeakReferenceEx ref = (WeakReferenceEx)this.queue.poll();
        while (ref != null) {
            this.uin2instanceRef.remove(ref.getUin());
            ref = (WeakReferenceEx)this.queue.poll();
        }
    }

    private static class WeakReferenceEx
    extends WeakReference {
        private UniqueName uin;

        public WeakReferenceEx(Element element, ReferenceQueue queue) {
            super(element, queue);
            this.uin = element.getUniqueName();
        }

        public UniqueName getUin() {
            return this.uin;
        }
    }
}

