/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.elements;

import com.tssap.selena.impl.model.elements.ModelPlugin;
import com.tssap.selena.impl.model.elements.PropertyMapImpl;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ExtensionManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class ExtensionManagerImpl
implements ExtensionManager {
    private Model myModel;
    private boolean myHasChanged;
    private Collection myChangedReferenceCollections = new HashSet();

    public ExtensionManagerImpl(Model model) {
        this.myModel = model;
    }

    public PropertyMap createPropertyMap(Element element) {
        PropertyMapImpl propertyMap = new PropertyMapImpl(element);
        return propertyMap;
    }

    public void modelContentsChanged() {
        if (!this.myHasChanged) {
            this.setChanged(true);
            ModelPlugin.getDefault().getPlatform().contentsChanged();
        }
    }

    public void referenceCollectionContentsChanged(UniqueName referenceCollection) {
        if (!this.myChangedReferenceCollections.contains(referenceCollection)) {
            this.addChangedReferenceCollection(referenceCollection);
            ModelPlugin.getDefault().getPlatform().contentsChanged();
        }
    }

    private void addChangedReferenceCollection(UniqueName uniqueName) {
        this.myChangedReferenceCollections.add(uniqueName);
    }

    Collection getChangedReferenceCollections() {
        return this.myChangedReferenceCollections;
    }

    void flushChangedReferenceCollections() {
        this.myChangedReferenceCollections = new HashSet();
    }

    void setChanged(boolean changed) {
        this.myHasChanged = changed;
    }

    boolean hasChanged() {
        return this.myHasChanged;
    }

    public PropertyMap createPropertyMap(Map values, Element element) {
        PropertyMapImpl propertyMap = new PropertyMapImpl(values, element);
        return propertyMap;
    }

    public PropertyMap createPropertyMap(Property[] properties, Element element) {
        PropertyMapImpl propertyMap = new PropertyMapImpl(properties, element);
        return propertyMap;
    }
}

