/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.impl.model.elements;

import com.tssap.selena.impl.model.elements.PropertyMapImpl;
import com.tssap.selena.impl.model.elements.ReferenceCollectionTemplateImpl;
import com.tssap.selena.impl.model.enum.CompositeEnumeration;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.ParticipantEnumeration;
import com.tssap.selena.model.enum.ReferenceCollectionEnumeration;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class EntityTemplateImpl
extends PropertyMapImpl
implements Entity {
    private UniqueName myModelUin;
    private HashMap myRoles2Participant = new HashMap();
    private Collection myChildEntities;
    private Collection myChildRC;

    public EntityTemplateImpl(UniqueName modelUin) {
        super(null);
        this.myModelUin = modelUin;
    }

    public Model getModel() {
        return ModelAccess.getModel(this.myModelUin);
    }

    public ElementEnumeration participants(String role) {
        Set participants = (Set)this.myRoles2Participant.get(role);
        if (participants == null) {
            return EmptyEnumeration.getElementEnumeration();
        }
        return EnumerationConverter.toElementEnumeration(Collections.enumeration(participants));
    }

    public StringEnumeration participantRoles() {
        Set roles = this.myRoles2Participant.keySet();
        return EnumerationConverter.toStringEnumeration(roles.iterator());
    }

    public void setParticipant(String role, Element oldParticipant, Element newParticipant) {
        this.unregisterParticipant(role, oldParticipant);
        if (newParticipant != null) {
            this.registerParticipant(role, newParticipant);
        }
    }

    public void setParticipant(Element participant, String oldRole, String newRole) {
        this.unregisterParticipant(oldRole, participant);
        if (newRole != null) {
            this.registerParticipant(newRole, participant);
        }
    }

    public boolean canSetParticipant(Element participant, String oldRole, String newRole) {
        return true;
    }

    public boolean canSetParticipant(String role, Element oldParticipant, Element newParticipant) {
        return true;
    }

    private void registerParticipant(String role, Element participant) {
        HashSet<Element> participants = (HashSet<Element>)this.myRoles2Participant.get(role);
        if (participants == null) {
            participants = new HashSet<Element>();
            this.myRoles2Participant.put(role, participants);
        }
        participants.add(participant);
    }

    private void unregisterParticipant(String role, Element participant) {
        Set participants = (Set)this.myRoles2Participant.get(role);
        if (participants == null) {
            return;
        }
        participants.remove(participant);
    }

    public EntityEnumeration children() {
        CompositeEnumeration result = new CompositeEnumeration();
        result.add(this.childEntities());
        result.add(this.childReferenceCollections());
        return EnumerationConverter.toEntityEnumeration(result);
    }

    public EntityEnumeration childEntities() {
        if (this.myChildEntities == null) {
            return EmptyEnumeration.getEntityEnumeration();
        }
        return EnumerationConverter.toEntityEnumeration(Collections.enumeration(this.myChildEntities));
    }

    public ReferenceCollectionEnumeration childReferenceCollections() {
        if (this.myChildRC == null) {
            return EmptyEnumeration.getReferenceCollectionEnumeration();
        }
        return EnumerationConverter.toReferenceCollectionEnumeration(Collections.enumeration(this.myChildRC));
    }

    public Element paste(Element element, Element anchor, boolean before) {
        return null;
    }

    public boolean canPaste(Element element) {
        return false;
    }

    public boolean canPaste(Element element, Element anchor, boolean before) {
        return false;
    }

    public ReferenceCollection createChildReferenceCollection(String shapeType, ReferenceCollection template) {
        ReferenceCollectionTemplateImpl result = new ReferenceCollectionTemplateImpl(this.myModelUin);
        result.setPropertyValue("$metaclass", shapeType);
        if (this.myChildRC == null) {
            this.myChildRC = new ArrayList();
        }
        this.myChildRC.add(result);
        return result;
    }

    public boolean canCreateChildReferenceCollection(String shapeType, ReferenceCollection template) {
        return true;
    }

    public Entity createChildEntity(String shapeType, Entity template) {
        EntityTemplateImpl result = new EntityTemplateImpl(this.myModelUin);
        result.setPropertyValue("$metaclass", shapeType);
        if (this.myChildEntities == null) {
            this.myChildEntities = new ArrayList();
        }
        this.myChildEntities.add(result);
        return result;
    }

    public boolean canCreateChildEntity(String shapeType, Entity template) {
        return true;
    }

    public Entity copy() {
        return null;
    }

    public boolean canCopy() {
        return false;
    }

    public Entity cut() {
        return null;
    }

    public boolean canCut() {
        return false;
    }

    public UniqueName getUniqueName() {
        return null;
    }

    public Entity getParent() {
        return null;
    }

    public void delete() {
    }

    public boolean canDelete() {
        return false;
    }

    public boolean isDeleted() {
        return false;
    }

    public Element paste(Element element) {
        return null;
    }

    public Enumeration objectPropertyValues(String propertyName) {
        return EmptyEnumeration.getEnumeration();
    }

    public ParticipantEnumeration allParticipants() {
        return EmptyEnumeration.getParticipantEnumeration();
    }
}

