/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.sysfunc;

import com.sap.mw.rfc.api.IRfcFunction;
import com.sap.mw.rfc.api.IRfcParameter;
import com.sap.mw.rfc.api.RfcApi;
import com.sap.mw.rfc.data.RfcChar;
import com.sap.mw.rfc.engine.RfcIoControl;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.exceptions.RfcException;

public final class RfcSetRegServerProperty
implements IRfcFunction {
    private static final String name = "RFC_SET_REG_SERVER_PROPERTY";
    private static final String[] documentation = new String[]{"Set different properties for an registered server", "", "IMPORTING", "  EXCLUSIV(1): 'Y': Start exclusiv use of this reg. server", "               'N': Stop  exclusiv use of this reg. server", "               'E': Disconnect"};

    public String getName() {
        return name;
    }

    public void execute(long handle) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(handle);
        IRfcParameter[] imp = new IRfcParameter[1];
        RfcChar exclusiv = new RfcChar(act_cntl, "EXCLUSIV");
        exclusiv.setValue("N");
        imp[0] = exclusiv;
        RfcApi.RfcGetData(handle, imp, null, null);
        char result = exclusiv.toString().charAt(0);
        if (result == 'Y') {
            act_cntl.reg_exclusiv = true;
        } else if (result == 'N') {
            act_cntl.reg_exclusiv = false;
        } else if (result == 'E') {
            act_cntl.reg_exclusiv = false;
            act_cntl.close_pending = true;
        }
        RfcApi.RfcSendData(handle, null, null, null);
    }

    public String[] getDocumentation() {
        return documentation;
    }
}

