/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.sysfunc;

import com.sap.mw.jco.JCO;
import com.sap.mw.rfc.api.IRfcFunction;
import com.sap.mw.rfc.api.IRfcTable;
import com.sap.mw.rfc.api.RfcApi;
import com.sap.mw.rfc.data.DocuTable;
import com.sap.mw.rfc.engine.RfcGetName;
import com.sap.mw.rfc.engine.RfcIoControl;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.exceptions.RfcException;

public class RfcDocu
implements IRfcFunction {
    private static final String name = "RFC_DOCU";
    private static final String[] documentation = new String[]{"Returns the list of implemented functions with their documentation.", "", "TABLES", "  DOCU           C(80)", "    contains documentation text."};

    public String getName() {
        return name;
    }

    public void execute(long handle) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(handle);
        RfcApi.RfcGetData(handle, null, null, null);
        IRfcTable[] tables = new IRfcTable[1];
        DocuTable docu = new DocuTable(act_cntl, "DOCU");
        tables[0] = docu;
        JCO.Table docuTable = docu.getTable();
        IRfcFunction[] installedFunctions = RfcGetName.getInstalledFunctions();
        docuTable.ensureBufferCapacity(installedFunctions.length * 10);
        int i = 0;
        while (i < installedFunctions.length) {
            docuTable.appendRow();
            docuTable.setValue(installedFunctions[i].getName(), 0);
            docuTable.appendRow();
            docuTable.setValue("", 0);
            String[] functionDocumentation = installedFunctions[i].getDocumentation();
            if (functionDocumentation != null) {
                int j = 0;
                while (j < functionDocumentation.length) {
                    docuTable.appendRow();
                    docuTable.setValue(' ' + functionDocumentation[j], 0);
                    ++j;
                }
                docuTable.appendRow();
                docuTable.appendRow();
            }
            ++i;
        }
        RfcApi.RfcSendData(handle, null, null, tables);
    }

    public String[] getDocumentation() {
        return documentation;
    }
}

