/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.engine;

import com.sap.mw.jco.JCO;
import com.sap.mw.jco.util.Codecs;
import com.sap.mw.jco.util.FastStringBuffer;
import com.sap.mw.jco.util.SAPByteToCharConverter;
import com.sap.mw.jco.util.SAPConverters;
import com.sap.mw.rfc.api.IRfcComplexParameter;
import com.sap.mw.rfc.data.ItStream;
import com.sap.mw.rfc.data.LZTable;
import com.sap.mw.rfc.engine.AbSysInfo;
import com.sap.mw.rfc.engine.GUID;
import com.sap.mw.rfc.engine.RfcGetData_Input;
import com.sap.mw.rfc.engine.RfcGetImp;
import com.sap.mw.rfc.engine.RfcGetInfo;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.RfcUtilities;
import com.sap.mw.rfc.engine.RfcValInfo;
import com.sap.mw.rfc.engine.Trc;
import com.sap.mw.rfc.engine.XReceiveSearchInfo;
import com.sap.mw.rfc.exceptions.RfcGetException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public abstract class RfcImp {
    static void ab_rfccheck_uuid(RfcIoOpenCntl act_cntl, int readleng) throws RfcGetException {
        byte[] uuid = new byte[16];
        RfcValInfo valinfo = new RfcValInfo();
        valinfo.RfcSetValInfoScalar(uuid, uuid.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, readleng);
        if (!act_cntl.rfc_uuid_set) {
            act_cntl.rfc_uuid = uuid;
            act_cntl.rfc_uuid_set = true;
            if (act_cntl.trace) {
                Trc.ab_rfctrc(new FastStringBuffer(128).append("UUID: ab_rfccheck_uuid take uuid over ").append(GUID.toString(act_cntl.rfc_uuid)).append("\n").toString());
            }
        } else {
            if (act_cntl.trace) {
                Trc.ab_rfctrc(new FastStringBuffer(128).append("UUID: ab_rfccheck_uuid compare uuid's ").append(GUID.toString(uuid)).append("\n").toString());
            }
            if (!GUID.equals(uuid, act_cntl.rfc_uuid)) {
                Trc.criticalTrace(act_cntl, "Mismatch between rfc uuid's detected:");
                Trc.criticalTrace(act_cntl, " own      uuid: " + GUID.toString(act_cntl.rfc_uuid));
                Trc.criticalTrace(act_cntl, " received uuid: " + GUID.toString(uuid));
                Trc.criticalTrace(act_cntl, "Invalid Conversation Id ?");
                Trc.criticalTrace(act_cntl, "Connection Data:");
                Trc.criticalTrace(act_cntl, "  ip:  " + AbSysInfo.IpAddress);
                Trc.criticalTrace(act_cntl, "  rip: " + act_cntl.target);
                Trc.criticalTrace(act_cntl, "  dest:" + act_cntl.destination);
                Trc.criticalTrace(act_cntl, "  rfc_role: " + act_cntl.rfc_role);
                throw new RfcGetException(2, new FastStringBuffer(128).append("Invalid uuid detected own: ").append(GUID.toString(act_cntl.rfc_uuid)).append(" given: ").append(GUID.toString(uuid)).toString());
            }
        }
    }

    static void ab_rfctcontLZ(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng, boolean last) throws RfcGetException {
        int rc = 0;
        if (last) {
            if (null == getinfo.tab_tabh || null == getinfo.tab_tabh_compr) {
                if (null != getinfo.tab_tabh_compr) {
                    getinfo.tab_tabh_compr = null;
                }
                if (act_cntl.trace) {
                    Trc.ab_rfctrc("ab_rfctcontLZ :: Error : getinfo.tab_tabh(_compr)=NULL (p=" + getinfo.name + "')\n");
                }
                return;
            }
            rc = ItStream.decompress(getinfo.tab_tabh, getinfo.tab_tabh_compr, getinfo.remote_tab_leng);
            if (rc > 0) {
                throw new RfcGetException(14, "CALL_FUNCTION_LZ_EXPAND_ERROR");
            }
            getinfo.tab_tabh_compr = null;
        } else {
            if (null == getinfo.tab_tabh) {
                RfcValInfo valinfo = new RfcValInfo();
                valinfo.RfcSetValInfoScalar(null, 0);
                RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
                if (act_cntl.trace) {
                    Trc.ab_rfctrc("ab_rfctcontLZ :: Error : getinfo.tab_tabh(_compr)=NULL (p=" + getinfo.name + "')\n");
                }
                return;
            }
            if (null == getinfo.tab_tabh_compr) {
                getinfo.tab_tabh_compr = new LZTable("*LZ*");
            }
            RfcValInfo valinfo = new RfcValInfo();
            byte[] newLine = new byte[leng];
            valinfo.RfcSetValInfoScalar(newLine, leng);
            RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
            getinfo.tab_tabh_compr.appendRow(newLine);
        }
    }

    static boolean receiveXMLData(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng) throws RfcGetException {
        switch (getinfo.complexParameterState) {
            case 1: {
                int i;
                RfcValInfo valinfo = new RfcValInfo();
                byte[] buffer = new byte[leng];
                valinfo.RfcSetValInfoScalar(buffer, leng);
                RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
                XReceiveSearchInfo sinfo = getinfo.search_info;
                String parameterName = null;
                boolean index = false;
                try {
                    parameterName = new String(buffer, 1, Math.min(150, buffer.length - 1), "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
                int where = parameterName.indexOf(62);
                if (where > -1) {
                    parameterName = parameterName.substring(0, where);
                }
                parameterName = RfcImp.unescapeName(parameterName);
                boolean found = false;
                if (sinfo.ddescr_imp != null) {
                    i = 0;
                    while (i < sinfo.ddescr_imp.length) {
                        if (sinfo.ddescr_imp[i].getType() == 42 && parameterName.equalsIgnoreCase(sinfo.ddescr_imp[i].getName())) {
                            getinfo.complexParameter = (IRfcComplexParameter)sinfo.ddescr_imp[i];
                            found = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (!found && sinfo.ddescr_chn != null) {
                    i = 0;
                    while (i < sinfo.ddescr_chn.length) {
                        if (sinfo.ddescr_chn[i].getType() == 42 && parameterName.equalsIgnoreCase(sinfo.ddescr_chn[i].getName())) {
                            getinfo.complexParameter = (IRfcComplexParameter)sinfo.ddescr_chn[i];
                            found = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (found) {
                    getinfo.complexParameterState = 2;
                    getinfo.complexParameter.receiveXmlDataStarted();
                    getinfo.complexParameter.setXmlBytes(buffer);
                    if (act_cntl.trace) {
                        Trc.ab_rfctrc("Receiving XML Parameter: " + parameterName + '\n');
                    }
                } else {
                    getinfo.complexParameterState = 3;
                    if (act_cntl.trace) {
                        Trc.ab_rfctrc("***Discarding unrequested XML Parameter: " + parameterName + '\n');
                    }
                }
                return true;
            }
            case 2: {
                RfcValInfo valinfo = new RfcValInfo();
                byte[] buffer = new byte[leng];
                valinfo.RfcSetValInfoScalar(buffer, leng);
                RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
                getinfo.complexParameter.setXmlBytes(buffer);
                return true;
            }
        }
        return false;
    }

    static void receiveXMLParameter(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo) throws RfcGetException {
        switch (getinfo.complexParameterState) {
            case 0: {
                getinfo.complexParameterState = 1;
                break;
            }
            case 2: {
                getinfo.complexParameter.receiveXmlDataFinished();
            }
            default: {
                getinfo.complexParameterState = 0;
                getinfo.complexParameter = null;
            }
        }
    }

    static boolean ab_rfctcompr(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng) throws RfcGetException {
        RfcValInfo valinfo = new RfcValInfo();
        int fill = 0;
        boolean brc = false;
        if (getinfo.tab_tabh == null) {
            valinfo.RfcSetValInfoScalar(null, leng);
            --getinfo.tab_fill;
            RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        } else {
            byte[] newLine = new byte[getinfo.remote_tab_leng];
            RfcGetData_Input input = new RfcGetData_Input();
            valinfo.RfcSetValInfoScalar(newLine, getinfo.remote_tab_leng);
            input.handle = act_cntl;
            input.addr = null;
            input.senderLeng = getinfo.remote_tab_leng;
            RfcGetImp.rfc_getdata(input, valinfo, leng, 2);
            getinfo.tab_tabh.appendRow(newLine);
            fill = getinfo.tab_tabh.getNumRows();
        }
        brc = fill >= getinfo.tab_fill;
        return brc;
    }

    static boolean ab_rfctcontent(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng) throws RfcGetException {
        RfcValInfo valinfo = new RfcValInfo();
        boolean brc = false;
        int fill = 0;
        if (getinfo.tab_tabh == null) {
            int count = leng / getinfo.tab_leng;
            valinfo.RfcSetValInfoScalar(null, leng);
            if (count < 1) {
                count = 1;
            }
            getinfo.tab_fill -= count;
            RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        } else {
            byte[] newLine = new byte[leng];
            valinfo.RfcSetValInfoScalar(newLine, leng);
            RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
            getinfo.tab_tabh.appendRow(newLine);
            fill = getinfo.tab_tabh.getNumRows();
        }
        brc = fill >= getinfo.tab_fill;
        return brc;
    }

    static boolean ab_rfctinfo(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng) throws RfcGetException {
        RfcValInfo valinfo = new RfcValInfo();
        byte[] buffer = new byte[8];
        int tabfill = 0;
        int tableng = 0;
        boolean rc = false;
        int i = 0;
        valinfo.RfcSetValInfoScalar(buffer, buffer.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        tableng = RfcUtilities.ICM15(buffer);
        getinfo.tab_fill = tabfill = RfcUtilities.ICM15(buffer, 4);
        getinfo.tab_leng = tableng;
        getinfo.tab_real_leng = 0;
        getinfo.remote_tab_leng = tableng;
        getinfo.tab_tabh = null;
        boolean found = false;
        if (getinfo.search_info.tdescr != null) {
            i = 0;
            while (i < getinfo.search_info.tdescr.length) {
                String tmpName = getinfo.search_info.tdescr[i].getName();
                if (tmpName.equalsIgnoreCase(getinfo.name)) {
                    getinfo.tab_tabh = getinfo.search_info.tdescr[i];
                    getinfo.tab_tabh.clear();
                    found = true;
                    if (tabfill <= 1) break;
                    getinfo.tab_tabh.ensureBufferCapacity(tabfill);
                    break;
                }
                ++i;
            }
        }
        if (act_cntl.trace) {
            if (found) {
                Trc.ab_rfctrc("Received Table: " + getinfo.name + '\n');
            } else {
                Trc.ab_rfctrc("***Discarding unrequested Table: " + getinfo.name + '\n');
            }
        }
        return tabfill == 0;
    }

    static void ab_rfcname(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int leng, int rfcid) throws RfcGetException {
        RfcValInfo valinfo = new RfcValInfo();
        byte[] buffer = new byte[leng];
        char[] tmp = null;
        valinfo.RfcSetValInfoScalar(buffer, buffer.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        try {
            SAPByteToCharConverter converter = SAPConverters.getSAPByteToCharConverter(act_cntl.charset);
            tmp = converter.convert(buffer, 0, valinfo.imp_leng - 1);
        }
        catch (Exception ex) {
            String msg = new String("ab_rfcname trouble: " + ex.getMessage());
            throw new RfcGetException(14, msg);
        }
        getinfo.name = new String(tmp);
    }

    static void ab_rfchead(RfcIoOpenCntl act_cntl, int readleng) throws RfcGetException {
        byte[] rfcHeader = new byte[8];
        RfcValInfo valinfo = new RfcValInfo();
        String msg = null;
        valinfo.RfcSetValInfoScalar(rfcHeader, rfcHeader.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, readleng);
        act_cntl.version = rfcHeader[0];
        act_cntl.intformat = rfcHeader[1];
        act_cntl.floatformat = rfcHeader[2];
        act_cntl.compression = rfcHeader[3];
        rfcHeader[4] = (byte)(rfcHeader[4] + 48);
        rfcHeader[5] = (byte)(rfcHeader[5] + 48);
        rfcHeader[6] = (byte)(rfcHeader[6] + 48);
        rfcHeader[7] = (byte)(rfcHeader[7] + 48);
        try {
            act_cntl.charset = new String(rfcHeader, 4, 4, "US-ASCII");
            act_cntl.real_charset = new String(act_cntl.charset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RfcGetException(14, "could not convert rfc header from binary to string");
        }
        boolean bl = act_cntl.conv_int = AbSysInfo.intformat != act_cntl.intformat;
        act_cntl.conv_float = act_cntl.conv_int ? true : AbSysInfo.floatformat != act_cntl.floatformat;
        act_cntl.conv_char = act_cntl.charset.compareTo(act_cntl.codepage) != 0;
        boolean bl2 = act_cntl.conversion = act_cntl.conv_int || act_cntl.conv_float || act_cntl.conv_char;
        if (act_cntl.version > 3) {
            msg = new String("Error invalid protocol version received" + act_cntl.version + "\n\n");
            if (act_cntl.trace) {
                Trc.ab_rfctrc(msg);
            }
            throw new RfcGetException(19, msg);
        }
        switch (act_cntl.compression) {
            case 5: {
                act_cntl.pcs = (byte)2;
                break;
            }
            case 6: {
                act_cntl.pcs = (byte)4;
                break;
            }
            case 1: {
                act_cntl.pcs = 1;
                break;
            }
            default: {
                msg = new String("Error invalid compression value %u received" + act_cntl.compression + "\n\n");
                if (act_cntl.trace) {
                    Trc.ab_rfctrc(msg);
                }
                throw new RfcGetException(19, msg);
            }
        }
        if (act_cntl.pcs != 2) {
            if (act_cntl.rfc_role == 'S') {
                act_cntl.communication_cp = new String(act_cntl.charset);
            } else if (act_cntl.communication_cp.compareTo(act_cntl.charset) != 0) {
                act_cntl.changeComm_cp = true;
            }
        } else {
            act_cntl.communication_cp = new String(act_cntl.charset);
        }
        act_cntl.real_pcs = act_cntl.pcs;
    }

    static void ab_rfcUnicodeHeader(RfcIoOpenCntl act_cntl, int readleng) throws RfcGetException {
        byte[] rfcUnicodeHeader = new byte[11];
        byte[] subSym = new byte[4];
        RfcValInfo valinfo = new RfcValInfo();
        int sS = 0;
        valinfo.RfcSetValInfoScalar(rfcUnicodeHeader, rfcUnicodeHeader.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, readleng);
        rfcUnicodeHeader[0] = (byte)(rfcUnicodeHeader[0] + 48);
        rfcUnicodeHeader[1] = (byte)(rfcUnicodeHeader[1] + 48);
        rfcUnicodeHeader[2] = (byte)(rfcUnicodeHeader[2] + 48);
        rfcUnicodeHeader[3] = (byte)(rfcUnicodeHeader[3] + 48);
        try {
            act_cntl.real_charset = new String(rfcUnicodeHeader, 0, 4, "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RfcGetException(14, "could not convert Unicode header from binary to string");
        }
        act_cntl.ignoreConvErr = rfcUnicodeHeader[4];
        System.arraycopy(rfcUnicodeHeader, 7, subSym, 0, 4);
        sS = RfcUtilities.ICM15(subSym);
        act_cntl.unicodeHeader = rfcUnicodeHeader;
    }

    static void rfcSetRemoteInfo(RfcIoOpenCntl act_cntl, int rfcid, int rfcleng) throws RfcGetException {
        byte[] tmp = new byte[rfcleng];
        RfcValInfo valinfo = new RfcValInfo();
        SAPByteToCharConverter converter = null;
        char[] ptr = null;
        valinfo.RfcSetValInfoScalar(tmp, tmp.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, rfcleng);
        try {
            converter = SAPConverters.getSAPByteToCharConverter(act_cntl.charset);
        }
        catch (Exception ex) {
            throw new RfcGetException(14, "Could not instantiate converter: " + ex.getMessage());
        }
        switch (rfcid) {
            case 7: {
                break;
            }
            case 17: {
                try {
                    ptr = converter.convert(tmp, 0, valinfo.imp_leng - 1);
                    act_cntl.partner_type = new String(ptr);
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Error during conversion of OwnType");
                }
            }
            case 18: {
                try {
                    ptr = converter.convert(tmp, 0, valinfo.imp_leng - 1);
                    act_cntl.partner_rel = new String(ptr);
                    act_cntl.own_rel = "640 ";
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Error during conversion of OwnRel");
                }
            }
            case 19: {
                try {
                    ptr = converter.convert(tmp, 0, valinfo.imp_leng - 1);
                    act_cntl.kernel_rel = new String(ptr);
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Error during conversion of KernelRel");
                }
            }
            case 8: {
                try {
                    ptr = converter.convert(tmp, 0, valinfo.imp_leng - 1);
                    int lastNonWhitespace = ptr.length - 1;
                    while (lastNonWhitespace >= 0 && ptr[lastNonWhitespace] == ' ') {
                        --lastNonWhitespace;
                    }
                    String partnerDestination = new String(ptr, 0, lastNonWhitespace + 1);
                    if (ptr.length > 2 && ptr[lastNonWhitespace - 2] == '_') {
                        StringTokenizer partnerSystemInfos = new StringTokenizer(partnerDestination, "_");
                        if (partnerSystemInfos.countTokens() > 2) {
                            act_cntl.target = partnerSystemInfos.nextToken();
                            act_cntl.sysid = partnerSystemInfos.nextToken();
                            act_cntl.systnr = partnerSystemInfos.nextToken();
                            break;
                        }
                        act_cntl.target = partnerDestination;
                        break;
                    }
                    act_cntl.target = partnerDestination;
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Error during conversion of CDestination");
                }
            }
            case 6: {
                try {
                    int lastNonZeroByte = valinfo.imp_leng - 1;
                    while (lastNonZeroByte >= 0 && tmp[lastNonZeroByte] == 0) {
                        --lastNonZeroByte;
                    }
                    if (lastNonZeroByte < 0) break;
                    ptr = converter.convert(tmp, 0, "SAP4103".equals(converter.getCharacterEncoding()) ? lastNonZeroByte + 1 : lastNonZeroByte);
                    act_cntl.destination = new String(ptr);
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Error during conversion of Destination");
                }
            }
            case 273: {
                try {
                    ptr = converter.convert(tmp, 0, valinfo.imp_leng - 1);
                    act_cntl.userid = new String(ptr);
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Error during conversion of UserID");
                }
            }
            case 9: {
                try {
                    ptr = converter.convert(tmp, 0, valinfo.imp_leng - 1);
                    act_cntl.cuserid = new String(ptr);
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Error during conversion of CUserID");
                }
            }
            case 276: {
                try {
                    ptr = converter.convert(tmp, 0, valinfo.imp_leng - 1);
                    act_cntl.mandt = new String(ptr);
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Error during conversion of UserID");
                }
            }
            case 277: {
                try {
                    ptr = converter.convert(tmp, 0, valinfo.imp_leng - 1);
                    act_cntl.lang = new String(ptr);
                    break;
                }
                catch (Exception ex) {
                    throw new RfcGetException(14, "Error during conversion of UserID");
                }
            }
            case 305: {
                if (tmp.length <= 0) break;
                act_cntl.th_client_id = tmp;
            }
        }
    }

    static void ab_rfcerror(RfcIoOpenCntl act_cntl, RfcGetInfo getinfo, int type, int leng) throws RfcGetException {
        byte[] tmp = new byte[leng];
        RfcValInfo valinfo = new RfcValInfo();
        String content = null;
        SAPByteToCharConverter converter = null;
        char[] ptr = null;
        valinfo.RfcSetValInfoScalar(tmp, tmp.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        try {
            converter = SAPConverters.getSAPByteToCharConverter(act_cntl.charset);
            ptr = converter.convert(tmp, 0, valinfo.imp_leng - 1);
        }
        catch (Exception ex) {
            String msg = new String("ab_rfcerror converter trouble: " + ex.getMessage());
            throw new RfcGetException(14, msg);
        }
        content = new String(ptr);
        switch (type) {
            case 1045: {
                getinfo.msgId = new String(content);
                break;
            }
            case 1046: {
                getinfo.msgTy = new String(content);
                break;
            }
            case 1047: {
                getinfo.msgNo = new String(content);
                break;
            }
            case 1041: {
                getinfo.mSgv1 = new String(content);
                break;
            }
            case 1042: {
                getinfo.mSgv2 = new String(content);
                break;
            }
            case 1043: {
                getinfo.mSgv3 = new String(content);
                break;
            }
            case 1044: {
                getinfo.mSgv4 = new String(content);
                break;
            }
            case 1025: {
                throw new RfcGetException(8, content);
            }
            case 1026: {
                throw new RfcGetException(7, content);
            }
            case 1027: 
            case 1028: {
                getinfo.errId = content;
            }
        }
    }

    static void ab_rfcFunctionName(RfcIoOpenCntl act_cntl, RfcGetInfo info_p, int rfcid, int leng) throws RfcGetException {
        byte[] buffer = new byte[62];
        RfcGetImp.ab_rfcvalue(act_cntl, info_p.fbInfo, leng);
    }

    static void receiveSso2String(RfcIoOpenCntl act_cntl, int leng) throws RfcGetException {
        byte[] tmp = new byte[leng];
        RfcValInfo valinfo = new RfcValInfo();
        String content = null;
        SAPByteToCharConverter converter = null;
        char[] ptr = null;
        valinfo.RfcSetValInfoScalar(tmp, tmp.length);
        RfcGetImp.ab_rfcvalue(act_cntl, valinfo, leng);
        try {
            converter = SAPConverters.getSAPByteToCharConverter(act_cntl.charset);
            ptr = converter.convert(tmp, 0, valinfo.imp_leng - 1);
        }
        catch (Exception ex) {
            String msg = new String("ab_rfcerror converter trouble: " + ex.getMessage());
            throw new RfcGetException(14, msg);
        }
        act_cntl.mysapsso2 = content = new String(ptr);
    }

    private static String unescapeName(String parameterName) {
        if (parameterName.indexOf("_-") >= 0) {
            int end = parameterName.length();
            FastStringBuffer escapedNameBuffer = new FastStringBuffer(end);
            int i = 0;
            while (i < end) {
                if (parameterName.charAt(i) == '_') {
                    if (parameterName.charAt(++i) == '-') {
                        if (parameterName.charAt(++i) == '-') {
                            try {
                                escapedNameBuffer.append((char)Codecs.Hex.decode(parameterName.charAt(i + 1), parameterName.charAt(i + 2)));
                                i += 3;
                                continue;
                            }
                            catch (Exception e) {
                                throw new JCO.Exception(107, "JCO_ERROR_PROTOCOL", "Illegal escape sequence _--" + parameterName.charAt(i + 1) + parameterName.charAt(i + 2) + " in parameterName encountered");
                            }
                        }
                        escapedNameBuffer.append('/');
                        continue;
                    }
                    escapedNameBuffer.append('_');
                    continue;
                }
                escapedNameBuffer.append(parameterName.charAt(i));
                ++i;
            }
            return escapedNameBuffer.toString();
        }
        return parameterName;
    }
}

