/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.engine;

import com.sap.mw.rfc.api.IRfcComplexParameter;
import com.sap.mw.rfc.api.IRfcParameter;
import com.sap.mw.rfc.api.IRfcTable;
import com.sap.mw.rfc.data.ItStream;
import com.sap.mw.rfc.data.LZTable;
import com.sap.mw.rfc.engine.GUID;
import com.sap.mw.rfc.engine.RfcCallContext;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.RfcPut;
import com.sap.mw.rfc.engine.RfcUtilities;
import com.sap.mw.rfc.engine.Trc;
import com.sap.mw.rfc.exceptions.RfcIoException;

public abstract class RfcCall {
    private static long COMPRESSION_MINIMUM_TABLE_SIZE = 4096L;
    public static final int MinSizeTableLZ = 8000;

    public static void ab_rfcbxt(RfcIoOpenCntl act_cntl, IRfcParameter[] ddescr_imp, IRfcParameter[] ddescr_chn, IRfcTable[] tdescr) throws RfcIoException {
        RfcCallContext context = new RfcCallContext();
        RfcCall.RfcBackNew(act_cntl, context);
        RfcCall.rfc_extdata(context, ddescr_imp, ddescr_chn, tdescr);
        RfcCall.RfcBackEnd(context);
    }

    private static void RfcBackEnd(RfcCallContext ctx) throws RfcIoException {
        RfcPut.ab_rfcend(ctx.control);
    }

    private static void RfcBackNew(RfcIoOpenCntl act_cntl, RfcCallContext ctx) throws RfcIoException {
        ctx.control = act_cntl;
        RfcPut.ab_rfcput(act_cntl, 1280, null, 0, 0);
        if (act_cntl.rfc_uuid_set) {
            RfcPut.ab_rfcput(act_cntl, 1300, act_cntl.rfc_uuid, act_cntl.rfc_uuid.length, 0);
            if (act_cntl.trace) {
                Trc.ab_rfctrc("UUID:  RfcBackNew send the uuid to the partner:");
                Trc.ab_rfctrc(GUID.toString(act_cntl.rfc_uuid));
                Trc.ab_rfctrc("\n");
            }
        }
    }

    public static void rfc_table(RfcIoOpenCntl act_cntl, IRfcTable table) throws RfcIoException {
        byte[] tabinfo = new byte[8];
        boolean i = false;
        byte[] tmp = RfcUtilities.STCM15(table.getRowLength());
        System.arraycopy(tmp, 0, tabinfo, 0, 4);
        tmp = RfcUtilities.STCM15(table.getNumRows());
        System.arraycopy(tmp, 0, tabinfo, 4, 4);
        RfcPut.ab_rfcput(act_cntl, 770, tabinfo, tabinfo.length, 0);
        long compress = act_cntl.protocol & 3;
        if ((compress & 2L) != 0L) {
            int rc = RfcCall.send_table_lz(act_cntl, table);
            if (rc == 0) {
                return;
            }
            compress &= 0xFFFFFFFFFFFFFFFDL;
        }
        if ((compress & 1L) != 0L) {
            RfcCall.send_table_space(act_cntl, table);
            return;
        }
        RfcCall.send_table(act_cntl, table, 771);
    }

    private static int send_table_lz(RfcIoOpenCntl act_cntl, IRfcTable table) throws RfcIoException {
        int tsize = 0;
        int LZtsize = 0;
        LZTable lzTable = null;
        int rc = 0;
        tsize = table.getNumRows() * table.getRowLength();
        if ((long)tsize <= COMPRESSION_MINIMUM_TABLE_SIZE) {
            return 1;
        }
        lzTable = new LZTable("*LZ*");
        if (lzTable == null) {
            return 1;
        }
        rc = ItStream.compress(lzTable, table);
        if (rc != 0) {
            return 1;
        }
        LZtsize = lzTable.getRowLength() * 250;
        RfcCall.send_table(act_cntl, lzTable, 773);
        RfcPut.ab_rfcput(act_cntl, 774, null, 0, 0);
        return 0;
    }

    private static void send_table(RfcIoOpenCntl act_cntl, IRfcTable table, int rfcid) throws RfcIoException {
        int i = 0;
        i = 0;
        while (i < table.getNumRows()) {
            byte[] entry = table.getBytes(i);
            RfcPut.ab_rfcput(act_cntl, rfcid, entry, entry.length, 0);
            ++i;
        }
    }

    private static void send_table_space(RfcIoOpenCntl act_cntl, IRfcTable table) throws RfcIoException {
        int leng = table.getRowLength();
        int fill = table.getNumRows();
        int count = 0;
        int j = 0;
        int sendleng = 0;
        byte last_byte = 0;
        byte[] entry = null;
        count = 0;
        while (count < fill) {
            entry = table.getBytes(count);
            sendleng = 0;
            j = leng - 1;
            last_byte = entry[j];
            while (j >= 0) {
                if (entry[j] != last_byte) {
                    sendleng = j + 2;
                    break;
                }
                last_byte = entry[j];
                --j;
            }
            if (sendleng == 0) {
                sendleng = 1;
            }
            RfcPut.ab_rfcput(act_cntl, 772, entry, sendleng, 0);
            ++count;
        }
    }

    public static void RfcCallEnd(RfcIoOpenCntl act_cntl, RfcCallContext pCtx) throws RfcIoException {
        RfcPut.ab_rfcend(act_cntl);
    }

    private static void RfcCallNew(RfcCallContext pCallCtx, RfcIoOpenCntl act_cntl, String functionName) throws RfcIoException {
        String saprel = "640 ";
        boolean iorc = false;
        pCallCtx.direction = 1;
        pCallCtx.control = act_cntl;
        RfcPut.ab_rfcput(act_cntl, 1282, null, 0, 0);
        RfcPut.ab_rfcput_string(act_cntl, 11, saprel);
        RfcPut.ab_rfcput_string(act_cntl, 258, functionName);
        RfcPut.ab_rfcput(act_cntl, 823, null, 0, 0);
        if (act_cntl.rfc_uuid_set) {
            RfcPut.ab_rfcput(act_cntl, 1300, act_cntl.rfc_uuid, act_cntl.rfc_uuid.length, 0);
            if (act_cntl.trace) {
                Trc.ab_rfctrc("UUID:  RfcCallNew send the uuid to the partner:");
                Trc.ab_rfctrc(GUID.toString(act_cntl.rfc_uuid));
                Trc.ab_rfctrc("\n");
            }
        }
    }

    public static int ab_rfccxt2(RfcIoOpenCntl act_cntl, String function, IRfcParameter[] ddescr_exp, IRfcParameter[] ddescr_chn, IRfcTable[] tdescr, int rfcctx_mode) throws RfcIoException {
        boolean iorc = false;
        RfcCallContext context = new RfcCallContext();
        RfcCall.RfcCallNew(context, act_cntl, function);
        RfcCall.rfc_extdata(context, ddescr_exp, ddescr_chn, tdescr);
        RfcCall.RfcCallEnd(act_cntl, context);
        return 0;
    }

    private static int rfc_extdata(RfcCallContext pCtx, IRfcParameter[] ddescr_exp, IRfcParameter[] ddescr_chn, IRfcTable[] tdescr) throws RfcIoException {
        byte[] tmp;
        int i;
        if (ddescr_exp != null) {
            i = 0;
            while (i < ddescr_exp.length) {
                if (ddescr_exp[i].getType() == 42) {
                    ((IRfcComplexParameter)ddescr_exp[i]).sendXmlDataStream(pCtx.control);
                } else {
                    RfcPut.ab_rfcput_string(pCtx.control, 513, ddescr_exp[i].getName());
                    tmp = ddescr_exp[i].getBytes();
                    RfcPut.ab_rfcput(pCtx.control, 515, tmp, tmp.length, 0);
                }
                ++i;
            }
        }
        if (ddescr_chn != null) {
            i = 0;
            while (i < ddescr_chn.length) {
                if (ddescr_chn[i].getType() == 42) {
                    ((IRfcComplexParameter)ddescr_chn[i]).sendXmlDataStream(pCtx.control);
                } else {
                    RfcPut.ab_rfcput_string(pCtx.control, 513, ddescr_chn[i].getName());
                    tmp = ddescr_chn[i].getBytes();
                    RfcPut.ab_rfcput(pCtx.control, 515, tmp, tmp.length, 0);
                }
                ++i;
            }
        }
        if (tdescr != null) {
            i = 0;
            while (i < tdescr.length) {
                RfcPut.ab_rfcput_string(pCtx.control, 769, tdescr[i].getName());
                RfcCall.rfc_table(pCtx.control, tdescr[i]);
                ++i;
            }
        }
        return 0;
    }
}

