/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.rfc.api;

import com.sap.mw.jco.util.SAPConverters;
import com.sap.mw.rfc.api.IRfcFunction;
import com.sap.mw.rfc.api.IRfcParameter;
import com.sap.mw.rfc.api.IRfcTable;
import com.sap.mw.rfc.api.RfcOptions;
import com.sap.mw.rfc.api.RfcRegisterInfo;
import com.sap.mw.rfc.data.RfcChars;
import com.sap.mw.rfc.driver.CpicDriver;
import com.sap.mw.rfc.engine.RfcCall;
import com.sap.mw.rfc.engine.RfcGetName;
import com.sap.mw.rfc.engine.RfcIoControl;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.RfcPut;
import com.sap.mw.rfc.engine.RfcRcv;
import com.sap.mw.rfc.engine.TRfc;
import com.sap.mw.rfc.engine.Trc;
import com.sap.mw.rfc.exceptions.RfcException;
import com.sap.mw.rfc.exceptions.RfcGetException;
import com.sap.mw.rfc.exceptions.RfcIoException;

public abstract class RfcApi {
    public static byte[] RfcSncPartnerAclKey(long handle) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcSncPartnerAclKey");
        int rc = 0;
        byte[] result = new byte[2048];
        byte[] erg = null;
        if (act_cntl.trace) {
            Trc.TCpicNativeBegin("sncPartnerAclKey", act_cntl.hrfc, act_cntl.conv_id);
        }
        rc = CpicDriver.nativeSncPartnerAclKey(act_cntl.conv_id, result);
        if (act_cntl.trace) {
            Trc.TCpicNativeEnd("sncPartnerAclKey", act_cntl.hrfc, act_cntl.conv_id);
        }
        if (rc <= 0) {
            throw new RfcException(1, "Could not get Acl key", 104, "RFC_ERROR_SYSTEM_FAILURE", handle, true);
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcSncPartnerName", true);
        }
        erg = new byte[rc];
        System.arraycopy(result, 0, erg, 0, Math.min(erg.length, result.length));
        return erg;
    }

    public static String RfcSncPartnerName(long handle) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcSncPartnerName");
        boolean rc = false;
        String result = null;
        if (act_cntl.trace) {
            Trc.TCpicNativeBegin("sncPartnerName", act_cntl.hrfc, act_cntl.conv_id);
        }
        result = CpicDriver.nativeSncPartnerName(act_cntl.conv_id);
        if (act_cntl.trace) {
            Trc.TCpicNativeEnd("sncPartnerName", act_cntl.hrfc, act_cntl.conv_id);
        }
        if (result == null) {
            throw new RfcException(1, "Could not restore RfcSncPartnerName", 104, "RFC_ERROR_SYSTEM_FAILURE", handle, true);
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcSncPartnerName", true);
        }
        return result;
    }

    public static boolean RfcSncMode(long handle) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcSncMode");
        int rc = 0;
        if (act_cntl.trace) {
            Trc.TCpicNativeBegin("sncMode", act_cntl.hrfc, act_cntl.conv_id);
        }
        rc = CpicDriver.nativeSncMode(act_cntl.conv_id);
        if (act_cntl.trace) {
            Trc.TCpicNativeEnd("sncMode", act_cntl.hrfc, act_cntl.conv_id);
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcSncMode", true);
        }
        return rc == 1;
    }

    public static void RfcIsValidHandle(long handle) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcIsValidHandle");
        if (act_cntl.close_pending) {
            throw new RfcException(6, "Handle close pending", 109, "RFC_ERROR_CANCELLED", handle, true);
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcIsValidHandle", true);
        }
    }

    public static String RfcGetTicket(long handle) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcGetTicket");
        String result = null;
        if (act_cntl.mysapsso2 == null) {
            if (act_cntl.trace) {
                Trc.ab_rfctrc("No ticket for handle " + handle + "\n");
                Trc.TRfcApiEnd("RfcGetTicket", false);
            }
            throw new RfcException(1, "No ticket for handle", 104, "RFC_ERROR_SYSTEM_FAILURE", handle, false);
        }
        result = act_cntl.mysapsso2;
        act_cntl.mysapsso2 = null;
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcGetTicket", true);
        }
        return result;
    }

    public static byte[] RfcGetClientId(long handle) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcGetClientId");
        byte[] passport = null;
        if (act_cntl.th_client_id == null || act_cntl.th_client_id.length == 0) {
            if (act_cntl.trace) {
                Trc.ab_rfctrc("No passport received " + handle + "\n");
                Trc.ab_rfctrc("<* RfcGetClientId [" + handle + "] *>\n");
            }
        } else {
            passport = new byte[act_cntl.th_client_id.length];
            System.arraycopy(act_cntl.th_client_id, 0, passport, 0, passport.length);
            if (act_cntl.trace) {
                Trc.ab_rfctrc("Got passport with length " + act_cntl.th_client_id.length + '\n');
                Trc.TRfcApiEnd("RfcGetClientID", true);
            }
        }
        return passport;
    }

    public static void RfcSetClientId(long handle, byte[] passport) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcSetClientId");
        if (passport == null) {
            throw new RfcException(19, "Passport is null", 101, "RFC_ERROR_PROGRAM", handle, false);
        }
        if (passport.length > 0) {
            act_cntl.th_client_id = new byte[passport.length];
            System.arraycopy(passport, 0, act_cntl.th_client_id, 0, passport.length);
            if (act_cntl.trace) {
                Trc.ab_rfctrc("Set passport with length " + passport.length + '\n');
            }
        }
        act_cntl.identified = false;
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcSetClientID", true);
        }
    }

    public static void RfcRaiseErrorMessage(long handle, String exception, String errorMessage) throws RfcException {
        RfcIoOpenCntl act_cntl;
        block10: {
            act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcRaiseErrorMessage");
            if (errorMessage != null && errorMessage.trim().length() > 0 && !errorMessage.equalsIgnoreCase(exception)) {
                String[] messageParts = new String[4];
                int erLen = errorMessage.length();
                int i = 0;
                while (i < 4) {
                    if (erLen > 50) {
                        messageParts[i] = errorMessage.substring(0, 50);
                        errorMessage = errorMessage.substring(50);
                        erLen = errorMessage.length();
                    } else {
                        messageParts[i] = errorMessage;
                        errorMessage = "";
                        erLen = 0;
                    }
                    ++i;
                }
                try {
                    RfcPut.ab_RfcPutSyMsg(act_cntl, "SR", "E", "000", messageParts[0], messageParts[1], messageParts[2], messageParts[3]);
                }
                catch (RfcIoException ioEx) {
                    if (act_cntl.trace) {
                        Trc.TRfcApiEnd("RfcErrorRaise", false);
                    }
                    throw new RfcException(ioEx);
                }
            }
            try {
                RfcApi.RfcRaise(handle, exception);
            }
            catch (RfcException ex) {
                if (!act_cntl.trace) break block10;
                Trc.TRfcApiEnd("RfcErrorRaise", false);
                throw ex;
            }
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcErrorRaise", true);
        }
    }

    public static void RfcRaise(long handle, String text) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcRaise");
        if (act_cntl.trace) {
            Trc.TRfcRaise(handle, text);
        }
        if (act_cntl != null && act_cntl.type == 10) {
            act_cntl.ab_rfcmsgset(text + "raised by external server");
            if (act_cntl.trace) {
                Trc.TRfcApiEnd("RfcRaise", true);
            }
            return;
        }
        try {
            RfcPut.ab_rfcput(act_cntl, 1280, null, 0, 0);
            RfcPut.ab_rfcput_string(act_cntl, 1025, text);
            RfcPut.ab_rfcend(act_cntl);
        }
        catch (RfcIoException ioEx) {
            act_cntl.ab_rfcclose();
            if (act_cntl.trace) {
                Trc.TRfcApiEnd("RfcRaise", false);
            }
            throw new RfcException(ioEx);
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcRaise", true);
        }
    }

    public static void RfcConfirmTransId(long handle, String tid) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcConfirmTransId");
        IRfcParameter[] out = new IRfcParameter[1];
        RfcChars out_tid = new RfcChars(act_cntl, "TID", 24);
        out_tid.setChars(tid.toCharArray());
        out[0] = out_tid;
        try {
            RfcPut.ab_rfcput(act_cntl, 1299, null, 0, 0);
        }
        catch (RfcIoException ioEx) {
            if (act_cntl.trace) {
                Trc.TRfcApiEnd("RfcConfirmTransId", false);
            }
            throw new RfcException(ioEx);
        }
        try {
            RfcApi.RfcCallReceive(handle, "API_CLEAR_TID", out, null, null, null);
        }
        catch (RfcException ex) {
            if (act_cntl.trace) {
                Trc.TRfcApiEnd("RfcConfirmTransId", false);
            }
            throw ex;
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcConfirmTransId", true);
        }
    }

    public static String RfcCreateTransID(long handle) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcCreateTransID");
        IRfcParameter[] in = new IRfcParameter[1];
        RfcChars tid = new RfcChars(act_cntl, "TID", 24);
        in[0] = tid;
        try {
            RfcApi.RfcCallReceive(handle, "API_CREATE_TID", null, in, null, null);
        }
        catch (RfcException ex) {
            if (act_cntl.trace) {
                Trc.TRfcApiEnd("RfcCreateTransID", false);
            }
            throw ex;
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcCreateTransID", true);
        }
        return tid.toString();
    }

    public static void RfcQueueInsert(long handle, String function, IRfcParameter[] exporting, IRfcTable[] tables, String qname, int qcount, String tid) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcQueueInsert");
        try {
            TRfc.rfcQueueInsert(handle, function, exporting, tables, qname, qcount, tid);
        }
        catch (RfcException ex) {
            Trc.TRfcApiEnd("RfcQueueInsert", false);
            throw ex;
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcQueueInsert", true);
        }
    }

    public static void RfcSendData(long handle, IRfcParameter[] exporting, IRfcParameter[] changing, IRfcTable[] tables) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcSendData");
        if (act_cntl.trace) {
            Trc.TRfcSendData(handle, exporting, changing, tables);
        }
        try {
            RfcCall.ab_rfcbxt(act_cntl, exporting, changing, tables);
        }
        catch (RfcIoException ioEx) {
            if (act_cntl.trace) {
                Trc.TRfcApiEnd("RfcSendData", false);
            }
            throw new RfcException(ioEx);
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcSendData", true);
        }
    }

    public static void RfcGetData(long handle, IRfcParameter[] importing, IRfcParameter[] changing, IRfcTable[] tables) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcGetData");
        if (act_cntl.trace) {
            Trc.TRfcGetData(handle, importing, changing, tables);
        }
        try {
            RfcRcv.ab_rfcreceive(act_cntl, importing, changing, tables);
        }
        catch (RfcGetException getEx) {
            if (act_cntl.trace) {
                Trc.TRfcApiEnd("RfcGetData", false);
            }
            switch (getEx.getRc()) {
                case 14: {
                    throw new RfcException(21, getEx.getMessage(), getEx.getErrorGroup(), getEx.getKey(), handle, true);
                }
            }
            throw new RfcException(1, getEx.getMessage(), getEx.getErrorGroup(), getEx.getKey(), handle, true);
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcGetData", true);
        }
    }

    public static void RfcDispatch(long handle) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcDispatch");
        String funcName = null;
        IRfcFunction funcPtr = null;
        try {
            funcName = RfcGetName.ab_RfcDispatchLoc(act_cntl);
        }
        catch (RfcException ex) {
            if (ex.getRc() != 13) {
                throw ex;
            }
            funcName = ex.getMessage();
            funcPtr = RfcGetName.search_function("%%USER_GLOBAL_SERVER");
            if (funcPtr == null) {
                String msg = new String("Function: " + funcName + " is not available");
                RfcApi.RfcAbort(handle, msg);
                if (act_cntl.trace) {
                    Trc.TRfcApiEnd("RfcDispatch", false);
                }
                throw new RfcException(13, msg, 101, "RFC_ERROR_PROGRAM", handle, true);
            }
            act_cntl.ab_rfcreset();
            if (act_cntl.trace) {
                Trc.ab_rfctrc(">>>> [" + act_cntl.hrfc + " ] Dispatch call to:" + funcName + " via USER_GLOBAL_SERVER\n");
            }
            funcPtr.execute(handle);
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcDispatch", true);
        }
    }

    public static void RfcInstallFunction(IRfcFunction function) throws RfcException {
        RfcGetName.installFunction(function);
    }

    public static String RfcGetName(long handle) throws RfcException {
        String result = null;
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcGetName");
        result = RfcGetName.ab_RfcGetName(act_cntl);
        if (act_cntl.trace) {
            Trc.ab_rfctrc("\tGot function name: " + result + "\n");
            Trc.TRfcApiEnd("RfcGetName", true);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long RfcAccept(RfcRegisterInfo registerInfo) throws RfcException {
        long handle;
        block3: {
            handle = 0L;
            try {
                handle = RfcIoControl.ab_rfcaccept(12, registerInfo);
                Object var4_2 = null;
                if (!registerInfo.rfc_trace) break block3;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (!registerInfo.rfc_trace) throw throwable;
                Trc.ab_rfctrc(registerInfo.TrctoString(handle));
                throw throwable;
            }
            Trc.ab_rfctrc(registerInfo.TrctoString(handle));
        }
        if (handle != 0L) {
            RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(handle);
            act_cntl.ab_rfccount(0);
            act_cntl.own_type = new String("R");
            act_cntl.own_rel = "640 ";
            act_cntl.setRegisterInfo(registerInfo);
            if (!act_cntl.trace) return handle;
            Trc.ab_rfctrc("<* RfcAccept successful\n");
            Trc.ab_rfctrc("    handle = " + handle + "*>\n\n");
            return handle;
        }
        if (!registerInfo.rfc_trace) return handle;
        Trc.TRfcApiEnd("RfcAccept", false);
        return handle;
    }

    public static long RfcOpen(RfcOptions options) throws RfcException {
        RfcIoOpenCntl act_cntl = null;
        long handle = 0L;
        String name = new String("<unknown>");
        String key = new String("<unknown>");
        boolean iorc = false;
        if (0 != options.isTrace()) {
            Trc.TRfcOpen(options);
        }
        options.checkParameters();
        handle = RfcIoControl.ab_rfcopen(name, key, 0, options);
        if (handle == 0L) {
            return 0L;
        }
        act_cntl = RfcIoControl.ab_rfccntl(handle);
        if (act_cntl == null) {
            if (0 != options.isTrace()) {
                Trc.ab_rfctrc("Error> RfcOpen: ab_rfcopen failed. Handle" + handle + " not refernced");
            }
            throw new RfcException(18, "Handle " + handle + "not referenced", 106, "RFC_ERROR_RESOURCE", handle, true);
        }
        act_cntl.own_type = "E";
        act_cntl.own_rel = "640 ";
        act_cntl.kernel_rel = "640 ";
        act_cntl.allocationType = options.getAllocationType();
        try {
            act_cntl.ab_rfccon();
            act_cntl.ab_rfccount(0);
            if (options.isDebug_ext()) {
                String logonoptions = ",E=1";
                RfcPut.ab_rfcput_string(act_cntl, 306, logonoptions);
            }
        }
        catch (RfcIoException ioEx) {
            RfcApi.RfcClose(handle);
            if (0 != options.isTrace()) {
                Trc.ab_rfctrc("Error> RfcOpen failed. Could not send connect data.\n  ");
                Trc.ab_rfctrc(ioEx.getMessage());
                Trc.ab_rfctrc("\n\n");
            }
            throw new RfcException(ioEx);
        }
        try {
            if ('E' != options.getType() && 'R' != options.getType() && options.executeLogonCheck()) {
                RfcApi.RfcCall(handle, "RFCPING", null, null, null);
                RfcApi.RfcReceive(handle, null, null, null);
            }
        }
        catch (RfcException ex) {
            RfcApi.RfcClose(handle);
            if (0 != options.isTrace()) {
                Trc.ab_rfctrc("Error> RfcOpen failed. Could not ping the partner system.\n  ");
                Trc.ab_rfctrc(ex.getMessage());
                Trc.ab_rfctrc("\n\n");
            }
            if (ex.getErrorGroup() == 104) {
                throw new RfcException(ex.getRc(), ex.getMessage(), 103, "RFC_ERROR_LOGON_FAILURE", 0L, false);
            }
            throw ex;
        }
        if (0 != options.isTrace()) {
            Trc.ab_rfctrc("<* RfcOpen successful\n");
            Trc.ab_rfctrc("    handle = " + handle + "*>\n\n");
        }
        return handle;
    }

    public static void RfcClose(long handle) {
        RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(handle);
        boolean trc = false;
        if (act_cntl == null) {
            return;
        }
        if (act_cntl.trace) {
            Trc.ab_rfctrc("\n*> RfcClose ...\n");
            trc = true;
        }
        act_cntl.ab_rfcclose();
        act_cntl.ab_rfcfree();
        if (trc) {
            Trc.ab_rfctrc("<* RfcClose*>\n");
        }
    }

    public static void RfcAbort(long handle, String message) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcAbort");
        String errcode = new String("RFC_EXTERNAL_ABORT");
        if (message == null) {
            message = new String("External server aborted without message");
        }
        if (act_cntl == null) {
            throw new RfcException(18, "Handle " + handle + "not referenced", 106, "RFC_ERROR_RESOURCE", handle, true);
        }
        if (act_cntl.trace) {
            Trc.TRfcAbort(handle, message);
        }
        if (act_cntl.type == 10) {
            if (act_cntl.trace) {
                Trc.ab_rfctrc("<<<< RfcAbort\n\n");
            }
            return;
        }
        try {
            RfcPut.ab_rfcput_string(act_cntl, 1027, errcode);
            RfcPut.ab_rfcput_string(act_cntl, 1026, message);
            RfcPut.ab_rfcend(act_cntl);
            act_cntl.ab_rfcabort2();
        }
        catch (RfcIoException ioEx) {
            int rfc_rc = RfcException.rfcIOtoRC(ioEx.getIoRc());
            throw new RfcException(rfc_rc, ioEx.getMessage(), ioEx.getErrorGroup(), ioEx.getKey(), handle, true);
        }
        if (act_cntl.trace) {
            Trc.ab_rfctrc("<* RfcAbort *>\n\n");
        }
    }

    public static int RfcListen(long handle, int timeout) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(handle);
        int ioRc = 0;
        int rfc_rc = -1;
        if (act_cntl == null) {
            throw new RfcException(18, "Handle " + handle + " not referenced", 106, "RFC_ERROR_RESOURCE", handle, true);
        }
        try {
            ioRc = act_cntl.ab_rfclisten(timeout);
        }
        catch (RfcIoException ioEx) {
            throw new RfcException(ioEx);
        }
        if (RfcException.rfcIOtoRC(ioRc) == 0) {
            try {
                RfcGetName.ab_RfcDispatch(act_cntl);
                if (act_cntl.trace) {
                    Trc.TRfcApiEnd("RfcListen got system function", true);
                }
                return 7;
            }
            catch (RfcException ex) {
                if (ex.getRc() != 13) {
                    throw ex;
                }
                act_cntl.ab_rfcreset();
                return 0;
            }
        }
        return RfcException.rfcIOtoRC(ioRc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void RfcReceive(long handle, IRfcParameter[] importing, IRfcParameter[] changing, IRfcTable[] tables) throws RfcException {
        RfcIoOpenCntl act_cntl;
        block25: {
            int rfc_rc;
            block26: {
                act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcReceive");
                rfc_rc = 0;
                try {
                    try {
                        RfcRcv.ab_rfcreceive(act_cntl, importing, changing, tables);
                    }
                    catch (RfcGetException getEx) {
                        if (act_cntl.trace) {
                            Trc.TRfcApiEnd("RfcReceive", false);
                        }
                        switch (getEx.getRc()) {
                            case 0: {
                                break;
                            }
                            case 9: {
                                boolean rc = false;
                                rfc_rc = 4;
                                RfcGetName.ab_RfcDispatch(act_cntl);
                                if (rc) {
                                    act_cntl.ab_rfcreset();
                                    break;
                                }
                                RfcApi.RfcReceive(handle, importing, changing, tables);
                                break;
                            }
                            case 14: {
                                rfc_rc = 21;
                                break;
                            }
                            case 7: {
                                act_cntl.ab_rfcclose();
                                throw new RfcException(getEx, handle);
                            }
                            case 8: {
                                try {
                                    act_cntl.ab_rfcflush();
                                }
                                catch (RfcIoException ioEx) {
                                    act_cntl.ab_rfcclose();
                                    throw new RfcException(6, "Flush io buffer failed", ioEx.getErrorGroup(), ioEx.getKey(), handle, true);
                                }
                                rfc_rc = 2;
                                break;
                            }
                            case 13: {
                                rfc_rc = 19;
                                break;
                            }
                            case 12: {
                                rfc_rc = 11;
                                break;
                            }
                            case 11: {
                                act_cntl.ab_rfcclose();
                                rfc_rc = 6;
                                break;
                            }
                            default: {
                                act_cntl.ab_rfcclose();
                                rfc_rc = 3;
                            }
                        }
                        if (rfc_rc != 4) {
                            throw new RfcException(rfc_rc, getEx.getMessage(), getEx.getErrorGroup(), getEx.getKey(), handle, true);
                        }
                        Object var10_7 = null;
                        if (act_cntl.trace) {
                            Trc.TRfcReceive(handle, importing, changing, tables);
                        }
                        if (rfc_rc != 4) {
                            act_cntl.ab_rfccount(2);
                        }
                        break block25;
                    }
                    Object var10_6 = null;
                    if (!act_cntl.trace) break block26;
                }
                catch (Throwable throwable) {
                    Object var10_8 = null;
                    if (act_cntl.trace) {
                        Trc.TRfcReceive(handle, importing, changing, tables);
                    }
                    if (rfc_rc != 4) {
                        act_cntl.ab_rfccount(2);
                    }
                    throw throwable;
                }
                Trc.TRfcReceive(handle, importing, changing, tables);
            }
            if (rfc_rc != 4) {
                act_cntl.ab_rfccount(2);
            }
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcReceive", true);
        }
    }

    public static void RfcCallReceive(long handle, String function, IRfcParameter[] exporting, IRfcParameter[] importing, IRfcParameter[] changing, IRfcTable[] tables) throws RfcException {
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcCallReceive");
        try {
            RfcApi.RfcCall(handle, function, exporting, changing, tables);
            RfcApi.RfcReceive(handle, importing, changing, tables);
        }
        catch (RfcException ex) {
            if (act_cntl.trace) {
                Trc.TRfcApiEnd("RfcCallReceive", false);
            }
            throw ex;
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcCallReceive", true);
        }
    }

    public static void RfcCall(long handle, String function, IRfcParameter[] exporting, IRfcParameter[] changing, IRfcTable[] tables) throws RfcException {
        int rc = 0;
        RfcIoOpenCntl act_cntl = RfcApi.rfc_ApiEntry(handle, "RfcCall");
        act_cntl.ab_rfccount(1);
        if (act_cntl.trace) {
            Trc.TRfcCall(handle, function, exporting, changing, tables);
        }
        try {
            rc = RfcCall.ab_rfccxt2(act_cntl, function, exporting, changing, tables, 0);
        }
        catch (RfcIoException ioEx) {
            if (act_cntl.trace) {
                Trc.TRfcApiEnd("RfcCall", false);
            }
            throw new RfcException(ioEx);
        }
        if (act_cntl.trace) {
            Trc.TRfcApiEnd("RfcCall", true);
        }
    }

    private static RfcIoOpenCntl rfc_ApiEntry(long handle, String where) throws RfcException {
        RfcIoOpenCntl act_cntl = null;
        if (handle == 0L) {
            throw new RfcException(18, "Handle is invalid", 101, "RFC_ERROR_PROGRAM", handle, true);
        }
        act_cntl = RfcIoControl.ab_rfccntl(handle);
        if (act_cntl == null) {
            throw new RfcException(18, "Handle is not referenced", 104, "RFC_ERROR_SYSTEM_FAILURE", handle, true);
        }
        if (act_cntl.trace) {
            Trc.ab_rfctrc("\n>>> " + where + " [" + handle + "] >" + Trc.getTimeStamp() + "< ...\n\n");
        }
        if (!act_cntl.used) {
            throw new RfcException(18, "Handle already closed", 104, "RFC_ERROR_SYSTEM_FAILURE", handle, true);
        }
        return act_cntl;
    }

    public static String RfcgetVersion() {
        String Version = CpicDriver.CpicGetVersion();
        return Version;
    }

    private static void initializeDLL() {
        System.loadLibrary("CpicNative");
        CpicDriver.INIT();
        SAPConverters.nativeInitialize();
    }

    static {
        try {
            long rc = 0L;
            if (System.getProperty("jstartup.mode") != null) {
                CpicDriver.INIT();
            } else {
                RfcApi.initializeDLL();
            }
        }
        catch (UnsatisfiedLinkError ule) {
            if (System.getProperty("jstartup.mode") != null) {
                try {
                    RfcApi.initializeDLL();
                }
                catch (UnsatisfiedLinkError uXle) {
                    UnsatisfiedLinkError newule = new UnsatisfiedLinkError("Could not load native layer: JLaunch version is too old");
                    throw newule;
                }
            }
            throw new ExceptionInInitializerError("JCo with jrfc.jar can only be used within the SAP J2EE runtime. If you want to run JCo applications in other Java runtimes, make sure to have a reference to sapjco.jar.");
        }
    }
}

