/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco.util;

import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.RfcPut;
import com.sap.mw.rfc.exceptions.RfcIoException;
import java.io.OutputStream;

public class XRfcOutputStream
extends OutputStream {
    public static final int XML_BUFFER_CAPACITY = 16000;
    RfcIoOpenCntl act_cntl;
    byte[] buf = new byte[16000];
    int pos;
    int count = 0;

    public XRfcOutputStream(RfcIoOpenCntl act_cntl) throws RfcIoException {
        this.act_cntl = act_cntl;
        RfcPut.ab_rfcput(act_cntl, 15362, null, 0, 0);
        this.pos = 0;
    }

    public void ensureCapacity(int capacity) throws RfcIoException {
        if (16000 < capacity) {
            this.flushBuffer();
        }
    }

    public void flush() throws RfcIoException {
        this.flushBuffer();
    }

    public void close() throws RfcIoException {
        this.flushBuffer();
        RfcPut.ab_rfcput(this.act_cntl, 15362, null, 0, 0);
    }

    private final void flushBuffer() throws RfcIoException {
        if (this.pos > 0) {
            RfcPut.ab_rfcput(this.act_cntl, 15365, this.buf, this.pos, 0);
            this.count += this.pos;
            this.pos = 0;
        }
    }

    public void write(byte value) throws RfcIoException {
        this.ensureCapacity(this.pos + 1);
        this.buf[this.pos] = value;
        ++this.pos;
    }

    public void write(byte[] value) throws RfcIoException {
        if (value != null) {
            this.write(value, 0, value.length);
        }
    }

    public void write(byte[] value, int offset, int len) throws RfcIoException {
        if (value != null) {
            if (len > 16000) {
                this.flushBuffer();
                RfcPut.ab_rfcput(this.act_cntl, 15365, value, len, offset);
                this.count += len;
            } else {
                this.ensureCapacity(this.pos + len);
                System.arraycopy(value, offset, this.buf, this.pos, len);
                this.pos += len;
            }
        }
    }

    public void write(int b) throws RfcIoException {
        this.write((byte)b);
    }

    public int getNumBytes() {
        return this.count;
    }
}

