/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco;

import com.sap.mw.jco.ComplexParameter;
import com.sap.mw.jco.Converter;
import com.sap.mw.jco.FlatStructure;
import com.sap.mw.jco.IMiddleware;
import com.sap.mw.jco.JCO;
import com.sap.mw.jco.NestedStructure;
import com.sap.mw.jco.Parameter;
import com.sap.mw.jco.TableParameter;
import com.sap.mw.jco.util.Codepage;
import com.sap.mw.jco.util.ConnectionInfo;
import com.sap.mw.jco.util.FastStringBuffer;
import com.sap.mw.jco.util.Language;
import com.sap.mw.rfc.api.IRfcParameter;
import com.sap.mw.rfc.api.IRfcTable;
import com.sap.mw.rfc.api.RfcApi;
import com.sap.mw.rfc.api.RfcOptions;
import com.sap.mw.rfc.api.RfcRegisterInfo;
import com.sap.mw.rfc.data.ARFCSDATA;
import com.sap.mw.rfc.data.ARFCSSTATE;
import com.sap.mw.rfc.data.RfcChars;
import com.sap.mw.rfc.engine.AbSysInfo;
import com.sap.mw.rfc.engine.RfcGetName;
import com.sap.mw.rfc.engine.RfcIoControl;
import com.sap.mw.rfc.engine.RfcIoOpenCntl;
import com.sap.mw.rfc.engine.RfcPlaybackInfo;
import com.sap.mw.rfc.engine.Trc;
import com.sap.mw.rfc.exceptions.RfcException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public final class MiddlewareJRfc
extends IMiddleware {
    private static final String VERSION = "1.1.9";
    private static final String NAME = "JavaRfc";
    private static String nativeLayer_version;
    private static int wait_for_request_time;
    private static boolean monitorOn;
    private static final int IGNORE_PARAMETER = 112;
    private static int default_cpc_mode;
    private static int mw_max_startup_delay;
    private static final String[] rfc_return_codes;
    private static final String JCO_NATIVE_LAYER_VERSION = "jco.middleware.native_layer_version";
    private static final String JCO_SNC_LIB = "jco.middleware.snc_lib";
    private static final String JCO_WAIT_FOR_REQUEST_TIME = "jco.middleware.wait_for_request_time";
    private static final String JCO_MW_MAX_STARTUP_DELAY = "jco.middleware.max_startup_delay";
    private static final String JCO_MONITORING_MODE = "jco.middleware.monitoring";
    private static final String JRFC_TRACE = "jrfc.trace";
    private static final String[][] pinfo;
    private static int traceLevel;
    private static final long RFC_HANDLE_NULL = 0L;
    private static final String JCO_JRA_CONN = "jco.jra_conn";
    private static final String JCO_CLIENT = "jco.client.client";
    private static final String JCO_USER = "jco.client.user";
    private static final String JCO_ALIAS_USER = "jco.client.alias_user";
    private static final String JCO_PASSWD = "jco.client.passwd";
    private static final String JCO_LANG = "jco.client.lang";
    private static final String JCO_CODEPAGE = "jco.client.codepage";
    private static final String JCO_SYSNR = "jco.client.sysnr";
    private static final String JCO_ASHOST = "jco.client.ashost";
    private static final String JCO_MSHOST = "jco.client.mshost";
    private static final String JCO_GWHOST = "jco.client.gwhost";
    private static final String JCO_GWSERV = "jco.client.gwserv";
    private static final String JCO_R3NAME = "jco.client.r3name";
    private static final String JCO_GROUP = "jco.client.group";
    private static final String JCO_TPHOST = "jco.client.tphost";
    private static final String JCO_TPNAME = "jco.client.tpname";
    private static final String JCO_TYPE = "jco.client.type";
    private static final String JCO_TRACE = "jco.client.trace";
    private static final String JCO_ABAP_DEBUG = "jco.client.abap_debug";
    private static final String JCO_MYSAPSSO2 = "jco.client.mysapsso2";
    private static final String JCO_GETSSO2 = "jco.client.getsso2";
    private static final String JCO_X509CERT = "jco.client.x509cert";
    private static final String JCO_EXTIDDATA = "jco.client.extiddata";
    private static final String JCO_EXTIDTYPE = "jco.client.extidtype";
    private static final String JCO_LCHECK = "jco.client.lcheck";
    private static final String JCO_SNC_PARTNERNAME = "jco.client.snc_partnername";
    private static final String JCO_SNC_QOP = "jco.client.snc_qop";
    private static final String JCO_SNC_MYNAME = "jco.client.snc_myname";
    private static final String JCO_SNC_MODE = "jco.client.snc_mode";
    private static final String JCO_SNC_LIBRARY = "jco.client.snc_lib";
    private static final String JCO_DEST = "jco.client.dest";
    private static final String JCO_SAPLOGON_ID = "jco.client.saplogon_id";
    private static final String JCO_MSSERV = "jco.client.msserv";
    private static final String JCO_ICCE = "jco.client.icce";
    private static final String JCO_IDLE_TIMEOUT = "jco.client.idle_timeout";
    private static final String JCO_SAPROUTER = "jco.client.saprouter";
    private static final String[][] pinfoClient;
    private static final String JCO_SERVER_GWHOST = "jco.server.gwhost";
    private static final String JCO_SERVER_GWSERV = "jco.server.gwserv";
    private static final String JCO_PROGID = "jco.server.progid";
    private static final String JCO_SERVER_TRACE = "jco.server.trace";
    private static final String JCO_SERVER_SNC_MYNAME = "jco.server.snc_myname";
    private static final String JCO_SERVER_SNC_QOP = "jco.server.snc_qop";
    private static final String JCO_SERVER_SNC_LIBRARY = "jco.server.snc_lib";
    private static final String JCO_MAX_STARTUP_DELAY = "jco.server.max_startup_delay";
    private static final String JCO_SERVER_SAPROUTER = "jco.server.saprouter";
    private static final String[][] pinfoServer;

    public String[][] getPropertyInfo() {
        return pinfo;
    }

    public void setTraceLevel(int trace_level) {
        String string = VERSION;
        synchronized (string) {
            traceLevel = trace_level;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setProperty(String key, String value) {
        this.trace(1, "MiddlewareJRfc.setProperty(" + key + ", " + value + ") ");
        if (key != null) {
            if (key.equals("jco.middleware.wait_for_request_time")) {
                if (value != null) {
                    try {
                        MiddlewareJRfc.wait_for_request_time = Integer.parseInt(value);
                        if (MiddlewareJRfc.wait_for_request_time >= 0) ** GOTO lbl43
                        MiddlewareJRfc.wait_for_request_time = 2;
                    }
                    catch (Exception ex) {
                        throw new JCO.Exception(122, "JCO_ERROR_CONVERSION", "Value of property jco.middleware.wait_for_request_time not an integer.");
                    }
                } else {
                    MiddlewareJRfc.wait_for_request_time = 2;
                }
            } else if (key.equals("jco.middleware.max_startup_delay")) {
                if (value != null) {
                    try {
                        MiddlewareJRfc.mw_max_startup_delay = Integer.parseInt(value);
                        if (MiddlewareJRfc.mw_max_startup_delay >= 0) ** GOTO lbl43
                        MiddlewareJRfc.mw_max_startup_delay = 3600;
                    }
                    catch (Exception ex) {
                        throw new JCO.Exception(122, "JCO_ERROR_CONVERSION", "Value of property jco.middleware.max_startup_delay not an integer.");
                    }
                } else {
                    MiddlewareJRfc.mw_max_startup_delay = 3600;
                }
            } else {
                if (key.equals("jco.middleware.monitoring")) {
                    try {
                        iv = Integer.parseInt(value);
                        if (iv != 0 && iv != 1) {
                            throw new JCO.Exception(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Value of property jco.middleware.monitoring must be 1 or 0.");
                        }
                        MiddlewareJRfc.monitorOn = iv == 1;
                        value = String.valueOf(iv);
                    }
                    catch (Exception ex) {
                        throw new JCO.Exception(122, "JCO_ERROR_CONVERSION", "Value of property jco.middleware.monitoring not an integer.");
                    }
                }
                if (key.equals("jrfc.trace")) {
                    try {
                        jrfcTrace = Integer.parseInt(value);
                        RfcIoOpenCntl.setGeneralTrace(jrfcTrace > 0);
                        value = String.valueOf(jrfcTrace);
                    }
                    catch (Exception ex) {
                        throw new JCO.Exception(122, "JCO_ERROR_CONVERSION", "Value of property jrfc.trace not an integer.");
                    }
                }
            }
        }
lbl43:
        // 12 sources

        super.setProperty(key, value);
    }

    public IMiddleware.IClient getClientInterface() {
        return new Client();
    }

    public IMiddleware.IServer getServerInterface() {
        return new Server();
    }

    public static ConnectionInfo[] getConnectionsInfo() {
        return RfcIoControl.getConnectionsInfo();
    }

    protected void trace(int level, String message) {
        JCO.fireTrace(level, message);
    }

    protected JCO.Exception generateJCoException(RfcException re) {
        if (traceLevel > 4) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            re.printStackTrace(pw);
            pw.flush();
            pw.close();
            this.trace(5, sw.toString());
        }
        return new JCO.Exception(re.getErrorGroup(), re.getKey(), re.getMessage());
    }

    protected String extractRouterString(String host) {
        if (host == null) {
            return null;
        }
        String routerString = null;
        int where = host.lastIndexOf("/H/");
        if (where > 0) {
            routerString = host.substring(0, where);
        }
        return routerString;
    }

    protected String getPlainHost(String host, int hostNameOffset) {
        if (host == null) {
            return null;
        }
        String realHost = null;
        int where = host.indexOf("/S/", hostNameOffset);
        realHost = where > 0 ? host.substring(hostNameOffset, where) : host.substring(hostNameOffset);
        return realHost;
    }

    protected void abort(JCO.Connection conn, String message) throws RfcException {
        if (conn.rfc_handle != 0L) {
            try {
                this.trace(3, "Abort before RfcAbort(" + conn.rfc_handle + ", " + message + ')');
                RfcApi.RfcAbort(conn.rfc_handle, message);
                this.trace(3, "Abort after RfcAbort(" + conn.rfc_handle + ", " + message + ')');
                Object var4_3 = null;
                conn.rfc_handle = 0L;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                conn.rfc_handle = 0L;
                throw throwable;
            }
        }
    }

    protected void disconnect(JCO.Connection conn) {
        long tstart = 0L;
        long ttotal = 0L;
        long tmiddleware = 0L;
        ttotal = System.currentTimeMillis();
        if (conn.rfc_handle != 0L) {
            this.trace(3, "Disconnect before RfcClose(" + conn.rfc_handle + ')');
            tstart = System.currentTimeMillis();
            RfcApi.RfcClose(conn.rfc_handle);
            this.trace(3, "Disconnect after RfcClose(" + conn.rfc_handle + ')');
            tmiddleware = System.currentTimeMillis() - tstart;
            conn.rfc_handle = 0L;
        }
        ttotal = System.currentTimeMillis() - ttotal;
        if (conn.throughput != null) {
            JCO.Throughput throughput = conn.throughput;
            synchronized (throughput) {
                conn.throughput.time_middleware += tmiddleware;
                conn.throughput.time_total += ttotal;
            }
        }
    }

    protected boolean isAlive(JCO.Connection conn) {
        boolean ret = false;
        if (conn.rfc_handle != 0L) {
            try {
                RfcApi.RfcIsValidHandle(conn.rfc_handle);
                ret = true;
            }
            catch (RfcException re) {
                int exrc = re.getRc();
                if (exrc == 6) {
                    RfcApi.RfcClose(conn.rfc_handle);
                    conn.rfc_handle = 0L;
                }
                ret = false;
            }
        }
        return ret;
    }

    protected void getAttributes(JCO.Connection conn, Connection mconn) {
        JCO.Attributes attributes;
        RfcIoOpenCntl handleAttributes;
        block11: {
            if (conn.rfc_handle == 0L) {
                throw new JCO.Exception(121, "JCO_ERROR_NULL_HANDLE", "Invalid rfc_handle = NULL encountered");
            }
            handleAttributes = RfcIoControl.ab_rfccntl(conn.rfc_handle);
            if (handleAttributes == null) {
                throw new JCO.Exception(108, "JCO_ERROR_INTERNAL", "Could not get attributes for rfc_handle = " + conn.rfc_handle);
            }
            attributes = new JCO.Attributes();
            if (handleAttributes.mysapsso2 != null) {
                try {
                    attributes.sso_ticket = RfcApi.RfcGetTicket(conn.rfc_handle);
                }
                catch (RfcException re) {
                    if (re.getRc() == 1) break block11;
                    throw this.generateJCoException(re);
                }
            }
        }
        attributes.dest = handleAttributes.destination;
        attributes.own_host = AbSysInfo.host;
        attributes.partner_host = handleAttributes.target;
        attributes.systnr = handleAttributes.systnr;
        attributes.sysid = handleAttributes.sysid;
        attributes.client = handleAttributes.mandt;
        attributes.user = handleAttributes.userid;
        if (attributes.user == null) {
            attributes.user = "";
        }
        attributes.language = handleAttributes.lang;
        if (attributes.language == null) {
            attributes.language = " ";
        }
        attributes.ISO_language = Language.getISOLanguage(attributes.language);
        if (attributes.ISO_language == null) {
            attributes.ISO_language = attributes.language + ' ';
        }
        attributes.own_codepage = handleAttributes.pcs == 2 ? handleAttributes.codepage : handleAttributes.communication_cp;
        attributes.partner_codepage = handleAttributes.communication_cp;
        attributes.own_rel = handleAttributes.own_rel;
        attributes.partner_rel = handleAttributes.partner_rel;
        attributes.kernel_rel = handleAttributes.kernel_rel;
        attributes.partner_type = (char)(handleAttributes.partner_type == null ? 51 : (int)handleAttributes.partner_type.charAt(0));
        attributes.trace = (char)(handleAttributes.trace ? 88 : 32);
        attributes.rfc_role = handleAttributes.rfc_role;
        attributes.own_type = (char)(handleAttributes.own_type == null ? 69 : (int)handleAttributes.own_type.charAt(0));
        try {
            attributes.CPIC_convid = new String(handleAttributes.conv_id, "ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        Codepage.CPMap receiveCodepage = this.getCodepage(attributes.partner_codepage, attributes.ISO_language);
        Codepage.CPMap sendCodepage = Codepage.getCPMap(attributes.own_codepage);
        attributes.own_charset = sendCodepage.encoding;
        attributes.own_encoding = sendCodepage.mimeCharset;
        attributes.own_bytes_per_char = (byte)(sendCodepage.is2byte ? 2 : 1);
        attributes.partner_charset = receiveCodepage.encoding;
        attributes.partner_encoding = receiveCodepage.mimeCharset;
        attributes.partner_bytes_per_char = (byte)(receiveCodepage.is2byte ? 2 : 1);
        if (traceLevel > 0 && conn instanceof JCO.Client && conn.attributes != null && !conn.attributes.partner_codepage.equals(attributes.partner_codepage)) {
            this.trace(1, new FastStringBuffer(120).append("WARNING: the received codepage does not match to the one cached in the attributes:").append(" jco.client.lang=").append(conn.getProperty(JCO_LANG)).append(" cached partner codepage ").append(conn.attributes.partner_codepage).append(" received partner codepage ").append(attributes.partner_codepage).append(" [if the received codepage does not fit to the language it is necessary to update the SAP backend]").toString());
        }
        conn.attributes = attributes;
        mconn.converter = new Converter(receiveCodepage.codepage, sendCodepage.codepage, 1 == handleAttributes.intformat);
    }

    protected Codepage.CPMap getCodepage(String codepage, String isoLanguage) {
        this.trace(3, "getCodepage trying codepage " + codepage);
        Codepage.CPMap cpmap = Codepage.getCPMap(codepage);
        if (cpmap == null) {
            this.trace(3, "getCodepage trying logon language " + isoLanguage);
            cpmap = Codepage.getCPMap(isoLanguage);
        }
        if (cpmap == null) {
            this.trace(3, "getCodepage using default codepage 4102");
            cpmap = Codepage.getCPMap("4102");
        }
        this.trace(3, "getCodepage returns partner codepage " + cpmap.codepage);
        return cpmap;
    }

    protected long countBytes(IRfcParameter[] paramList, IRfcParameter[] changings, IRfcTable[] tables) {
        int i;
        long numBytes = 0L;
        if (paramList != null) {
            i = 0;
            while (i < paramList.length) {
                numBytes += (long)paramList[i].getNumBytes();
                ++i;
            }
        }
        if (changings != null) {
            i = 0;
            while (i < changings.length) {
                numBytes += (long)changings[i].getNumBytes();
                ++i;
            }
        }
        if (tables != null) {
            i = 0;
            while (i < tables.length) {
                numBytes += (long)(tables[i].getNumRows() * tables[i].getRowLength());
                ++i;
            }
        }
        return numBytes;
    }

    static {
        block10: {
            block9: {
                nativeLayer_version = "not available";
                wait_for_request_time = 2;
                monitorOn = false;
                default_cpc_mode = 0;
                mw_max_startup_delay = 3600;
                rfc_return_codes = new String[]{"RFC_OK", "RFC_FAILURE", "RFC_EXCEPTION", "RFC_SYS_EXCEPTION", "RFC_CALL", "RFC_INTERNAL_COM", "RFC_CLOSED", "RFC_RETRY", "RFC_NO_TID", "RFC_EXECUTED", "RFC_SYNCHRONIZE", "RFC_MEMORY_INSUFFICIENT", "RFC_VERSION_MISMATCH", "RFC_NOT_FOUND", "RFC_CALL_NOT_SUPPORTED", "RFC_NOT_OWNER", "RFC_NOT_INITIALIZED", "RFC_SYSTEM_CALLED", "RFC_INVALID_HANDLE", "RFC_INVALID_PARAMETER", "RFC_CANCELLED", "RFC_CONVERSION", "RFC_INVALID_PROTOCOL", "RFC_IDLE_TIMEOUT", "RFC_UNKNOWN_EXCEPTION"};
                pinfo = new String[][]{{"jco.middleware.name", "Name of the middleware implementation"}, {"jco.middleware.version", "Version of the middleware implementation"}, {JCO_NATIVE_LAYER_VERSION, "Version of the native layer"}, {JCO_SNC_LIB, "Path to SNC library"}, {JCO_WAIT_FOR_REQUEST_TIME, "Time in seconds to wait incessantly for incoming requests"}, {JCO_MW_MAX_STARTUP_DELAY, "Maximum server startup delay time in seconds"}, {JCO_MONITORING_MODE, "Turns on reporting performance data for each call"}};
                traceLevel = 0;
                pinfoClient = new String[][]{{JCO_CLIENT, "Logon client"}, {JCO_USER, "Logon user"}, {JCO_ALIAS_USER, "Alias user name"}, {JCO_PASSWD, "Logon password"}, {JCO_LANG, "Logon language"}, {JCO_CODEPAGE, "Initial codepage in SAP notation"}, {JCO_SYSNR, "R/3 system number"}, {JCO_ASHOST, "R/3 application server"}, {JCO_MSHOST, "R/3 message server"}, {JCO_GWHOST, "Gateway host"}, {JCO_GWSERV, "Gateway service"}, {JCO_R3NAME, "R/3 name"}, {JCO_GROUP, "Group of application servers"}, {JCO_MSSERV, "R/3 port number of message server"}, {JCO_TPNAME, "Program ID of external server program"}, {JCO_TPHOST, "Host of external server program"}, {JCO_TYPE, "Type of remote host 3 = R/3, E = External"}, {JCO_TRACE, "Enable/disable RFC trace (0 or 1)"}, {JCO_ABAP_DEBUG, "Enable ABAP debugging 0 or 1"}, {JCO_GETSSO2, "Get/Don't get a SSO ticket after logon (1 or 0)"}, {JCO_MYSAPSSO2, "Use the specified SAP Cookie Version 2 as logon ticket"}, {JCO_LCHECK, "Enable/Disable logon check at open time (1 or 0)"}, {JCO_SNC_MODE, "SNC mode, 0 or 1"}, {JCO_SNC_PARTNERNAME, "SNC partner, e.g. p:CN=B20, O=SAP-AG, C=DE"}, {JCO_SNC_QOP, "SNC level of security, 1 to 9"}, {JCO_SNC_MYNAME, "SNC name. Overrides default SNC partner"}, {JCO_SNC_LIBRARY, "Path to library"}, {JCO_DEST, "R/2 destination"}, {JCO_SAPLOGON_ID, "String defined for SAPLOGON on 32-bit Windows"}, {JCO_EXTIDDATA, "Data for external authentication (PAS)"}, {JCO_EXTIDTYPE, "Type of external authentication (PAS)"}, {JCO_X509CERT, "Use the specified X509-certificate as logon ticket"}, {JCO_ICCE, "Flags for codepage converters"}, {JCO_IDLE_TIMEOUT, "Idle timeout for the connection"}, {JCO_SAPROUTER, "SAPRouter string"}};
                pinfoServer = new String[][]{{JCO_SERVER_GWHOST, "Gateway host"}, {JCO_SERVER_GWSERV, "Gateway service"}, {JCO_PROGID, "Program ID of the server"}, {JCO_SERVER_TRACE, "Enable/disable RFC trace (1 or 0)"}, {JCO_SERVER_SNC_MYNAME, "SNC name"}, {JCO_SERVER_SNC_QOP, "SNC level of security, 1 to 9"}, {JCO_SERVER_SNC_LIBRARY, "Path to the SNC library"}, {JCO_MAX_STARTUP_DELAY, "Maximum server startup delay time in seconds"}, {JCO_SERVER_SAPROUTER, "SAPRouter string"}};
                try {
                    String level = System.getProperty("jco.trace_level");
                    if (level != null) {
                        try {
                            traceLevel = Integer.parseInt(level);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    nativeLayer_version = RfcApi.RfcgetVersion();
                    if (traceLevel > 0) {
                        new MiddlewareJRfc().trace(0, "Java RFC native layer version: " + nativeLayer_version);
                    }
                }
                catch (Throwable t) {
                    if (traceLevel <= 0) break block9;
                    new MiddlewareJRfc().trace(0, "Problem getting version: " + t);
                }
            }
            String jrfc_trace = System.getProperty(JRFC_TRACE);
            try {
                if (jrfc_trace != null && jrfc_trace.length() != 0) {
                    int jrfcTrace = Integer.parseInt(jrfc_trace);
                    RfcIoOpenCntl.setGeneralTrace(jrfcTrace > 0);
                }
            }
            catch (Throwable t) {
                if (traceLevel <= 0) break block10;
                new MiddlewareJRfc().trace(0, "Could not turn on general jrfc trace: " + t);
            }
        }
        ((Hashtable)IMiddleware.properties).put("jco.middleware.name", NAME);
        ((Hashtable)IMiddleware.properties).put("jco.middleware.version", VERSION);
        ((Hashtable)IMiddleware.properties).put(JCO_NATIVE_LAYER_VERSION, nativeLayer_version);
        ((Hashtable)IMiddleware.properties).put(JCO_SNC_LIB, "SECUDE.dll");
        ((Hashtable)IMiddleware.properties).put(JCO_WAIT_FOR_REQUEST_TIME, "2");
        ((Hashtable)IMiddleware.properties).put(JCO_MW_MAX_STARTUP_DELAY, "3600");
    }

    public class Server
    extends Connection
    implements IMiddleware.IServer {
        RfcRegisterInfo registerParams = new RfcRegisterInfo();

        Server() {
        }

        public String[][] getPropertyInfo() {
            return pinfoServer;
        }

        public void initialize(JCO.Server server, Properties params) {
            this.registerParams.tpname = MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_PROGID, params);
            this.registerParams.gwhost = MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_SERVER_GWHOST, params);
            this.registerParams.gwserv = MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_SERVER_GWSERV, params);
            this.registerParams.saprouter = MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_SERVER_SAPROUTER, params);
            this.registerParams.rfc_trace = MiddlewareJRfc.this.toBoolean(MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_SERVER_TRACE, params));
            this.registerParams.snc_myname = MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_SERVER_SNC_MYNAME, params);
            if (this.registerParams.saprouter == null) {
                this.registerParams.saprouter = MiddlewareJRfc.this.extractRouterString(this.registerParams.gwhost);
                if (this.registerParams.saprouter != null) {
                    this.registerParams.gwhost = MiddlewareJRfc.this.getPlainHost(this.registerParams.gwhost, this.registerParams.saprouter.length() + 3);
                }
            }
            if (this.registerParams.snc_myname != null) {
                this.registerParams.snc_mode = true;
                String qop = MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_SERVER_SNC_QOP, params);
                try {
                    this.registerParams.snc_qop = Byte.parseByte(qop);
                }
                catch (Exception e) {
                    this.registerParams.snc_qop = (byte)8;
                }
                this.registerParams.snc_lib = MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_SERVER_SNC_LIBRARY, params);
                if (this.registerParams.snc_lib == null) {
                    this.registerParams.snc_lib = MiddlewareJRfc.this.getProperty(MiddlewareJRfc.JCO_SNC_LIB);
                }
            }
            this.registerParams.allocationType = (byte)(MiddlewareJRfc.this.toBoolean(MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_JRA_CONN, params)) ? 1 : 3);
            server.conn_params = this.registerParams.toString();
        }

        public void listen(JCO.Server server, String params) {
            server.state = (byte)(server.state & 0xFFFFFFF7);
            server.rfc_handle = 0L;
            if (traceLevel > 2) {
                MiddlewareJRfc.this.trace(3, "Listen before RfcAccept(" + params + ')');
            }
            long handle = 0L;
            try {
                handle = RfcApi.RfcAccept(this.registerParams);
            }
            catch (RfcException re) {
                if (traceLevel > 0) {
                    MiddlewareJRfc.this.trace(1, "Listen in RfcAccept throws " + re.toString());
                }
                throw new JCO.Exception(129, "JCO_ERROR_SERVER_STARTUP", "Could not start server: " + re.getMessage());
            }
            catch (Throwable t) {
                throw new JCO.Exception(129, "JCO_ERROR_SERVER_STARTUP", "Could not start server: " + t.getMessage());
            }
            if (traceLevel > 2) {
                MiddlewareJRfc.this.trace(3, "Listen after RfcAccept(" + params + ")=" + handle);
            }
            server.rfc_handle = handle;
            server.setState((byte)(server.state | 8));
            int rc = 0;
            String functionModule = null;
            do {
                functionModule = null;
                try {
                    try {
                        if (traceLevel > 9) {
                            MiddlewareJRfc.this.trace(10, "Listen before RfcListen(" + handle + ", " + wait_for_request_time + ')');
                        }
                        rc = RfcApi.RfcListen(server.rfc_handle, wait_for_request_time);
                        if (traceLevel > 9) {
                            MiddlewareJRfc.this.trace(10, "Listen after RfcListen(" + handle + ", " + wait_for_request_time + ")=" + rfc_return_codes[rc]);
                        }
                    }
                    catch (RfcException re) {
                        if (traceLevel > 0) {
                            MiddlewareJRfc.this.trace(1, "Listen: RfcListen throws " + re.toString());
                        }
                        throw new JCO.Exception(129, "JCO_ERROR_SERVER_STARTUP", "Could not start server: " + re.getMessage());
                    }
                    catch (Throwable t) {
                        throw new JCO.Exception(129, "JCO_ERROR_SERVER_STARTUP", "Could not start server: " + t.getMessage());
                    }
                    if (traceLevel > 9) {
                        MiddlewareJRfc.this.trace(10, "Listen before RfcListen(" + handle + ", " + wait_for_request_time + ')');
                    }
                    while (rc == 7 && (server.state & 8) != 0) {
                        rc = RfcApi.RfcListen(server.rfc_handle, wait_for_request_time);
                    }
                    if (traceLevel > 9) {
                        MiddlewareJRfc.this.trace(10, "Listen after RfcListen(" + handle + ", " + wait_for_request_time + ")=" + rfc_return_codes[rc]);
                    }
                    if (rc != 0 || (server.state & 8) == 0) break;
                    functionModule = RfcApi.RfcGetName(server.rfc_handle);
                    if (functionModule == null) {
                        MiddlewareJRfc.this.trace(1, "Listen after RfcListen(" + handle + ", " + wait_for_request_time + ")=" + rfc_return_codes[rc]);
                        MiddlewareJRfc.this.trace(1, "Listen received null function module for " + handle);
                        continue;
                    }
                    if (functionModule.equals("ARFC_DEST_SHIP")) {
                        this.handletRfcRequest(server);
                        continue;
                    }
                    if (functionModule.equals("ARFC_DEST_CONFIRM") || functionModule.equals("API_CLEAR_TID")) {
                        this.handletRfcConfirm(server);
                        continue;
                    }
                    if (traceLevel > 2) {
                        MiddlewareJRfc.this.trace(3, "Listen calling dispatchRequest(" + handle + ", " + functionModule + ')');
                    }
                    this.dispatchRequest(server, functionModule);
                    if (traceLevel > 2) {
                        MiddlewareJRfc.this.trace(3, "Listen after dispatchRequest(" + handle + ", " + functionModule + ')');
                    }
                    if (server.rfc_handle != 0L) continue;
                    break;
                }
                catch (RfcException re) {
                    int exrc = re.getRc();
                    if (exrc == 6) {
                        RfcApi.RfcClose(server.rfc_handle);
                        server.rfc_handle = 0L;
                        break;
                    }
                    if (exrc == 0 || exrc == 7) continue;
                    MiddlewareJRfc.this.trace(1, "Listen in exception: return code " + rfc_return_codes[exrc]);
                    throw MiddlewareJRfc.this.generateJCoException(re);
                }
            } while (rc == 0);
        }

        public void disconnect(JCO.Server server) {
            MiddlewareJRfc.this.disconnect(server);
        }

        public void abort(JCO.Server server, String message) {
            try {
                MiddlewareJRfc.this.abort(server, message);
            }
            catch (RfcException re) {
                JCO.fireServerExceptionOccurred(server, re);
            }
        }

        public boolean isAlive(JCO.Server server) {
            return MiddlewareJRfc.this.isAlive(server);
        }

        public void getAttributes(JCO.Server server) {
            MiddlewareJRfc.this.getAttributes(server, this);
        }

        protected void handletRfcRequest(JCO.Server server) throws RfcException {
            RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(server.rfc_handle);
            int dwFlag = 0;
            IRfcParameter[] parameters = new IRfcParameter[1];
            IRfcTable[] tables = new TableParameter[2];
            ARFCSDATA data = new ARFCSDATA(act_cntl, "DATA");
            ARFCSSTATE state = new ARFCSSTATE(act_cntl, "STATE");
            RfcChars comment = new RfcChars(act_cntl, "COMMENT", 72);
            tables[0] = data;
            tables[1] = state;
            parameters[0] = comment;
            RfcApi.RfcGetData(server.rfc_handle, parameters, null, tables);
            act_cntl.ab_rfccount(1);
            dwFlag = state.isActive() ? 3 : 0;
            this.playbackTRfc(act_cntl, data, dwFlag, state, comment.toString(), server);
            RfcApi.RfcSendData(server.rfc_handle, parameters, null, tables);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void playbackTRfc(RfcIoOpenCntl act_cntl, ARFCSDATA data, int dwFlag, ARFCSSTATE state, String comment, JCO.Server server) throws RfcException {
            String arfcDest = null;
            String arfcUser = null;
            String arfcTid = null;
            boolean rfc_rc = false;
            if ((dwFlag & 1) != 0) {
                if (!state.isActive()) throw new RfcException(6, "With/Without state", 108, "RFC_ERROR_INTERNAL", act_cntl.hrfc, true);
                JCO.Table table = state.getTable();
                table.firstRow();
                arfcDest = table.getString(1);
                arfcUser = table.getString(8);
                arfcTid = table.getString(0);
            } else if (act_cntl != null) {
                arfcUser = act_cntl.userid;
                if ((dwFlag & 2) != 0) throw new RfcException(6, "No State+NoTID+CheckTID", 108, "RFC_ERROR_INTERNAL", act_cntl.hrfc, true);
                arfcTid = new String("000000000000000000000000");
            } else {
                arfcUser = "";
                arfcDest = "";
                if ((dwFlag & 2) != 0) throw new RfcException(6, "NoHandle+No State+NoTID+CheckTID", 108, "RFC_ERROR_INTERNAL", act_cntl.hrfc, true);
                arfcTid = new String("000000000000000000000000");
            }
            if (!data.isActive()) {
                return;
            }
            int skipTransaction = 0;
            int numRows = data.getNumRows();
            if (numRows == 0) {
                RfcApi.RfcAbort(act_cntl.hrfc, "Empty LUW");
                throw new RfcException(6, "NoHandle+No State+NoTID+CheckTID", 108, "RFC_ERROR_INTERNAL", act_cntl.hrfc, true);
            }
            if ((dwFlag & 2) != 0) {
                try {
                    if (!server.onCheckTID(arfcTid)) return;
                    int n = 0;
                    skipTransaction = n;
                }
                catch (Exception e) {
                    skipTransaction = -1;
                }
            } else {
                skipTransaction = 0;
            }
            if (skipTransaction != 0) {
                if (skipTransaction >= 0) return;
                RfcApi.RfcAbort(act_cntl.hrfc, "COMMUNICATION_FAILURE Cannot lock transaction");
                throw new RfcException(6, "NoHandle+No State+NoTID+CheckTID", 108, "RFC_ERROR_INTERNAL", act_cntl.hrfc, true);
            }
            server.setState((byte)(server.state | 0x20));
            try {
                try {
                    this.executePlayback(act_cntl, data, arfcUser, server);
                    if ((dwFlag & 2) != 0) {
                        try {
                            server.onCommit(arfcTid);
                        }
                        catch (Throwable e) {
                            if (traceLevel > 0 || act_cntl.trace) {
                                StringWriter sw = new StringWriter();
                                PrintWriter pw = new PrintWriter(sw);
                                e.printStackTrace(pw);
                                pw.flush();
                                FastStringBuffer text = new FastStringBuffer(120);
                                text.append("TRFC Error> server.onCommit(").append(arfcTid).append(") failed with application exception \n   ").append(sw.getBuffer().toString());
                                if (traceLevel > 0) {
                                    JCO.fireTrace(1, text.toString());
                                }
                                if (act_cntl.trace) {
                                    Trc.ab_rfctrc(text.toString());
                                }
                            }
                            String message = e.getMessage();
                            RfcApi.RfcAbort(act_cntl.hrfc, "Commit fault " + (message == null ? "no message" : message));
                            throw new RfcException(6, "Commit fault " + (message == null ? "no message" : message), 108, "RFC_ERROR_INTERNAL", act_cntl.hrfc, true);
                        }
                    }
                    Object var19_23 = null;
                    server.setState((byte)(server.state & 0xFFFFFFDF));
                    return;
                }
                catch (RfcException ex) {
                    try {
                        server.onRollback(arfcTid);
                        throw ex;
                    }
                    catch (Throwable e) {
                        if (traceLevel > 0 || act_cntl.trace) {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            e.printStackTrace(pw);
                            pw.flush();
                            FastStringBuffer text = new FastStringBuffer(120);
                            text.append("TRFC Error> server.onRollback(").append(arfcTid).append(") failed with application exception \n   ").append(sw.getBuffer().toString());
                            if (traceLevel > 0) {
                                JCO.fireTrace(1, text.toString());
                            }
                            if (act_cntl.trace) {
                                Trc.ab_rfctrc(text.toString());
                            }
                        }
                        String message = e.getMessage();
                        throw new RfcException(6, "Rollback fault " + (message == null ? "no message" : message), 108, "RFC_ERROR_INTERNAL", act_cntl.hrfc, true);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var19_24 = null;
                server.setState((byte)(server.state & 0xFFFFFFDF));
                throw throwable;
            }
        }

        private void executePlayback(RfcIoOpenCntl org_cntl, ARFCSDATA data, String arfcUser, JCO.Server server) throws RfcException {
            RfcPlaybackInfo info = new RfcPlaybackInfo();
            long handle = 0L;
            info.itab_h = data;
            handle = RfcIoControl.ab_rfcaccept(10, info);
            if (handle == 0L) {
                if (org_cntl.trace) {
                    Trc.ab_rfctrc("TRFC Error> Could not open playback handle\n");
                }
                throw new RfcException(1, "TRFC Error> ab_rfcaccept failed\n", 108, "RfcRc.RFC_ERROR_INTERNAL", handle, true);
            }
            RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(handle);
            if (act_cntl == null) {
                if (org_cntl.trace) {
                    Trc.ab_rfctrc("TRFC Error> Playback handle [" + handle + "] OK but act_cntl is NULL\n");
                }
                throw new RfcException(18, "Invalid handle", 108, "RfcRc.RFC_ERROR_INTERNAL", org_cntl.hrfc, true);
            }
            act_cntl.destination = org_cntl.destination;
            System.arraycopy(org_cntl.conv_id, 0, act_cntl.conv_id, 0, org_cntl.conv_id.length);
            act_cntl.mandt = org_cntl.mandt;
            act_cntl.userid = arfcUser != null && arfcUser.length() > 0 ? arfcUser : org_cntl.userid;
            act_cntl.lang = org_cntl.lang;
            act_cntl.codepage = org_cntl.codepage;
            act_cntl.intformat = org_cntl.intformat;
            act_cntl.communication_cp = org_cntl.communication_cp;
            act_cntl.real_pcs = act_cntl.pcs = org_cntl.pcs;
            act_cntl.trace = org_cntl.trace;
            act_cntl.htRFC = org_cntl.hrfc;
            act_cntl.th_client_id = org_cntl.th_client_id;
            try {
                try {
                    server.rfc_handle = act_cntl.hrfc;
                    while (true) {
                        String funcName = null;
                        try {
                            funcName = RfcGetName.ab_RfcDispatchLoc(act_cntl);
                        }
                        catch (RfcException ex) {
                            if (ex.getRc() != 13) {
                                if (org_cntl.trace) {
                                    Trc.ab_rfctrc("TRFC> RfcGetName.ab_RfcDispatchLoc[" + handle + "] ex.getRC returned " + ex.getRc() + "\n");
                                }
                                throw ex;
                            }
                            funcName = ex.getMessage();
                            if (org_cntl.trace) {
                                Trc.ab_rfctrc("TRFC> Call [" + handle + "] dispatched to: " + funcName + "\n");
                            }
                            this.dispatchRequest(server, funcName);
                        }
                    }
                }
                catch (RfcException ex) {
                    int rfc_rc = ex.getRc();
                    if (rfc_rc != 6) {
                        if (org_cntl.trace) {
                            Trc.ab_rfctrc("TRFC Error> RfcGetName.ab_RfcDispatchLoc[" + handle + "] exited with: " + ex.toString() + ". \n>>>>Abort.\n");
                        }
                        RfcApi.RfcAbort(org_cntl.hrfc, ex.getMessage());
                        throw new RfcException(6, ex.getMessage(), ex.getErrorGroup(), ex.getKey(), server.rfc_handle, true);
                    }
                    Object var12_12 = null;
                    server.rfc_handle = org_cntl.hrfc;
                    RfcApi.RfcClose(handle);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                server.rfc_handle = org_cntl.hrfc;
                RfcApi.RfcClose(handle);
                throw throwable;
            }
        }

        protected void handletRfcConfirm(JCO.Server server) {
            RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(server.rfc_handle);
            IRfcParameter[] parameters = new IRfcParameter[2];
            RfcChars callid = new RfcChars(act_cntl, "CALLID", 24);
            RfcChars tid = new RfcChars(act_cntl, "TID", 24);
            parameters[0] = callid;
            parameters[1] = tid;
            try {
                RfcApi.RfcGetData(server.rfc_handle, parameters, null, null);
                try {
                    server.onConfirmTID(callid.getLength() == 0 ? tid.toString() : callid.toString());
                }
                catch (Throwable t) {
                    // empty catch block
                }
                act_cntl.ab_rfccount(0);
                RfcApi.RfcSendData(server.rfc_handle, null, null, null);
            }
            catch (RfcException e) {
                MiddlewareJRfc.this.trace(1, "onConfirm failed: " + e.toString());
            }
        }

        /*
         * Loose catch block
         */
        protected void dispatchRequest(JCO.Server server, String functionModule) throws RfcException {
            FastStringBuffer buf;
            ArrayList<IRfcTable> tables;
            byte[] sncPartnerAclKey;
            String sncPartnerName;
            boolean authorized;
            long tstart = 0L;
            long ttotal = 0L;
            long tmarshall = 0L;
            long tunmarshall = 0L;
            long tmiddleware = 0L;
            long temp = 0L;
            long trequest = 0L;
            long receivedBytes = 0L;
            long sentBytes = 0L;
            long tstart_time = 0L;
            JCO.Function function = null;
            tstart_time = ttotal = System.currentTimeMillis();
            if (traceLevel > 2) {
                MiddlewareJRfc.this.trace(3, "Dispatching request for " + server.rfc_handle + ": " + functionModule);
            }
            server.setState((byte)(server.state | 4));
            MiddlewareJRfc.this.getAttributes(server, this);
            if (traceLevel > 4) {
                MiddlewareJRfc.this.trace(5, "DispatchRequest before RfcSncMode(" + server.rfc_handle + ')');
            }
            boolean sncMode = RfcApi.RfcSncMode(server.rfc_handle);
            if (traceLevel > 4) {
                MiddlewareJRfc.this.trace(5, "DispatchRequest after RfcSncMode(" + server.rfc_handle + ")=" + (sncMode ? "on" : "off"));
            }
            if (sncMode && !(authorized = server.checkAuthorization(functionModule, 0, sncPartnerName = RfcApi.RfcSncPartnerName(server.rfc_handle), sncPartnerAclKey = RfcApi.RfcSncPartnerAclKey(server.rfc_handle)))) {
                throw new JCO.Exception(120, "JCO_ERROR_EXTENSION", "Not authorized to execute " + functionModule);
            }
            try {
                function = server.getFunction(functionModule);
            }
            catch (Exception e) {
                String message = "Server repository could not create function template for '" + functionModule + "' caused by: " + e.toString();
                Trc.criticalTrace(message, e);
                MiddlewareJRfc.this.trace(3, message);
                throw new JCO.Exception(123, "JCO_ERROR_FUNCTION_NOT_FOUND", message);
            }
            if (function == null) {
                String message = "JCO.Server could not find server function '" + functionModule + '\'';
                MiddlewareJRfc.this.trace(3, message);
                throw new JCO.Exception(123, "JCO_ERROR_FUNCTION_NOT_FOUND", message);
            }
            tstart = System.currentTimeMillis();
            JCO.ParameterList imp = function.getImportParameterList();
            JCO.ParameterList tab = function.getTableParameterList();
            IRfcParameter[] imports_rfc = null;
            IRfcParameter[] importChangings_rfc = null;
            IRfcTable[] tables_rfc = null;
            if (imp != null) {
                ArrayList<IRfcParameter> imports = new ArrayList<IRfcParameter>(imp.num_fields);
                ArrayList<IRfcParameter> importChangings = new ArrayList<IRfcParameter>(imp.num_fields);
                int i = 0;
                while (i < imp.num_fields) {
                    IRfcParameter param = this.getParameter(imp, i);
                    if (param != null) {
                        if ((imp.flags[i] & 2) != 0) {
                            importChangings.add(param);
                        } else {
                            imports.add(param);
                        }
                    }
                    ++i;
                }
                if (imports.size() > 0) {
                    imports_rfc = new IRfcParameter[imports.size()];
                    imports_rfc = imports.toArray(imports_rfc);
                }
                if (importChangings.size() > 0) {
                    importChangings_rfc = new IRfcParameter[importChangings.size()];
                    importChangings_rfc = importChangings.toArray(importChangings_rfc);
                }
            }
            if (tab != null) {
                tables = new ArrayList<IRfcTable>(tab.num_fields);
                int i = 0;
                while (i < tab.num_fields) {
                    if ((tab.flags[i] & 0x20) == 0 && (tab.flags[i] & 0x10) == 0) {
                        tables.add(new TableParameter((JCO.Table)tab.odata[tab.oindex[i]], tab.name[i], this.converter, i));
                    }
                    ++i;
                }
                if (tables.size() > 0) {
                    tables_rfc = new TableParameter[tables.size()];
                    tables_rfc = tables.toArray(tables_rfc);
                }
            }
            temp = System.currentTimeMillis();
            tmarshall = temp - tstart;
            tstart = temp;
            if (traceLevel > 2) {
                buf = new FastStringBuffer();
                buf.append("DispatchRequest before RfcGetData(").append(server.rfc_handle).append(", ");
                buf.append(functionModule).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                buf.append(", ").append(importChangings_rfc == null ? "null" : Integer.toString(importChangings_rfc.length));
                buf.append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                MiddlewareJRfc.this.trace(3, buf.toString());
            }
            RfcApi.RfcGetData(server.rfc_handle, imports_rfc, importChangings_rfc, tables_rfc);
            if (traceLevel > 2) {
                buf = new FastStringBuffer();
                buf.append("DispatchRequest after RfcGetData(").append(server.rfc_handle).append(", ");
                buf.append(functionModule).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                buf.append(", ").append(importChangings_rfc == null ? "null" : Integer.toString(importChangings_rfc.length));
                buf.append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                MiddlewareJRfc.this.trace(3, buf.toString());
            }
            temp = System.currentTimeMillis();
            tmiddleware = temp - tstart;
            tstart = temp;
            if (tables_rfc != null) {
                tables = new ArrayList(tab.num_fields);
                int i = 0;
                while (i < tables_rfc.length) {
                    if (!((TableParameter)tables_rfc[i]).isActive()) {
                        int n = ((TableParameter)tables_rfc[i]).getIndex();
                        tab.flags[n] = (byte)(tab.flags[n] | 0x18);
                    } else if (((TableParameter)tables_rfc[i]).getNumRows() == 0) {
                        int n = ((TableParameter)tables_rfc[i]).getIndex();
                        tab.flags[n] = (byte)(tab.flags[n] | 8);
                        tables.add(tables_rfc[i]);
                    } else {
                        tables.add(tables_rfc[i]);
                        int n = ((TableParameter)tables_rfc[i]).getIndex();
                        tab.flags[n] = (byte)(tab.flags[n] & 0xFFFFFFF7);
                    }
                    ++i;
                }
                if (tables.size() > 0) {
                    tables_rfc = new TableParameter[tables.size()];
                    tables_rfc = (TableParameter[])tables.toArray(tables_rfc);
                } else {
                    tables_rfc = null;
                }
            }
            if (server.throughput != null || monitorOn) {
                receivedBytes = MiddlewareJRfc.this.countBytes(imports_rfc, importChangings_rfc, tables_rfc);
            }
            if (traceLevel > 2) {
                MiddlewareJRfc.this.trace(3, "DispatchRequest before RfcGetClientId(" + server.rfc_handle + ')');
            }
            server.passport_bytes = RfcApi.RfcGetClientId(server.rfc_handle);
            if (traceLevel > 2) {
                MiddlewareJRfc.this.trace(3, "DispatchRequest after RfcGetClientId(" + server.rfc_handle + "), received " + (server.passport_bytes == null ? "no passport" : "passport with length " + server.passport_bytes.length));
            }
            if (server.throughput != null || monitorOn) {
                server.rfm_name = functionModule;
                server.start_time = tstart_time;
                server.beginCall();
            }
            if (traceLevel > 2) {
                MiddlewareJRfc.this.trace(3, "DispatchRequest before JCO.Server.dispatchRequest " + functionModule);
            }
            try {
                server.dispatchRequest(function);
            }
            catch (JCO.AbapException jae) {
                MiddlewareJRfc.this.trace(1, "dispatchRequest caught an application exception: " + jae.getMessage());
                if ((server.state & 0x20) != 0) {
                    throw new RfcException(1, jae.getMessage(), 104, "RFC_ERROR_SYSTEM_FAILURE", server.rfc_handle, true);
                }
                try {
                    RfcApi.RfcRaiseErrorMessage(server.rfc_handle, jae.getKey(), jae.getMessage());
                }
                catch (RfcException re) {
                    MiddlewareJRfc.this.trace(1, "dispatchRequest: RaiseErrorMessage failed: " + re);
                }
                throw new DispatchException();
            }
            catch (JCO.J2EEAbapException jjae) {
                MiddlewareJRfc.this.trace(1, "dispatchRequest caught an application exception: " + jjae.getMessage());
                if ((server.state & 0x20) != 0) {
                    throw new RfcException(1, jjae.getMessage(), 104, "RFC_ERROR_SYSTEM_FAILURE", server.rfc_handle, true);
                }
                try {
                    RfcApi.RfcRaiseErrorMessage(server.rfc_handle, jjae.getKey(), jjae.getMessage());
                }
                catch (RfcException re) {
                    MiddlewareJRfc.this.trace(1, "dispatchRequest: RaiseErrorMessage failed: " + re);
                }
                throw new DispatchException();
            }
            catch (Exception e) {
                String message = e.getMessage();
                MiddlewareJRfc.this.trace(1, "dispatchRequest caught an application exception: " + (message == null ? e.toString() : message));
                if ((server.state & 0x20) != 0) {
                    throw new RfcException(1, message == null ? e.toString() : message, 104, "RFC_ERROR_SYSTEM_FAILURE", server.rfc_handle, true);
                }
                if (function != null && function.getException(message) != null) {
                    try {
                        RfcApi.RfcRaise(server.rfc_handle, message);
                    }
                    catch (RfcException re) {
                        MiddlewareJRfc.this.trace(1, "dispatchRequest: Raise failed: " + re);
                    }
                    throw new DispatchException();
                }
                Trc.criticalTrace("Exception thrown by application running in JCo Server", e);
                this.abort(server, message == null ? e.toString() : message);
                throw new DispatchException();
            }
            catch (Error e) {
                String message = e.getMessage();
                MiddlewareJRfc.this.trace(1, "dispatchRequest caught an application error: " + (message == null ? e.toString() : message));
                Trc.criticalTrace("Error thrown by application running in JCo Server", e);
                if ((server.state & 0x20) != 0) {
                    throw new RfcException(1, message == null ? e.toString() : message, 104, "RFC_ERROR_SYSTEM_FAILURE", server.rfc_handle, true);
                }
                this.abort(server, message == null ? e.toString() : message);
                throw new DispatchException();
            }
            if (traceLevel > 2) {
                MiddlewareJRfc.this.trace(3, "DispatchRequest after JCO.Server.dispatchRequest " + functionModule);
            }
            temp = System.currentTimeMillis();
            trequest = temp - tstart;
            tstart = temp;
            JCO.ParameterList exp = function.getExportParameterList();
            IRfcParameter[] exports_rfc = null;
            IRfcParameter[] exportChangings_rfc = null;
            if (exp != null) {
                ArrayList<IRfcParameter> exports = new ArrayList<IRfcParameter>(exp.num_fields);
                ArrayList<IRfcParameter> exportChangings = new ArrayList<IRfcParameter>(exp.num_fields);
                int i = 0;
                while (i < exp.num_fields) {
                    IRfcParameter param = this.getParameter(exp, i);
                    if (param != null) {
                        if ((exp.flags[i] & 1) != 0) {
                            exportChangings.add(param);
                        } else {
                            exports.add(param);
                        }
                    }
                    ++i;
                }
                if (exports.size() > 0) {
                    exports_rfc = new IRfcParameter[exports.size()];
                    exports_rfc = exports.toArray(exports_rfc);
                }
                if (exportChangings.size() > 0) {
                    exportChangings_rfc = new IRfcParameter[exportChangings.size()];
                    exportChangings_rfc = exportChangings.toArray(exportChangings_rfc);
                }
            }
            if (tables_rfc != null) {
                int i = 0;
                while (i < tables_rfc.length) {
                    ((TableParameter)tables_rfc[i]).setTable((JCO.Table)tab.odata[tab.oindex[((TableParameter)tables_rfc[i]).getIndex()]]);
                    ++i;
                }
            }
            temp = System.currentTimeMillis();
            tmarshall += temp - tstart;
            tstart = temp;
            if (traceLevel > 2) {
                FastStringBuffer buf2 = new FastStringBuffer();
                buf2.append("DispatchRequest before RfcSendData(").append(server.rfc_handle).append(", ");
                buf2.append(functionModule).append(", ").append(exports_rfc == null ? "null" : Integer.toString(exports_rfc.length));
                buf2.append(", ").append(exportChangings_rfc == null ? "null" : Integer.toString(exportChangings_rfc.length));
                buf2.append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                MiddlewareJRfc.this.trace(3, buf2.toString());
            }
            RfcApi.RfcSendData(server.rfc_handle, exports_rfc, exportChangings_rfc, tables_rfc);
            if (server.throughput != null || monitorOn) {
                sentBytes = MiddlewareJRfc.this.countBytes(exports_rfc, exportChangings_rfc, tables_rfc);
            }
            if (traceLevel > 2) {
                FastStringBuffer buf3 = new FastStringBuffer();
                buf3.append("DispatchRequest after RfcSendData(").append(server.rfc_handle).append(", ");
                buf3.append(functionModule).append(", ").append(exports_rfc == null ? "null" : Integer.toString(exports_rfc.length));
                buf3.append(", ").append(exportChangings_rfc == null ? "null" : Integer.toString(exportChangings_rfc.length));
                buf3.append(", ").append(tables_rfc == null ? "null" : Integer.toString(tables_rfc.length)).append(')');
                MiddlewareJRfc.this.trace(3, buf3.toString());
            }
            tmiddleware += System.currentTimeMillis() - tstart;
            Object var38_49 = null;
            ttotal = System.currentTimeMillis() - ttotal;
            try {
                if (server.throughput != null) {
                    JCO.Throughput throughput = server.throughput;
                    synchronized (throughput) {
                        ++server.throughput.num_calls;
                        server.throughput.time_marshall += tmarshall;
                        server.throughput.time_unmarshall += tunmarshall;
                        server.throughput.time_middleware += tmiddleware;
                        server.throughput.time_handle_request += trequest;
                        server.throughput.time_total += ttotal;
                        server.throughput.num_sent_bytes += sentBytes;
                        server.throughput.num_received_bytes += receivedBytes;
                    }
                    if (!monitorOn) {
                        server.endCall();
                    }
                }
                if (monitorOn) {
                    server.time_handle_request = trequest;
                    server.time_middleware = tmiddleware;
                    server.time_total = ttotal;
                    server.num_sent_bytes = sentBytes;
                    server.num_received_bytes = receivedBytes;
                    server.endCall();
                }
                Object var42_64 = null;
                server.setState((byte)(server.state & 0xFFFFFFFB));
            }
            catch (Throwable throwable) {
                Object var42_65 = null;
                server.setState((byte)(server.state & 0xFFFFFFFB));
                throw throwable;
            }
            {
                catch (DispatchException de) {
                    Object var38_50 = null;
                    ttotal = System.currentTimeMillis() - ttotal;
                    try {
                        if (server.throughput != null) {
                            JCO.Throughput throughput = server.throughput;
                            synchronized (throughput) {
                                ++server.throughput.num_calls;
                                server.throughput.time_marshall += tmarshall;
                                server.throughput.time_unmarshall += tunmarshall;
                                server.throughput.time_middleware += tmiddleware;
                                server.throughput.time_handle_request += trequest;
                                server.throughput.time_total += ttotal;
                                server.throughput.num_sent_bytes += sentBytes;
                                server.throughput.num_received_bytes += receivedBytes;
                            }
                            if (!monitorOn) {
                                server.endCall();
                            }
                        }
                        if (monitorOn) {
                            server.time_handle_request = trequest;
                            server.time_middleware = tmiddleware;
                            server.time_total = ttotal;
                            server.num_sent_bytes = sentBytes;
                            server.num_received_bytes = receivedBytes;
                            server.endCall();
                        }
                        Object var42_66 = null;
                        server.setState((byte)(server.state & 0xFFFFFFFB));
                    }
                    catch (Throwable throwable) {
                        Object var42_67 = null;
                        server.setState((byte)(server.state & 0xFFFFFFFB));
                        throw throwable;
                    }
                }
                catch (RfcException re) {
                    throw re;
                }
                catch (Exception e) {
                    JCO.fireServerExceptionOccurred(server, e);
                    String message = e.getMessage();
                    MiddlewareJRfc.this.trace(1, "dispatchRequest caught an exception: " + (message == null ? e.toString() : message));
                    if ((server.state & 0x20) != 0) {
                        throw new RfcException(1, message == null ? e.toString() : message, 104, "RFC_ERROR_SYSTEM_FAILURE", server.rfc_handle, true);
                    }
                    this.abort(server, message == null ? e.toString() : message);
                    Trc.criticalTrace("Exception thrown in JCo Server", e);
                    Object var38_51 = null;
                    ttotal = System.currentTimeMillis() - ttotal;
                    try {
                        if (server.throughput != null) {
                            JCO.Throughput throughput = server.throughput;
                            synchronized (throughput) {
                                ++server.throughput.num_calls;
                                server.throughput.time_marshall += tmarshall;
                                server.throughput.time_unmarshall += tunmarshall;
                                server.throughput.time_middleware += tmiddleware;
                                server.throughput.time_handle_request += trequest;
                                server.throughput.time_total += ttotal;
                                server.throughput.num_sent_bytes += sentBytes;
                                server.throughput.num_received_bytes += receivedBytes;
                            }
                            if (!monitorOn) {
                                server.endCall();
                            }
                        }
                        if (monitorOn) {
                            server.time_handle_request = trequest;
                            server.time_middleware = tmiddleware;
                            server.time_total = ttotal;
                            server.num_sent_bytes = sentBytes;
                            server.num_received_bytes = receivedBytes;
                            server.endCall();
                        }
                        Object var42_68 = null;
                        server.setState((byte)(server.state & 0xFFFFFFFB));
                    }
                    catch (Throwable throwable) {
                        Object var42_69 = null;
                        server.setState((byte)(server.state & 0xFFFFFFFB));
                        throw throwable;
                    }
                }
                catch (Error e) {
                    JCO.fireServerErrorOccurred(server, e);
                    String message = e.getMessage();
                    MiddlewareJRfc.this.trace(1, "dispatchRequest caught an error: " + (message == null ? e.toString() : message));
                    if ((server.state & 0x20) != 0) {
                        throw new RfcException(1, message == null ? e.toString() : message, 104, "RFC_ERROR_SYSTEM_FAILURE", server.rfc_handle, true);
                    }
                    this.abort(server, message == null ? e.toString() : message);
                    Trc.criticalTrace("Error thrown in JCo Server", e);
                    Object var38_52 = null;
                    ttotal = System.currentTimeMillis() - ttotal;
                    try {
                        if (server.throughput != null) {
                            JCO.Throughput throughput = server.throughput;
                            synchronized (throughput) {
                                ++server.throughput.num_calls;
                                server.throughput.time_marshall += tmarshall;
                                server.throughput.time_unmarshall += tunmarshall;
                                server.throughput.time_middleware += tmiddleware;
                                server.throughput.time_handle_request += trequest;
                                server.throughput.time_total += ttotal;
                                server.throughput.num_sent_bytes += sentBytes;
                                server.throughput.num_received_bytes += receivedBytes;
                            }
                            if (!monitorOn) {
                                server.endCall();
                            }
                        }
                        if (monitorOn) {
                            server.time_handle_request = trequest;
                            server.time_middleware = tmiddleware;
                            server.time_total = ttotal;
                            server.num_sent_bytes = sentBytes;
                            server.num_received_bytes = receivedBytes;
                            server.endCall();
                        }
                        Object var42_70 = null;
                        server.setState((byte)(server.state & 0xFFFFFFFB));
                    }
                    catch (Throwable throwable) {
                        Object var42_71 = null;
                        server.setState((byte)(server.state & 0xFFFFFFFB));
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var38_53 = null;
                ttotal = System.currentTimeMillis() - ttotal;
                try {
                    if (server.throughput != null) {
                        JCO.Throughput throughput = server.throughput;
                        synchronized (throughput) {
                            ++server.throughput.num_calls;
                            server.throughput.time_marshall += tmarshall;
                            server.throughput.time_unmarshall += tunmarshall;
                            server.throughput.time_middleware += tmiddleware;
                            server.throughput.time_handle_request += trequest;
                            server.throughput.time_total += ttotal;
                            server.throughput.num_sent_bytes += sentBytes;
                            server.throughput.num_received_bytes += receivedBytes;
                        }
                        if (!monitorOn) {
                            server.endCall();
                        }
                    }
                    if (monitorOn) {
                        server.time_handle_request = trequest;
                        server.time_middleware = tmiddleware;
                        server.time_total = ttotal;
                        server.num_sent_bytes = sentBytes;
                        server.num_received_bytes = receivedBytes;
                        server.endCall();
                    }
                    Object var42_72 = null;
                    server.setState((byte)(server.state & 0xFFFFFFFB));
                }
                catch (Throwable throwable2) {
                    Object var42_73 = null;
                    server.setState((byte)(server.state & 0xFFFFFFFB));
                    throw throwable2;
                }
                throw throwable;
            }
        }
    }

    public class Client
    extends Connection
    implements IMiddleware.IClient {
        RfcOptions logonParams = new RfcOptions();

        Client() {
        }

        public String[][] getPropertyInfo() {
            return pinfoClient;
        }

        public void initialize(JCO.Client client, Properties params) {
            boolean noRouterProperty;
            String value = MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_TYPE, params);
            String routerString = MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_SAPROUTER, params);
            boolean bl = noRouterProperty = routerString == null;
            if (value == null) {
                value = "3";
            }
            switch (value.charAt(0)) {
                case '3': {
                    String r3name = MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_R3NAME, params);
                    if (r3name != null) {
                        ((Hashtable)params).put(MiddlewareJRfc.JCO_TYPE, "B");
                        String mshost = MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_MSHOST, params);
                        if (mshost == null || routerString != null || (routerString = MiddlewareJRfc.this.extractRouterString(mshost)) == null) break;
                        MiddlewareJRfc.this.removeProperty(MiddlewareJRfc.JCO_MSHOST, params);
                        ((Hashtable)params).put(MiddlewareJRfc.JCO_MSHOST, MiddlewareJRfc.this.getPlainHost(mshost, routerString.length() + 3));
                        break;
                    }
                    String ashost = MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_ASHOST, params);
                    if (routerString == null && (routerString = MiddlewareJRfc.this.extractRouterString(ashost)) != null) {
                        MiddlewareJRfc.this.removeProperty(MiddlewareJRfc.JCO_ASHOST, params);
                        ((Hashtable)params).put(MiddlewareJRfc.JCO_ASHOST, MiddlewareJRfc.this.getPlainHost(ashost, routerString.length() + 3));
                    }
                    ((Hashtable)params).put(MiddlewareJRfc.JCO_TYPE, "A");
                    break;
                }
                default: {
                    String gwhost = MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_GWHOST, params);
                    if (routerString == null && (routerString = MiddlewareJRfc.this.extractRouterString(gwhost)) != null) {
                        MiddlewareJRfc.this.removeProperty(MiddlewareJRfc.JCO_GWHOST, params);
                        ((Hashtable)params).put(MiddlewareJRfc.JCO_GWHOST, MiddlewareJRfc.this.getPlainHost(gwhost, routerString.length() + 3));
                    }
                    ((Hashtable)params).put(MiddlewareJRfc.JCO_TYPE, value.substring(0, 1));
                }
            }
            if (noRouterProperty && routerString != null) {
                ((Hashtable)params).put(MiddlewareJRfc.JCO_SAPROUTER, routerString);
            }
            this.logonParams.setKind('R');
            String req_cp = MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_CODEPAGE, params);
            if (req_cp != null && req_cp.length() == 4) {
                if (req_cp.charAt(0) == '4' && !req_cp.equals("4110")) {
                    this.logonParams.setPcs(2);
                } else {
                    this.logonParams.setPcs(1);
                }
                this.logonParams.setCommunication_cp(req_cp);
            } else {
                this.logonParams.setPcs(1);
            }
            this.logonParams.setDestination("<Java Rfc client>");
            boolean snc_mode = MiddlewareJRfc.this.toBoolean(MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_SNC_MODE, params));
            if (snc_mode) {
                if (MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_SNC_QOP, params) == null) {
                    ((Hashtable)params).put(MiddlewareJRfc.JCO_SNC_QOP, "8");
                }
                if (MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_SNC_LIBRARY, params) == null) {
                    ((Hashtable)params).put(MiddlewareJRfc.JCO_SNC_LIBRARY, MiddlewareJRfc.this.getProperty(MiddlewareJRfc.JCO_SNC_LIB));
                }
            }
            if (MiddlewareJRfc.this.toBoolean(MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_ABAP_DEBUG, params))) {
                ((Hashtable)params).put("jco.client.debug_ext", "1");
            }
            try {
                this.logonParams.setProperties(params, "jco.client.");
            }
            catch (RfcException re) {
                throw MiddlewareJRfc.this.generateJCoException(re);
            }
            this.logonParams.setAllocationType((byte)(MiddlewareJRfc.this.toBoolean(MiddlewareJRfc.this.findProperty(MiddlewareJRfc.JCO_JRA_CONN, params)) ? 1 : (client.pool != null ? 2 : 3)));
            client.conn_params = this.logonParams.toString();
        }

        public void connect(JCO.Client client, String params) {
            long tstart = 0L;
            long ttotal = 0L;
            long tmiddleware = 0L;
            ttotal = System.currentTimeMillis();
            if (traceLevel > 2) {
                MiddlewareJRfc.this.trace(3, "Connect before RfcOpen(" + params + ')');
            }
            tstart = System.currentTimeMillis();
            long handle = 0L;
            try {
                handle = RfcApi.RfcOpen(this.logonParams);
            }
            catch (RfcException re) {
                throw MiddlewareJRfc.this.generateJCoException(re);
            }
            if (traceLevel > 2) {
                MiddlewareJRfc.this.trace(3, "Connect after RfcOpen(" + params + ")=" + handle);
            }
            tmiddleware = System.currentTimeMillis() - tstart;
            if (handle == 0L) {
                throw new JCO.Exception(103, "JCO_ERROR_LOGON_FAILURE", "Could not get a connection handle");
            }
            client.rfc_handle = handle;
            if (this.logonParams.isGetsso2()) {
                MiddlewareJRfc.this.getAttributes(client, this);
            }
            ttotal = System.currentTimeMillis() - ttotal;
            if (client.throughput != null) {
                JCO.Throughput throughput = client.throughput;
                synchronized (throughput) {
                    client.throughput.time_middleware += tmiddleware;
                    client.throughput.time_total += ttotal;
                }
            }
        }

        public void disconnect(JCO.Client client) {
            MiddlewareJRfc.this.disconnect(client);
        }

        public void abort(JCO.Client client, String message) {
            try {
                MiddlewareJRfc.this.abort(client, message);
            }
            catch (RfcException rfcException) {
                // empty catch block
            }
        }

        public void reset(JCO.Client client) {
            block10: {
                if (client.rfc_handle == 0L) {
                    return;
                }
                RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(client.rfc_handle);
                if (act_cntl == null || !act_cntl.used) {
                    client.rfc_handle = 0L;
                    return;
                }
                if (act_cntl.close_pending) {
                    MiddlewareJRfc.this.disconnect(client);
                    return;
                }
                char partnerType = act_cntl.partner_type.charAt(0);
                int kernelRel = client.getAttributes().getKernelReleaseNumber();
                if (partnerType == '3' && (act_cntl.pcs == 2 || kernelRel >= 463)) {
                    act_cntl.ab_rfcreset_send();
                    try {
                        if (traceLevel > 2) {
                            MiddlewareJRfc.this.trace(3, "Reset before RfcCleanupContext(" + client.rfc_handle + ')');
                        }
                        RfcApi.RfcCallReceive(client.rfc_handle, "SYSTEM_RESET_RFC_SERVER", null, null, null, null);
                        if (traceLevel > 2) {
                            MiddlewareJRfc.this.trace(3, "Reset after RfcCleanupContext(" + client.rfc_handle + ')');
                        }
                        act_cntl.identified = false;
                    }
                    catch (RfcException re) {
                        if (re.getRc() == 6) {
                            MiddlewareJRfc.this.disconnect(client);
                            break block10;
                        }
                        MiddlewareJRfc.this.generateJCoException(re);
                    }
                } else {
                    MiddlewareJRfc.this.disconnect(client);
                    this.initialize(client, client.properties);
                    this.connect(client, client.conn_params);
                }
            }
        }

        public boolean isAlive(JCO.Client client) {
            return MiddlewareJRfc.this.isAlive(client);
        }

        public void getAttributes(JCO.Client client) {
            MiddlewareJRfc.this.getAttributes(client, this);
        }

        /*
         * Loose catch block
         */
        public void execute(JCO.Client client, String name, JCO.ParameterList imp, JCO.ParameterList imptab, JCO.ParameterList exp, JCO.ParameterList exptab, String tid, String qname, int qcount) {
            block81: {
                long tstart = 0L;
                long ttotal = 0L;
                long tmiddleware = 0L;
                long tmarshall = 0L;
                long tunmarshall = 0L;
                long temp = 0L;
                long receivedBytes = 0L;
                long sentBytes = 0L;
                boolean isTransactional = tid != null && tid.length() > 0;
                boolean isQueued = qname != null && qname.length() > 0;
                MiddlewareJRfc.this.trace(1, "Executing " + name + " for handle " + client.rfc_handle);
                ttotal = System.currentTimeMillis();
                if (client.rfc_handle == 0L) {
                    throw new JCO.Exception(121, "JCO_ERROR_NULL_HANDLE", "Invalid rfc_handle = NULL encountered");
                }
                if (isTransactional && tid.length() > 24) {
                    throw new JCO.Exception(108, "JCO_ERROR_INTERNAL", "Incorrect size of TID encountered");
                }
                if (isQueued) {
                    if (!isTransactional) {
                        throw new JCO.Exception(108, "JCO_ERROR_INTERNAL", "Missing TID in queued transaction processing");
                    }
                    if (qname.length() > 24) {
                        throw new JCO.Exception(108, "JCO_ERROR_INTERNAL", "Incorrect size of queue name encountered");
                    }
                }
                try {
                    FastStringBuffer buf;
                    IRfcParameter param;
                    int i;
                    if (this.converter == null) {
                        MiddlewareJRfc.this.getAttributes(client, this);
                    }
                    tstart = System.currentTimeMillis();
                    IRfcParameter[] imports_rfc = null;
                    IRfcParameter[] importChangings_rfc = null;
                    IRfcParameter[] exports_rfc = null;
                    IRfcParameter[] exportChangings_rfc = null;
                    IRfcTable[] importTables_rfc = null;
                    IRfcTable[] exportTables_rfc = null;
                    if (imp != null) {
                        ArrayList<IRfcParameter> imports = new ArrayList<IRfcParameter>(imp.num_fields);
                        ArrayList<IRfcParameter> importChangings = new ArrayList<IRfcParameter>(imp.num_fields);
                        i = 0;
                        while (i < imp.num_fields) {
                            param = this.getParameter(imp, i);
                            if (param != null) {
                                if ((imp.flags[i] & 2) != 0) {
                                    importChangings.add(param);
                                } else {
                                    imports.add(param);
                                }
                            }
                            ++i;
                        }
                        if (imports.size() > 0) {
                            imports_rfc = new IRfcParameter[imports.size()];
                            imports_rfc = imports.toArray(imports_rfc);
                        }
                        if (importChangings.size() > 0) {
                            importChangings_rfc = new IRfcParameter[importChangings.size()];
                            importChangings_rfc = importChangings.toArray(importChangings_rfc);
                        }
                    }
                    if (imptab != null) {
                        ArrayList<TableParameter> importTables = new ArrayList<TableParameter>(imptab.num_fields);
                        int i2 = 0;
                        while (i2 < imptab.num_fields) {
                            if ((imptab.flags[i2] & 0x20) == 0 && (imptab.flags[i2] & 0x10) == 0) {
                                importTables.add(new TableParameter((JCO.Table)imptab.odata[imptab.oindex[i2]], imptab.name[i2], this.converter));
                            }
                            ++i2;
                        }
                        if (importTables.size() > 0) {
                            importTables_rfc = new TableParameter[importTables.size()];
                            importTables_rfc = importTables.toArray(importTables_rfc);
                        }
                    }
                    if (!isTransactional) {
                        if (exp != null) {
                            ArrayList<IRfcParameter> exports = new ArrayList<IRfcParameter>(exp.num_fields);
                            ArrayList<IRfcParameter> exportChangings = new ArrayList<IRfcParameter>(exp.num_fields);
                            i = 0;
                            while (i < exp.num_fields) {
                                param = this.getParameter(exp, i);
                                if (param != null) {
                                    if ((exp.flags[i] & 1) != 0) {
                                        exportChangings.add(param);
                                    } else {
                                        exports.add(param);
                                    }
                                }
                                ++i;
                            }
                            if (exports.size() > 0) {
                                exports_rfc = new IRfcParameter[exports.size()];
                                exports_rfc = exports.toArray(exports_rfc);
                            }
                            if (exportChangings.size() > 0) {
                                exportChangings_rfc = new IRfcParameter[exportChangings.size()];
                                exportChangings_rfc = exportChangings.toArray(exportChangings_rfc);
                            }
                        }
                        if (exptab != null) {
                            ArrayList<TableParameter> exportTables = new ArrayList<TableParameter>(exptab.num_fields);
                            int i3 = 0;
                            while (i3 < exptab.num_fields) {
                                if ((exptab.flags[i3] & 0x20) == 0 && (exptab.flags[i3] & 0x10) == 0) {
                                    exportTables.add(new TableParameter((JCO.Table)exptab.odata[exptab.oindex[i3]], imptab.name[i3], this.converter));
                                }
                                ++i3;
                            }
                            if (exportTables.size() > 0) {
                                exportTables_rfc = new TableParameter[exportTables.size()];
                                exportTables_rfc = (TableParameter[])exportTables.toArray(exportTables_rfc);
                            }
                        } else {
                            exportTables_rfc = importTables_rfc;
                        }
                    }
                    temp = System.currentTimeMillis();
                    tmarshall = temp - tstart;
                    tstart = temp;
                    if (client.passport_bytes != null) {
                        if (traceLevel > 2) {
                            MiddlewareJRfc.this.trace(3, "Execute before RfcSetClientId(" + client.rfc_handle + ", " + client.passport_bytes.length + ')');
                        }
                        RfcApi.RfcSetClientId(client.rfc_handle, client.passport_bytes);
                        if (traceLevel > 2) {
                            MiddlewareJRfc.this.trace(3, "Execute after RfcSetClientId(" + client.rfc_handle + ", " + client.passport_bytes.length + ')');
                        }
                    }
                    if (isQueued) {
                        if (traceLevel > 2) {
                            buf = new FastStringBuffer();
                            buf.append("Execute before RfcQueueInsert(").append(client.rfc_handle).append(", ");
                            buf.append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                            buf.append(", ").append(importTables_rfc == null ? "null" : Integer.toString(importTables_rfc.length));
                            buf.append(", ").append(qname).append(", ").append(qcount).append(", ").append(tid).append(')');
                            MiddlewareJRfc.this.trace(3, buf.toString());
                            if (imports_rfc != null && traceLevel > 4) {
                                int i4 = 0;
                                while (i4 < imports_rfc.length) {
                                    MiddlewareJRfc.this.trace(5, "Sent Parameter " + imports_rfc[i4].getName());
                                    ++i4;
                                }
                            }
                            if (importTables_rfc != null && traceLevel > 4) {
                                int i5 = 0;
                                while (i5 < importTables_rfc.length) {
                                    MiddlewareJRfc.this.trace(5, "Sent Table " + ((TableParameter)importTables_rfc[i5]).getName());
                                    ++i5;
                                }
                            }
                        }
                        RfcApi.RfcQueueInsert(client.rfc_handle, name, imports_rfc, importTables_rfc, qname, qcount, tid);
                        if (client.throughput != null || monitorOn) {
                            sentBytes = MiddlewareJRfc.this.countBytes(imports_rfc, null, importTables_rfc);
                        }
                        if (traceLevel > 2) {
                            buf = new FastStringBuffer();
                            buf.append("Execute after RfcQueueInsert(").append(client.rfc_handle).append(", ");
                            buf.append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                            buf.append(", ").append(importTables_rfc == null ? "null" : Integer.toString(importTables_rfc.length));
                            buf.append(", ").append(qname).append(", ").append(qcount).append(", ").append(tid).append(')');
                            MiddlewareJRfc.this.trace(3, buf.toString());
                        }
                    } else if (isTransactional) {
                        if (traceLevel > 2) {
                            buf = new FastStringBuffer();
                            buf.append("Execute before RfcIndirectCall(").append(client.rfc_handle).append(", ");
                            buf.append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                            buf.append(", ").append(importTables_rfc == null ? "null" : Integer.toString(importTables_rfc.length));
                            buf.append(", ").append(tid).append(')');
                            MiddlewareJRfc.this.trace(3, buf.toString());
                            if (imports_rfc != null && traceLevel > 4) {
                                int i6 = 0;
                                while (i6 < imports_rfc.length) {
                                    MiddlewareJRfc.this.trace(5, "Sent Parameter " + imports_rfc[i6].getName());
                                    ++i6;
                                }
                            }
                            if (importTables_rfc != null && traceLevel > 4) {
                                int i7 = 0;
                                while (i7 < importTables_rfc.length) {
                                    MiddlewareJRfc.this.trace(5, "Sent Table " + ((TableParameter)importTables_rfc[i7]).getName());
                                    ++i7;
                                }
                            }
                        }
                        RfcApi.RfcQueueInsert(client.rfc_handle, name, imports_rfc, importTables_rfc, null, 0, tid);
                        if (client.throughput != null || monitorOn) {
                            sentBytes = MiddlewareJRfc.this.countBytes(imports_rfc, null, importTables_rfc);
                        }
                        if (traceLevel > 2) {
                            buf = new FastStringBuffer();
                            buf.append("Execute after RfcIndirectCall(").append(client.rfc_handle).append(", ");
                            buf.append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                            buf.append(", ").append(importTables_rfc == null ? "null" : Integer.toString(importTables_rfc.length));
                            buf.append(", ").append(tid).append(')');
                            MiddlewareJRfc.this.trace(3, buf.toString());
                        }
                    } else {
                        if (traceLevel > 2) {
                            buf = new FastStringBuffer();
                            buf.append("Execute before RfcCall(").append(client.rfc_handle).append(", ");
                            buf.append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                            buf.append(", ").append(importChangings_rfc == null ? "null" : Integer.toString(importChangings_rfc.length));
                            buf.append(", ").append(importTables_rfc == null ? "null" : Integer.toString(importTables_rfc.length)).append(')');
                            MiddlewareJRfc.this.trace(3, buf.toString());
                            if (imports_rfc != null && traceLevel > 4) {
                                int i8 = 0;
                                while (i8 < imports_rfc.length) {
                                    MiddlewareJRfc.this.trace(5, "Sent Parameter " + imports_rfc[i8].getName());
                                    ++i8;
                                }
                            }
                            if (importTables_rfc != null && traceLevel > 4) {
                                int i9 = 0;
                                while (i9 < importTables_rfc.length) {
                                    MiddlewareJRfc.this.trace(5, "Sent Table " + ((TableParameter)importTables_rfc[i9]).getName());
                                    ++i9;
                                }
                            }
                        }
                        RfcApi.RfcCall(client.rfc_handle, name, imports_rfc, importChangings_rfc, importTables_rfc);
                        if (client.throughput != null || monitorOn) {
                            sentBytes = MiddlewareJRfc.this.countBytes(imports_rfc, importChangings_rfc, importTables_rfc);
                        }
                        if (traceLevel > 2) {
                            buf = new FastStringBuffer();
                            buf.append("Execute after RfcCall(").append(client.rfc_handle).append(", ");
                            buf.append(name).append(", ").append(imports_rfc == null ? "null" : Integer.toString(imports_rfc.length));
                            buf.append(", ").append(importChangings_rfc == null ? "null" : Integer.toString(importChangings_rfc.length));
                            buf.append(", ").append(importTables_rfc == null ? "null" : Integer.toString(importTables_rfc.length)).append(')');
                            MiddlewareJRfc.this.trace(3, buf.toString());
                            buf.reset();
                            buf.append("Execute before RfcReceive(").append(client.rfc_handle).append(", ");
                            buf.append(name).append(", ").append(exports_rfc == null ? "null" : Integer.toString(exports_rfc.length));
                            buf.append(", ").append(exportChangings_rfc == null ? "null" : Integer.toString(exportChangings_rfc.length));
                            buf.append(", ").append(exportTables_rfc == null ? "null" : Integer.toString(exportTables_rfc.length)).append(')');
                            MiddlewareJRfc.this.trace(3, buf.toString());
                            if (exports_rfc != null && traceLevel > 4) {
                                int i10 = 0;
                                while (i10 < exports_rfc.length) {
                                    MiddlewareJRfc.this.trace(5, "Expecting Parameter " + exports_rfc[i10].getName());
                                    ++i10;
                                }
                            }
                            if (exportTables_rfc != null && traceLevel > 4) {
                                int i11 = 0;
                                while (i11 < exportTables_rfc.length) {
                                    MiddlewareJRfc.this.trace(5, "Expecting Table " + ((TableParameter)exportTables_rfc[i11]).getName());
                                    ++i11;
                                }
                            }
                        }
                        RfcApi.RfcReceive(client.rfc_handle, exports_rfc, exportChangings_rfc, exportTables_rfc);
                        if (client.throughput != null || monitorOn) {
                            receivedBytes = MiddlewareJRfc.this.countBytes(exports_rfc, exportChangings_rfc, exportTables_rfc);
                        }
                        if (traceLevel > 2) {
                            buf = new FastStringBuffer();
                            buf.append("Execute after RfcReceive(").append(client.rfc_handle).append(", ");
                            buf.append(name).append(", ").append(exports_rfc == null ? "null" : Integer.toString(exports_rfc.length));
                            buf.append(", ").append(exportChangings_rfc == null ? "null" : Integer.toString(exportChangings_rfc.length));
                            buf.append(", ").append(exportTables_rfc == null ? "null" : Integer.toString(exportTables_rfc.length)).append(')');
                            MiddlewareJRfc.this.trace(3, buf.toString());
                        }
                        if (exportTables_rfc != null) {
                            int i12 = 0;
                            while (i12 < exportTables_rfc.length) {
                                ((TableParameter)exportTables_rfc[i12]).table.row = 0;
                                ++i12;
                            }
                        }
                    }
                    tmiddleware = System.currentTimeMillis() - tstart;
                    Object var39_43 = null;
                }
                catch (Throwable throwable) {
                    Object var39_44 = null;
                    ttotal = System.currentTimeMillis() - ttotal;
                    if (client.throughput != null) {
                        JCO.Throughput throughput = client.throughput;
                        synchronized (throughput) {
                            ++client.throughput.num_calls;
                            client.throughput.time_marshall += tmarshall;
                            client.throughput.time_middleware += tmiddleware;
                            client.throughput.time_unmarshall += tunmarshall;
                            client.throughput.time_total += ttotal;
                            client.throughput.num_sent_bytes += sentBytes;
                            client.throughput.num_received_bytes += receivedBytes;
                        }
                    }
                    if (monitorOn) {
                        client.time_middleware = tmiddleware;
                        client.time_total = ttotal;
                        client.num_sent_bytes = sentBytes;
                        client.num_received_bytes = receivedBytes;
                    }
                    throw throwable;
                }
                ttotal = System.currentTimeMillis() - ttotal;
                if (client.throughput != null) {
                    JCO.Throughput throughput = client.throughput;
                    synchronized (throughput) {
                        ++client.throughput.num_calls;
                        client.throughput.time_marshall += tmarshall;
                        client.throughput.time_middleware += tmiddleware;
                        client.throughput.time_unmarshall += tunmarshall;
                        client.throughput.time_total += ttotal;
                        client.throughput.num_sent_bytes += sentBytes;
                        client.throughput.num_received_bytes += receivedBytes;
                    }
                }
                if (monitorOn) {
                    client.time_middleware = tmiddleware;
                    client.time_total = ttotal;
                    client.num_sent_bytes = sentBytes;
                    client.num_received_bytes = receivedBytes;
                }
                break block81;
                {
                    catch (RfcException re) {
                        int rc = re.getRc();
                        if (rc == 2) {
                            throw new JCO.AbapException(re.getMessage());
                        }
                        throw MiddlewareJRfc.this.generateJCoException(re);
                    }
                }
            }
        }

        public void confirmTID(JCO.Client client, String tid) {
            if (client.rfc_handle == 0L) {
                throw new JCO.Exception(121, "JCO_ERROR_NULL_HANDLE", "Invalid rfc_handle = NULL encountered");
            }
            try {
                FastStringBuffer buf;
                if (traceLevel > 2) {
                    buf = new FastStringBuffer();
                    buf.append("ConfirmTid before RfcConfirmTransId(").append(client.rfc_handle);
                    buf.append(", ").append(tid).append(')');
                    MiddlewareJRfc.this.trace(3, buf.toString());
                }
                RfcApi.RfcConfirmTransId(client.rfc_handle, tid);
                if (traceLevel > 2) {
                    buf = new FastStringBuffer();
                    buf.append("ConfirmTid after RfcConfirmTransId(").append(client.rfc_handle);
                    buf.append(", ").append(tid).append(')');
                    MiddlewareJRfc.this.trace(3, buf.toString());
                }
            }
            catch (RfcException re) {
                throw MiddlewareJRfc.this.generateJCoException(re);
            }
        }

        public String createTID(JCO.Client client) {
            if (client.rfc_handle == 0L) {
                throw new JCO.Exception(121, "JCO_ERROR_NULL_HANDLE", "Invalid rfc_handle = NULL encountered");
            }
            try {
                if (traceLevel > 2) {
                    FastStringBuffer buf = new FastStringBuffer();
                    buf.append("CreateTID before RfcCreateTransId(").append(client.rfc_handle);
                    buf.append(')');
                    MiddlewareJRfc.this.trace(3, buf.toString());
                }
                String tid = RfcApi.RfcCreateTransID(client.rfc_handle);
                if (traceLevel > 2) {
                    FastStringBuffer buf = new FastStringBuffer();
                    buf.append("CreateTID after RfcCreateTransId(").append(client.rfc_handle);
                    buf.append(")=").append(tid);
                    MiddlewareJRfc.this.trace(3, buf.toString());
                }
                return tid;
            }
            catch (RfcException re) {
                throw MiddlewareJRfc.this.generateJCoException(re);
            }
        }
    }

    private class Connection {
        Converter converter;

        Connection() {
        }

        protected IRfcParameter getParameter(JCO.ParameterList parameterList, int index) {
            if ((parameterList.flags[index] & 0x70) != 0) {
                return null;
            }
            switch (parameterList.type[index]) {
                case 17: {
                    JCO.Structure struct = (JCO.Structure)parameterList.odata[parameterList.oindex[index]];
                    if ((parameterList.flags[index] & 0x80) != 0) {
                        return new NestedStructure(struct, parameterList.name[index], this.converter, index, parameterList.flags);
                    }
                    if (struct.odata.length == 0) {
                        return new FlatStructure(struct, parameterList.name[index], this.converter, index, parameterList.flags);
                    }
                }
                case 5: 
                case 42: 
                case 99: {
                    return new ComplexParameter((JCO.Record)parameterList.odata[parameterList.oindex[index]], parameterList.name[index], index, parameterList.flags);
                }
            }
            return new Parameter(parameterList, index, this.converter);
        }
    }

    private class DispatchException
    extends Exception {
        private DispatchException() {
            super("foo");
        }
    }
}

