/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.jco;

import com.sap.mw.jco.JCO;
import java.util.Hashtable;
import java.util.Properties;

public abstract class IMiddleware {
    protected static final String JCO_NAME = "jco.middleware.name";
    protected static final String JCO_VERSION = "jco.middleware.version";
    protected static final Properties properties = new Properties();

    public abstract String[][] getPropertyInfo();

    public final Properties getProperties() {
        return properties;
    }

    public final String getProperty(String key) {
        return properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        if (key != null) {
            if (value != null) {
                ((Hashtable)properties).put(key, value);
            } else {
                ((Hashtable)properties).remove(key);
            }
        }
    }

    public final String getName() {
        return properties.getProperty(JCO_NAME);
    }

    public final String getVersion() {
        return properties.getProperty(JCO_VERSION);
    }

    protected int getMaxStartupDelay() {
        return 3600;
    }

    public abstract void setTraceLevel(int var1);

    public abstract IClient getClientInterface();

    public abstract IServer getServerInterface();

    protected String findProperty(String key, Properties props) {
        String value = props.getProperty(key);
        if (value == null && (value = props.getProperty(key = key.substring(key.lastIndexOf(46) + 1))) == null) {
            key = key.toUpperCase();
            value = props.getProperty(key);
        }
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    protected void removeProperty(String key, Properties props) {
        if (((Hashtable)props).containsKey(key)) {
            ((Hashtable)props).remove(key);
        } else if (((Hashtable)props).containsKey(key = key.substring(key.lastIndexOf(46) + 1))) {
            ((Hashtable)props).remove(key);
        } else if (((Hashtable)props).containsKey(key = key.toUpperCase())) {
            ((Hashtable)props).remove(key);
        }
    }

    protected void setConnParams(JCO.Connection conn, String conn_params) {
        conn.conn_params = conn_params;
    }

    protected Object getConnObject(JCO.Connection conn) {
        return conn.conn_object;
    }

    protected void setConnObject(JCO.Connection conn, Object conn_object) {
        conn.conn_object = conn_object;
    }

    protected void setAttributes(JCO.Connection conn, JCO.Attributes attributes) {
        conn.attributes = attributes;
    }

    protected void setState(JCO.Server server, byte state) {
        server.setState(state);
    }

    protected void ensureBufferCapacity(JCO.Record record) {
        record.ensureBufferCapacity();
    }

    protected void appendRows(JCO.Table table, int num_rows) {
        if (num_rows == 1) {
            table.appendRow();
        } else if (num_rows > 1) {
            table.appendRows(num_rows);
        }
    }

    protected void trimToRows(JCO.Table table) {
        table.trimToRows();
        int i = 0;
        while (i < table.opcode.length) {
            table.opcode[i] = 0;
            ++i;
        }
        table.delta = null;
    }

    protected JCO.Function getFunction(JCO.Server server, String function_name) {
        return server.getFunction(function_name);
    }

    protected boolean checkAuthorization(JCO.Server server, String function_name, int authorization_mode, String authorization_partner, byte[] authorization_key) {
        return server.checkAuthorization(function_name, authorization_mode, authorization_partner, authorization_key);
    }

    protected void handleRequest(JCO.Server server, JCO.Function function) throws Exception {
        server.handleRequest(function);
    }

    protected void addTiming(JCO.Throughput throughput, long num_calls, long time_marshall, long time_unmarshall, long time_middleware, long time_handle_request, long time_total, long num_sent_bytes, long num_received_bytes) {
        throughput.num_calls += num_calls;
        throughput.time_marshall += time_marshall;
        throughput.time_unmarshall += time_unmarshall;
        throughput.time_middleware += time_middleware;
        throughput.time_handle_request += time_handle_request;
        throughput.time_total += time_total;
        throughput.num_sent_bytes += num_sent_bytes;
        throughput.num_received_bytes += num_received_bytes;
    }

    protected boolean toBoolean(String arg) {
        if (arg == null) {
            return false;
        }
        return (arg = arg.trim().toLowerCase()).equals("1") || arg.equals("true") || arg.equals("yes");
    }

    public static interface IServer {
        public String[][] getPropertyInfo();

        public void initialize(JCO.Server var1, Properties var2);

        public void listen(JCO.Server var1, String var2);

        public void disconnect(JCO.Server var1);

        public void abort(JCO.Server var1, String var2);

        public boolean isAlive(JCO.Server var1);

        public void getAttributes(JCO.Server var1);
    }

    public static interface IClient {
        public String[][] getPropertyInfo();

        public void initialize(JCO.Client var1, Properties var2);

        public void connect(JCO.Client var1, String var2);

        public void disconnect(JCO.Client var1);

        public void abort(JCO.Client var1, String var2);

        public void reset(JCO.Client var1);

        public boolean isAlive(JCO.Client var1);

        public void getAttributes(JCO.Client var1);

        public void execute(JCO.Client var1, String var2, JCO.ParameterList var3, JCO.ParameterList var4, JCO.ParameterList var5, JCO.ParameterList var6, String var7, String var8, int var9);

        public void confirmTID(JCO.Client var1, String var2);

        public String createTID(JCO.Client var1);
    }
}

