/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.xmlwriter;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.xml.sax.SAXException;

public class XMLWriter {
    String m_prefix = "";
    Writer m_writer;

    public void dataElement(String name, String content) throws SAXException, IOException {
        this.m_writer.write(this.m_prefix + "<" + name + ">");
        this.writeContent(content);
        this.m_writer.write("</" + name + ">\n");
    }

    public void startElement(String name) throws SAXException, IOException {
        this.m_writer.write(this.m_prefix + "<" + name + ">\n");
        this.m_prefix = this.m_prefix + "  ";
    }

    public void startElement(String name, int version) throws SAXException, IOException {
        this.m_writer.write(this.m_prefix + "<" + name + " version=\"" + String.valueOf(version) + "\">\n");
        this.m_prefix = this.m_prefix + "  ";
    }

    public void endElement(String name) throws SAXException, IOException {
        if (this.m_prefix.length() >= 2) {
            this.m_prefix = this.m_prefix.substring(0, this.m_prefix.length() - 2);
        }
        this.m_writer.write(this.m_prefix + "</" + name + ">\n");
    }

    public void startDocument() throws SAXException {
        try {
            this.m_writer.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
    }

    public void flush() throws IOException {
        this.m_writer.flush();
    }

    private void writeContent(String content) throws SAXException {
        char[] ch = content.toCharArray();
        this.writeEsc(ch, 0, ch.length, false);
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        this.writeEsc(ch, start, len, false);
    }

    public void setOutput(Writer writer) {
        this.m_writer = writer == null ? new OutputStreamWriter(System.out) : writer;
    }

    private void write(String s) throws SAXException {
        try {
            this.m_writer.write(s);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void write(char c) throws SAXException {
        try {
            this.m_writer.write(c);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void writeEsc(char[] ch, int start, int length, boolean isAttVal) throws SAXException {
        int i = start;
        while (i < start + length) {
            switch (ch[i]) {
                case '&': {
                    this.write("&amp;");
                    break;
                }
                case '<': {
                    this.write("&lt;");
                    break;
                }
                case '>': {
                    this.write("&gt;");
                    break;
                }
                case '\"': {
                    if (isAttVal) {
                        this.write("&quot;");
                        break;
                    }
                    this.write('\"');
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    this.write(ch[i]);
                    break;
                }
                default: {
                    if (ch[i] > '\u007f') {
                        this.write("&#");
                        this.write(Integer.toString(ch[i]));
                        this.write(';');
                        break;
                    }
                    if (ch[i] < ' ') break;
                    this.write(ch[i]);
                }
            }
            ++i;
        }
    }
}

