/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.uuid;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;

public class UUID
implements Serializable,
Comparable {
    private static final int UUIDsPerTick = 128;
    private static byte[] internetAddress;
    private static long lastTime;
    private static int uuidsThisTick;
    private static UUID previousUUID;
    private static long nextSave;
    private static Random randomGenerator;
    private static char[] hexDigits;
    private long time;
    private short clockSequence;
    private byte version = 1;
    private byte[] node = new byte[6];
    private byte[] uuid;
    static /* synthetic */ Class class$com$sapportals$trex$util$uuid$UUID;

    public UUID() {
        this.time = UUID.getCurrentTime();
        Class clazz = class$com$sapportals$trex$util$uuid$UUID == null ? (class$com$sapportals$trex$util$uuid$UUID = UUID.class$("com.sapportals.trex.util.uuid.UUID")) : class$com$sapportals$trex$util$uuid$UUID;
        synchronized (clazz) {
            if (previousUUID == null || this.nodeChanged(previousUUID)) {
                this.clockSequence = (short)randomGenerator.nextInt();
                this.node = UUID.computeNodeAddress();
            } else if (this.time < previousUUID.getTime()) {
                this.clockSequence = (short)(this.clockSequence + 1);
                this.node = previousUUID.getNode();
            }
            previousUUID = this;
        }
        this.uuid = this.genUUID();
    }

    public UUID(byte[] node) {
        this.time = UUID.getCurrentTime();
        this.node = node;
        this.uuid = this.genUUID();
    }

    public UUID(String str) throws NumberFormatException {
        this.uuid = this.parseUUID(str);
        this.time = this.uuid[7] & 0xF;
        int i = 1;
        while (i < 8) {
            this.time <<= 8;
            this.time |= (long)this.uuid[7 - i];
            ++i;
        }
        this.version = (byte)(this.uuid[7] >> 4);
        this.clockSequence = (short)((this.uuid[9] & 0x3F) << 8 | this.uuid[8]);
        int i2 = 0;
        while (i2 < 6) {
            this.node[i2] = this.uuid[10 + i2];
            ++i2;
        }
    }

    public int compareTo(Object withUUID) {
        if (!(withUUID instanceof UUID)) {
            return -1;
        }
        byte[] other = ((UUID)withUUID).getUUID();
        int i = 0;
        while (i < 16) {
            if (this.uuid[i] < other[i]) {
                return -1;
            }
            if (this.uuid[i] > other[i]) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public int getClockSequence() {
        return this.clockSequence;
    }

    public byte[] getNode() {
        return this.node;
    }

    public long getTime() {
        return this.time;
    }

    public byte[] getUUID() {
        return this.uuid;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean equals(Object toUUID) {
        return this.compareTo(toUUID) == 0;
    }

    public String toString() {
        byte[] uuid = this.getUUID();
        StringBuffer buffer = new StringBuffer(256);
        int i = 0;
        while (i < 16) {
            buffer.append(hexDigits[(uuid[i] & 0xF0) >> 4]);
            buffer.append(hexDigits[uuid[i] & 0xF]);
            if (i == 3 || i == 5 || i == 7 || i == 9) {
                buffer.append('-');
            }
            ++i;
        }
        return buffer.toString();
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < 16) {
            hash ^= this.uuid[i];
            hash <<= 2;
            ++i;
        }
        return hash;
    }

    private byte[] genUUID() {
        byte[] uuid = new byte[16];
        long t = this.time;
        int i = 0;
        while (i < 8) {
            uuid[i] = (byte)(t >> 8 * i & 0xFFL);
            ++i;
        }
        uuid[7] = (byte)(uuid[7] | (byte)(this.version << 4));
        uuid[8] = (byte)(this.clockSequence & 0xFF);
        uuid[9] = (byte)((this.clockSequence & 0x3F00) >> 8);
        uuid[9] = (byte)(uuid[9] | 0x80);
        int i2 = 0;
        while (i2 < 6) {
            uuid[10 + i2] = this.node[i2];
            ++i2;
        }
        return uuid;
    }

    private boolean nodeChanged(UUID previousUUID) {
        if (previousUUID != null) {
            byte[] previousNode = previousUUID.getNode();
            int i = 0;
            while (i < previousNode.length) {
                if (this.node[i] != previousNode[i]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private byte[] parseUUID(String str) throws NumberFormatException {
        StringBuffer buf = new StringBuffer(32);
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') {
                buf.append(ch);
            } else if (ch >= 'A' && ch <= 'F') {
                buf.append(ch);
            } else if (ch >= 'a' && ch <= 'f') {
                buf.append(ch);
            } else if (ch != ' ' && ch != '-') {
                throw new NumberFormatException("Invalid UUID string");
            }
            ++i;
        }
        if (buf.length() != 32) {
            throw new NumberFormatException("Invalid UUID string");
        }
        byte[] uuid = new byte[16];
        int i2 = 0;
        while (i2 < 16) {
            uuid[i2] = (byte)(Character.digit(buf.charAt(i2 + i2), 16) << 4 | Character.digit(buf.charAt(i2 + i2 + 1), 16));
            ++i2;
        }
        return uuid;
    }

    private static byte[] computeNodeAddress() {
        int thread = Thread.currentThread().hashCode();
        long time = System.currentTimeMillis();
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        try {
            out.write(internetAddress);
            out.write(thread);
            out.writeLong(time);
            out.close();
        }
        catch (IOException x) {
            // empty catch block
        }
        byte[] rand = byteOut.toByteArray();
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            md5.update(rand);
        }
        catch (NoSuchAlgorithmException x) {
            System.err.println("No MD5 algorithm available: " + x);
        }
        byte[] temp = md5.digest();
        byte[] address = new byte[6];
        int i = 0;
        while (i < address.length) {
            address[i] = temp[i + 5];
            ++i;
        }
        address[0] = (byte)(address[0] | 0xFFFFFF80);
        return address;
    }

    private static long getCurrentTime() {
        long now = 0L;
        boolean waitForTick = true;
        while (waitForTick) {
            now = new Date().getTime();
            if (lastTime < now) {
                uuidsThisTick = 0;
                waitForTick = false;
                continue;
            }
            if (uuidsThisTick >= 128) continue;
            ++uuidsThisTick;
            waitForTick = false;
        }
        lastTime = now += (long)uuidsThisTick;
        return now;
    }

    private static UUID getUUIDState() {
        return new UUID(UUID.computeNodeAddress());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        lastTime = System.currentTimeMillis();
        uuidsThisTick = 128;
        nextSave = System.currentTimeMillis();
        randomGenerator = new Random(System.currentTimeMillis());
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            internetAddress = InetAddress.getLocalHost().getAddress();
        }
        catch (Exception x) {
            System.out.println("UUID: Can't get host address: " + x);
            x.printStackTrace();
        }
    }
}

