/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.string;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class StrUtil {
    private static char DELIMITER = (char)124;

    public static Set extractStringComponentsToSet(String s, int separator, boolean trim) {
        LinkedList list = StrUtil.extractStringComponents(s, separator, trim);
        HashSet result = new HashSet(list.size());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static String[] extractStringComponentsToArray(String s, int separator, boolean trim) {
        LinkedList list = StrUtil.extractStringComponents(s, separator, trim);
        String[] result = new String[list.size()];
        Iterator it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            result[i++] = (String)it.next();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static LinkedList extractStringComponents(String s, int separator, boolean trim) {
        if (s == null) {
            throw new NullPointerException();
        }
        LinkedList<String> result = new LinkedList<String>();
        if (s.length() > 0 && s.charAt(0) == separator) {
            s = s.substring(1);
        }
        if (s.length() > 0 && s.charAt(s.length() - 1) == separator) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.length() > 0) {
            int separatorPos;
            while ((separatorPos = s.indexOf(separator)) >= 0) {
                void var4_4;
                result.add(trim ? s.substring(0, (int)var4_4).trim() : s.substring(0, (int)var4_4));
                s = var4_4 + true < s.length() ? s.substring((int)(var4_4 + true)) : "";
            }
            if (s.length() > 0) {
                result.add(trim ? s.trim() : s);
            }
        }
        return result;
    }

    public static Set extractStringComponentsToSet(String s, String separators, boolean trim) {
        LinkedList list = StrUtil.extractStringComponents(s, separators, trim);
        HashSet result = new HashSet(list.size());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static String[] extractStringComponentsToArray(String s, String separators, boolean trim) {
        LinkedList list = StrUtil.extractStringComponents(s, separators, trim);
        String[] result = new String[list.size()];
        Iterator it = list.iterator();
        int i = 0;
        while (it.hasNext()) {
            result[i++] = (String)it.next();
        }
        return result;
    }

    public static LinkedList extractStringComponents(String s, String separators, boolean trim) {
        if (s == null || separators == null) {
            throw new NullPointerException();
        }
        LinkedList<String> result = new LinkedList<String>();
        if (s.length() > 0 && separators.indexOf(s.charAt(0)) >= 0) {
            s = s.substring(1);
        }
        if (s.length() > 0 && separators.indexOf(s.charAt(s.length() - 1)) >= 0) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.length() > 0) {
            while (true) {
                int separatorPos = -1;
                int i = 0;
                while (i < s.length()) {
                    if (separators.indexOf(s.charAt(i)) >= 0) {
                        separatorPos = i;
                        break;
                    }
                    ++i;
                }
                if (separatorPos < 0) break;
                result.add(trim ? s.substring(0, separatorPos).trim() : s.substring(0, separatorPos));
                if (separatorPos + 1 < s.length()) {
                    s = s.substring(separatorPos + 1);
                    continue;
                }
                s = "";
            }
            if (s.length() > 0) {
                result.add(trim ? s.trim() : s);
            }
        }
        return result;
    }

    public static String[] extractStringComponentsToArray(String s, String separators, boolean trim, int escapeCharacter) {
        LinkedList<String> strings = new LinkedList<String>();
        String currentValue = "";
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == escapeCharacter) {
                if (i + 1 >= s.length()) break;
                currentValue = currentValue + s.charAt(++i);
            } else if (separators.indexOf(c) >= 0) {
                strings.add(currentValue);
                currentValue = "";
            } else {
                currentValue = currentValue + c;
            }
            ++i;
        }
        if (currentValue.length() > 0) {
            strings.add(currentValue);
        }
        String[] result = new String[strings.size()];
        Iterator stringsIterator = strings.iterator();
        int resultIdx = 0;
        while (stringsIterator.hasNext()) {
            result[resultIdx++] = (String)stringsIterator.next();
        }
        return result;
    }

    public static String[] extractStringComponentsToArray(String s, int separator, boolean trim, int escapeCharacter) {
        return StrUtil.extractStringComponentsToArray(s, "" + (char)separator, trim, escapeCharacter);
    }

    public static String replace(String text, String oldString, String newString, boolean all) {
        int pos;
        if (text == null || oldString == null || oldString.length() == 0 || newString == null) {
            return null;
        }
        StringBuffer result = null;
        int oldpos = 0;
        while ((pos = text.indexOf(oldString, oldpos)) >= 0) {
            if (result == null) {
                result = new StringBuffer();
            }
            result.append(text.substring(oldpos, pos));
            result.append(newString);
            oldpos = pos += oldString.length();
            if (all) continue;
        }
        if (oldpos == 0) {
            return text;
        }
        result.append(text.substring(oldpos));
        return new String(result);
    }

    public static boolean match(String pattern, String string, boolean ignoreCase) {
        if (pattern == null && string == null) {
            return true;
        }
        if (pattern == null || string == null) {
            return false;
        }
        if (pattern.equals("*")) {
            return true;
        }
        if (string.indexOf(42) >= 0) {
            return true;
        }
        if (string.indexOf(63) >= 0) {
            return true;
        }
        if (ignoreCase) {
            pattern = pattern.toUpperCase();
            string = string.toUpperCase();
        }
        int psave = -1;
        int ssave = -1;
        int patternIdx = 0;
        int stringIdx = 0;
        int patternLength = pattern.length();
        int stringLength = string.length();
        while (true) {
            if (patternIdx < patternLength && stringIdx < stringLength && pattern.charAt(patternIdx) == string.charAt(stringIdx)) {
                ++patternIdx;
                ++stringIdx;
                continue;
            }
            if (patternIdx >= patternLength && stringIdx >= stringLength) {
                return true;
            }
            if (stringIdx < stringLength && patternIdx < patternLength && pattern.charAt(patternIdx) == '?') {
                ++patternIdx;
                ++stringIdx;
                continue;
            }
            if (patternIdx < patternLength && pattern.charAt(patternIdx) == '*') {
                psave = ++patternIdx;
                ssave = stringIdx;
                continue;
            }
            if (ssave == -1 || ssave >= stringLength) break;
            stringIdx = ++ssave;
            patternIdx = psave;
        }
        return false;
    }
}

