/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.logging;

import com.sap.tc.logging.Location;
import com.sapportals.trex.util.logging.LoggingConfigurator;
import com.sapportals.trex.util.logging.LoggingFormatter;
import com.sapportals.trex.util.string.StrUtil;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class LoggingInitializer {
    private static LoggingInitializer inst = null;
    private Map confFiles = new HashMap();
    static /* synthetic */ Class class$com$sapportals$trex$util$logging$LoggingInitializer;

    private LoggingInitializer() {
    }

    public static synchronized LoggingInitializer getInstance() {
        if (inst == null) {
            try {
                inst = new LoggingInitializer();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return inst;
    }

    public synchronized void registerConfigurationWithDefaultConfigFile() {
        File file = this.getDefaultConfigFile();
        if (file == null) {
            System.out.println("No configuration file for TREX logging found. Logger might have been initialized before.");
        } else {
            System.out.println("Configuration file for TREX logging found: " + file.getAbsolutePath());
            this.registerConfiguration(file);
        }
    }

    public synchronized void registerConfiguration(File configurationFile) {
        try {
            if (configurationFile == null) {
                throw new IllegalArgumentException("Configuration file may not be null!");
            }
            if (!configurationFile.exists()) {
                throw new IllegalArgumentException("Configuration file does not exist!");
            }
            if (!this.confFiles.containsKey(configurationFile)) {
                LoggingConfigurator loggingConfigurator = new LoggingConfigurator(configurationFile);
                loggingConfigurator.configure();
                loggingConfigurator.setPeriodicity(1000);
                this.confFiles.put(configurationFile, loggingConfigurator);
                Location logger = Location.getLocation((Class)(class$com$sapportals$trex$util$logging$LoggingInitializer == null ? (class$com$sapportals$trex$util$logging$LoggingInitializer = LoggingInitializer.class$("com.sapportals.trex.util.logging.LoggingInitializer")) : class$com$sapportals$trex$util$logging$LoggingInitializer));
                logger.fatalT("registerConfiguration(<line>)", "Successfully initialized logging based on the configuration file " + configurationFile.getAbsolutePath() + " in: " + LoggingFormatter.extractCallstack(new Exception()));
            } else {
                Location logger = Location.getLocation((Class)(class$com$sapportals$trex$util$logging$LoggingInitializer == null ? (class$com$sapportals$trex$util$logging$LoggingInitializer = LoggingInitializer.class$("com.sapportals.trex.util.logging.LoggingInitializer")) : class$com$sapportals$trex$util$logging$LoggingInitializer));
                logger.fatalT("registerConfiguration(<line>)", "Ignored logging re-initialization based on the configuration file " + configurationFile.getAbsolutePath() + " in: " + LoggingFormatter.extractCallstack(new Exception()));
            }
        }
        catch (Error error) {
            System.err.println("Failed to initialize logging by configuration file " + configurationFile + ": " + LoggingFormatter.extractCallstack(error));
            throw error;
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Failed to initialize logging by configuration file " + configurationFile + ": " + LoggingFormatter.extractCallstack(runtimeException));
            throw runtimeException;
        }
        catch (Throwable throwable) {
            System.err.println("Failed to initialize logging by configuration file " + configurationFile + ": " + LoggingFormatter.extractCallstack(throwable));
            throw new RuntimeException("Failed to initialize logging by configuration file " + configurationFile + ": " + LoggingFormatter.extractCallstack(throwable));
        }
    }

    public synchronized void registerConfiguration(URL configurationURL) {
        try {
            if (configurationURL == null) {
                throw new IllegalArgumentException("Configuration URL may not be null!");
            }
            if (!"file".equalsIgnoreCase(configurationURL.getProtocol())) {
                throw new IllegalArgumentException("Configuration URL is not of FILE protocol!");
            }
            this.registerConfiguration(new File(configurationURL.getFile()));
        }
        catch (Error error) {
            System.err.println("Failed to initialize logging by configuration URL " + configurationURL + ": " + LoggingFormatter.extractCallstack(error));
            throw error;
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Failed to initialize logging by configuration URL " + configurationURL + ": " + LoggingFormatter.extractCallstack(runtimeException));
            throw runtimeException;
        }
        catch (Throwable throwable) {
            System.err.println("Failed to initialize logging by configuration URL " + configurationURL + ": " + LoggingFormatter.extractCallstack(throwable));
            throw new RuntimeException("Failed to initialize logging by configuration URL " + configurationURL + ": " + LoggingFormatter.extractCallstack(throwable));
        }
    }

    public synchronized void registerConfiguration(String resourceName) {
        try {
            if (resourceName == null) {
                throw new IllegalArgumentException("Resource name may not be null!");
            }
            this.registerConfiguration(new File(this.getClass().getResource(resourceName).getFile()));
        }
        catch (Error error) {
            System.err.println("Failed to initialize logging by configuration resource name " + resourceName + ": " + LoggingFormatter.extractCallstack(error));
            throw error;
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Failed to initialize logging by configuration resource name " + resourceName + ": " + LoggingFormatter.extractCallstack(runtimeException));
            throw runtimeException;
        }
        catch (Throwable throwable) {
            System.err.println("Failed to initialize logging by configuration resource name " + resourceName + ": " + LoggingFormatter.extractCallstack(throwable));
            throw new RuntimeException("Failed to initialize logging by configuration resource name " + resourceName + ": " + LoggingFormatter.extractCallstack(throwable));
        }
    }

    private File getDefaultConfigFile() {
        String CONFIG_FILE = "logging.properties";
        String path = LoggingInitializer.findConfigurationFilePath(LoggingInitializer.getClassPath(this.getClass()), CONFIG_FILE);
        if (path == null) {
            return null;
        }
        return new File(path, CONFIG_FILE);
    }

    private static String getClassPath(Class cls) {
        try {
            ClassLoader cl = cls.getClassLoader();
            String rsrc = cls.getName().replace('.', '/') + ".class";
            String url = cl.getResource(rsrc).toString();
            if (url.startsWith("jar:file:")) {
                return url.substring(9, url.length() - rsrc.length() - 2);
            }
            if (url.startsWith("file:")) {
                return url.substring(6);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String findConfigurationFilePath(String classpath, String confFile) {
        boolean found = false;
        String path = classpath;
        Object file = null;
        if (path != null) {
            String dir = new File(path).getParent();
            found = new File(dir, confFile).exists();
            if (found) {
                return dir;
            }
            System.out.println("LoggingInitializer before unescaping: dir: " + dir + " confFile : " + confFile);
            dir = StrUtil.replace(dir, "%20", " ", true);
            found = new File(dir, confFile).exists();
            System.out.println("LoggingInitializer after unescaping: dir: " + dir + " confFile : " + confFile);
            if (found) {
                return dir;
            }
        }
        StringTokenizer paths = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        confFile = System.getProperty("file.separator") + confFile;
        while (!found && paths.hasMoreTokens()) {
            path = paths.nextToken();
            found = new File(path, confFile).exists();
            if (found) {
                return path;
            }
            path = new File(path).getParent();
            found = new File(path, confFile).exists();
            System.out.println("LoggingInitializer: path(one up): " + path + " confFile : " + confFile);
            if (!found) continue;
            return path;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

