/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.logging;

import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.TraceFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;

public class LoggingFormatter
extends TraceFormatter {
    public static String extractCallstack(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public String format(LogRecord rec) {
        String[] args = new String[7];
        int[] width = new int[7];
        int[] align = new int[7];
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss.SSS");
        args[0] = dateFormat.format(rec.getTime());
        width[0] = 25;
        align[0] = 1;
        args[1] = " ";
        align[1] = 0;
        String loc = rec.getLocation();
        int end = loc.lastIndexOf("(");
        if (end < 0) {
            end = loc.length();
        }
        end = loc.lastIndexOf(".", end);
        end = loc.lastIndexOf(".", end - 1);
        args[2] = loc.substring(end + 1) + " [" + rec.getThread() + "]";
        width[2] = Math.max(80, args[2].length());
        align[2] = 1;
        args[3] = " ";
        align[3] = 0;
        args[4] = Severity.toString((int)rec.getSeverity()) + ":";
        align[4] = 0;
        args[5] = " ";
        align[5] = 0;
        switch (rec.getMsgType()) {
            case 0: {
                args[6] = rec.getMsgClear();
                break;
            }
            case 1: {
                args[6] = MessageFormat.format(rec.getMsgClear(), rec.getArgs().toArray());
            }
        }
        align[6] = 0;
        return this.align(args, width, align);
    }
}

