/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.db;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexReturn;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBWrapper {
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$util$db$DBWrapper == null ? (class$com$sapportals$trex$util$db$DBWrapper = DBWrapper.class$("com.sapportals.trex.util.db.DBWrapper")) : class$com$sapportals$trex$util$db$DBWrapper).getName());
    private Connection dbConn;
    private Statement dbState;
    static /* synthetic */ Class class$com$sapportals$trex$util$db$DBWrapper;

    public DBWrapper(Connection connection) throws SQLException {
        this.dbConn = connection;
        this.dbState = this.dbConn.createStatement();
    }

    public void close() throws SQLException {
        try {
            this.dequeue();
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            if (this.dbState != null) {
                this.dbState.close();
            }
            if (this.dbConn != null) {
                this.dbConn.close();
            }
        }
        catch (SQLException sqle) {
            log.errorT(new TrexReturn(7602, sqle.getMessage()).getMsg());
            throw sqle;
        }
    }

    public void closeByError() throws SQLException {
        this.rollback();
        if (!this.dbConn.getAutoCommit()) {
            try {
                this.dbConn.setAutoCommit(true);
            }
            catch (SQLException sqle) {
                log.errorT(new TrexReturn(7604, sqle.getMessage()).getMsg());
            }
        }
        try {
            if (this.dbState != null) {
                this.dbState.close();
            }
            if (this.dbConn != null) {
                this.dbConn.close();
            }
        }
        catch (SQLException sqle) {
            log.errorT(new TrexReturn(7602, sqle.getMessage()).getMsg());
            throw sqle;
        }
    }

    public void enqueue() throws SQLException {
        this.dbConn.setAutoCommit(false);
    }

    public void dequeue() throws SQLException {
        TrexReturn ret = null;
        try {
            this.dbConn.commit();
        }
        catch (SQLException sqle) {
            ret = new TrexReturn(7605, sqle.getMessage());
            log.errorT(ret.getMsg());
            try {
                this.dbConn.rollback();
            }
            catch (SQLException sqlr) {
                ret = new TrexReturn(7601, sqlr.getMessage());
                log.errorT(ret.getMsg());
            }
            throw sqle;
        }
        try {
            this.dbConn.setAutoCommit(true);
        }
        catch (SQLException sqle) {
            ret = new TrexReturn(7604, sqle.getMessage());
            log.errorT(ret.getMsg());
            throw sqle;
        }
    }

    public ResultSet doSelect(String sqlQuery) throws SQLException {
        ResultSet rs;
        try {
            log.debugT(new TrexReturn(7607, sqlQuery).getMsg());
            rs = this.dbState.executeQuery(sqlQuery);
        }
        catch (SQLException sqle) {
            TrexReturn ret = new TrexReturn(7600, sqlQuery, sqle.getMessage());
            log.errorT(ret.getMsg());
            try {
                this.close();
            }
            catch (SQLException sqlc) {
                // empty catch block
            }
            throw sqle;
        }
        return rs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doUpdate(String sqlQuery) throws SQLException {
        try {
            log.debugT(new TrexReturn(7607, sqlQuery).getMsg());
            this.dbState.executeUpdate(sqlQuery);
            return;
        }
        catch (SQLException sqle) {
            TrexReturn ret = new TrexReturn(7600, sqlQuery, sqle.getMessage());
            log.errorT(ret.getMsg());
            try {
                this.dbConn.rollback();
                log.infoT(new TrexReturn(7606).getMsg());
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    this.close();
                    throw throwable;
                }
                catch (SQLException sqlc) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException sqlc) {}
            this.close();
            throw sqle;
            throw sqle;
        }
    }

    public void rollback() throws SQLException {
        try {
            this.dbConn.rollback();
            log.infoT(new TrexReturn(7606).getMsg());
        }
        catch (SQLException sqlr) {
            TrexReturn ret = new TrexReturn(7601, sqlr.getMessage());
            log.errorT(ret.getMsg());
            throw sqlr;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

