/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.config.file;

import com.sap.tc.logging.Location;
import com.sapportals.trex.TrexException;
import com.sapportals.trex.util.config.IPropertyStore;
import com.sapportals.trex.util.config.file.ConfigCollection;
import com.sapportals.trex.util.config.file.PropertiesFile;
import com.sapportals.trex.util.string.StrUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropertyStoreFile
implements IPropertyStore {
    private static Location log = Location.getLocation((String)(class$com$sapportals$trex$util$config$file$PropertyStoreFile == null ? (class$com$sapportals$trex$util$config$file$PropertyStoreFile = PropertyStoreFile.class$("com.sapportals.trex.util.config.file.PropertyStoreFile")) : class$com$sapportals$trex$util$config$file$PropertyStoreFile).getName());
    private static String FILENAME = "trexjavaclient.properties";
    private String m_configName = null;
    private File m_configFile = null;
    private String m_path = null;
    private String m_absConfigPath = null;
    private Properties m_properties = null;
    static /* synthetic */ Class class$com$sapportals$trex$util$config$file$PropertyStoreFile;

    private PropertyStoreFile(String configName) throws TrexException {
        this.m_path = PropertyStoreFile.findConfigurationFilePath(PropertyStoreFile.getClassPath(this.getClass()), configName);
        this.m_configName = configName;
        this.m_configFile = new File(this.m_path, this.m_configName);
        this.m_absConfigPath = this.m_configFile.getAbsolutePath();
        this.m_properties = PropertyStoreFile.readConfiguration(this.m_configFile);
        log.infoT("loaded config file: " + this.m_configFile.getAbsolutePath());
    }

    public static PropertyStoreFile getInstance() throws TrexException {
        Class clazz = class$com$sapportals$trex$util$config$file$PropertyStoreFile == null ? (class$com$sapportals$trex$util$config$file$PropertyStoreFile = PropertyStoreFile.class$("com.sapportals.trex.util.config.file.PropertyStoreFile")) : class$com$sapportals$trex$util$config$file$PropertyStoreFile;
        synchronized (clazz) {
            PropertyStoreFile propertyStoreFile = new PropertyStoreFile(FILENAME);
            return propertyStoreFile;
        }
    }

    public String getProperty(String base, String key) throws TrexException {
        return this.m_properties.getProperty(base + "." + key);
    }

    public Properties getProperties(String base) throws TrexException {
        Properties propClone = null;
        PropertyStoreFile propertyStoreFile = this;
        synchronized (propertyStoreFile) {
            propClone = (Properties)((Hashtable)this.m_properties).clone();
        }
        Properties p = new Properties();
        String prefix = base + ".";
        Enumeration<?> keys = propClone.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.startsWith(prefix)) {
                ((Hashtable)p).put(key.substring(prefix.length()), ((Hashtable)propClone).get(key));
                continue;
            }
            if (!key.equals(base)) continue;
            ((Hashtable)p).put("", ((Hashtable)propClone).get(key));
        }
        return p;
    }

    public Properties getProperties() throws TrexException {
        Properties p = null;
        PropertyStoreFile propertyStoreFile = this;
        synchronized (propertyStoreFile) {
            p = (Properties)((Hashtable)this.m_properties).clone();
        }
        return p;
    }

    public void setProperty(String configClass, String base, String key, String value) throws TrexException {
        Properties properties = this.m_properties;
        synchronized (properties) {
            this.m_properties.setProperty(base + "." + key, value);
            this.store();
        }
    }

    public void setProperties(String configClass, String base, Properties props) throws TrexException {
        Properties properties = this.m_properties;
        synchronized (properties) {
            Enumeration<?> keys = props.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.m_properties.setProperty(base + "." + key, props.getProperty(key));
            }
            this.store();
        }
    }

    public void removeConfigurable(String base) throws TrexException {
        Properties properties = this.m_properties;
        synchronized (properties) {
            boolean changed = false;
            Enumeration<?> keys = this.m_properties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith(base + '.')) continue;
                ((Hashtable)this.m_properties).remove(key);
                changed = true;
            }
            if (changed) {
                this.store();
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public String[] listConfigurables(String configClass) throws TrexException {
        throw new UnsupportedOperationException("Method listConfigurables() not yet implemented.");
    }

    private void store() {
        Properties propClone = null;
        log.debugT("Start writing property file '" + this.getPath() + "'");
        PropertyStoreFile propertyStoreFile = this;
        synchronized (propertyStoreFile) {
            propClone = (Properties)((Hashtable)this.m_properties).clone();
        }
        ConfigCollection root = new ConfigCollection(null);
        Iterator iter = ((Hashtable)propClone).keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            String value = propClone.getProperty(key);
            root.putProperty(key, value);
        }
        PropertiesFile propFile = new PropertiesFile(this.m_absConfigPath);
        propFile.write(root);
        log.debugT("Finished writing property file '" + this.getPath() + "'");
    }

    private static String getClassPath(Class cls) {
        try {
            ClassLoader cl = cls.getClassLoader();
            String rsrc = cls.getName().replace('.', '/') + ".class";
            String url = cl.getResource(rsrc).toString();
            if (url.startsWith("jar:file:")) {
                return url.substring(9, url.length() - rsrc.length() - 2);
            }
            if (url.startsWith("file:")) {
                return url.substring(5);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Properties readConfiguration(File configFile) throws TrexException {
        Properties props = new Properties();
        try {
            FileInputStream input = new FileInputStream(configFile);
            props.load(input);
            ((InputStream)input).close();
        }
        catch (Exception e) {
            throw new TrexException(7211, configFile.getAbsolutePath());
        }
        return props;
    }

    private static String findConfigurationFilePath(String classpath, String confFile) {
        boolean found = false;
        String path = classpath;
        Object file = null;
        if (path != null) {
            String dir = new File(path).getParent();
            found = new File(dir, confFile).exists();
            if (found) {
                return dir;
            }
            System.out.println("PropertyStoreFile before unescaping: dir: " + dir + " confFile : " + confFile);
            dir = StrUtil.replace(dir, "%20", " ", true);
            found = new File(dir, confFile).exists();
            System.out.println("PropertyStoreFile after unescaping: dir: " + dir + " confFile : " + confFile + " found:" + found);
            if (found) {
                return dir;
            }
        }
        StringTokenizer paths = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        confFile = System.getProperty("file.separator") + confFile;
        while (!found && paths.hasMoreTokens()) {
            path = paths.nextToken();
            found = new File(path, confFile).exists();
            if (found) {
                return path;
            }
            path = new File(path).getParent();
            found = new File(path, confFile).exists();
            System.out.println("PropertyStoreFile: path(one up): " + path + " confFile : " + confFile);
            if (!found) continue;
            return path;
        }
        return null;
    }

    private String getPath() {
        return this.m_configFile.getAbsolutePath();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

