/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.trex.util.config.file;

import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class ConfigCollection {
    String m_Name;
    Map m_Children;
    Map m_Properties;

    public ConfigCollection(String name) {
        this.m_Name = name;
        this.m_Children = new TreeMap();
        this.m_Properties = new TreeMap();
    }

    public String getName() {
        return this.m_Name;
    }

    public void addChild(ConfigCollection configCollection) {
        this.m_Children.put(configCollection.getName(), configCollection);
    }

    public void removeChild(String name) {
        this.m_Children.remove(name);
    }

    public ConfigCollection getChild(String name) {
        return (ConfigCollection)this.m_Children.get(name);
    }

    public ConfigCollection getByPath(String path) {
        if (path == null) {
            return this;
        }
        StringTokenizer t = new StringTokenizer(path, "./");
        ConfigCollection collection = this;
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if ((collection = collection.getChild(token)) != null) continue;
            collection = new ConfigCollection(token);
        }
        return collection;
    }

    public void setByPath(String path, ConfigCollection configCollection) {
        StringTokenizer t = new StringTokenizer(path, "./");
        ConfigCollection collection = this;
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (t.hasMoreTokens()) {
                ConfigCollection next = collection.getChild(token);
                if (next == null) {
                    next = new ConfigCollection(token);
                    collection.addChild(next);
                }
                collection = next;
                continue;
            }
            collection.addChild(configCollection);
        }
    }

    public Collection getChildren() {
        return this.m_Children.values();
    }

    public void putProperty(String name, String value) {
        if (name.indexOf(".") < 0) {
            this.m_Properties.put(name, value);
        } else {
            StringTokenizer t = new StringTokenizer(name, ".");
            ConfigCollection collection = this;
            while (collection != null && t.hasMoreTokens()) {
                String token = t.nextToken();
                if (t.hasMoreTokens()) {
                    ConfigCollection next = collection.getChild(token);
                    if (next == null) {
                        next = new ConfigCollection(token);
                        collection.addChild(next);
                    }
                    collection = next;
                    continue;
                }
                collection.m_Properties.put(token, value);
            }
        }
    }

    public void removeProperty(String name) {
        if (name.indexOf(".") < 0) {
            this.m_Properties.remove(name);
        } else {
            StringTokenizer t = new StringTokenizer(name, ".");
            ConfigCollection collection = this;
            while (collection != null && t.hasMoreTokens()) {
                String token = t.nextToken();
                if (t.hasMoreTokens()) {
                    ConfigCollection next = collection.getChild(token);
                    if (next == null) {
                        next = new ConfigCollection(token);
                        collection.addChild(next);
                    }
                    collection = next;
                    continue;
                }
                collection.m_Properties.remove(token);
            }
        }
    }

    public Collection getPropertyNames() {
        return this.m_Properties.keySet();
    }

    public String getProperty(String name) {
        String token;
        if (name.indexOf(".") < 0) {
            return (String)this.m_Properties.get(name);
        }
        StringTokenizer t = new StringTokenizer(name, ".");
        for (ConfigCollection collection = this; collection != null && t.hasMoreTokens(); collection = collection.getChild(token)) {
            token = t.nextToken();
            if (t.hasMoreTokens()) {
                continue;
            }
            return (String)collection.m_Properties.get(token);
        }
        return null;
    }
}

